/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.intercept.web;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.textui.TestRunner;
import org.acegisecurity.MockFilterChain;
import org.acegisecurity.intercept.web.FilterInvocation;
import org.jmock.MockObjectTestCase;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class FilterInvocationTests
extends MockObjectTestCase {
    static /* synthetic */ Class class$org$acegisecurity$intercept$web$FilterInvocationTests;
    static /* synthetic */ Class class$org$acegisecurity$intercept$web$FilterInvocation;
    static /* synthetic */ Class class$javax$servlet$ServletRequest;
    static /* synthetic */ Class class$javax$servlet$ServletResponse;

    public FilterInvocationTests() {
    }

    public FilterInvocationTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$intercept$web$FilterInvocationTests == null ? (class$org$acegisecurity$intercept$web$FilterInvocationTests = FilterInvocationTests.class$("org.acegisecurity.intercept.web.FilterInvocationTests")) : class$org$acegisecurity$intercept$web$FilterInvocationTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testGettersAndStringMethods() {
        MockHttpServletRequest request = new MockHttpServletRequest(null, null);
        request.setServletPath("/HelloWorld");
        request.setPathInfo("/some/more/segments.html");
        request.setServerName("www.example.com");
        request.setScheme("http");
        request.setServerPort(80);
        request.setContextPath("/mycontext");
        request.setRequestURI("/mycontext/HelloWorld/some/more/segments.html");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        FilterInvocation fi = new FilterInvocation((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        FilterInvocationTests.assertEquals((Object)request, (Object)fi.getRequest());
        FilterInvocationTests.assertEquals((Object)request, (Object)fi.getHttpRequest());
        FilterInvocationTests.assertEquals((Object)response, (Object)fi.getResponse());
        FilterInvocationTests.assertEquals((Object)response, (Object)fi.getHttpResponse());
        FilterInvocationTests.assertEquals((Object)chain, (Object)fi.getChain());
        FilterInvocationTests.assertEquals((String)"/HelloWorld/some/more/segments.html", (String)fi.getRequestUrl());
        FilterInvocationTests.assertEquals((String)"FilterInvocation: URL: /HelloWorld/some/more/segments.html", (String)fi.toString());
        FilterInvocationTests.assertEquals((String)"http://www.example.com/mycontext/HelloWorld/some/more/segments.html", (String)fi.getFullRequestUrl());
    }

    public void testNoArgConstructorDoesntExist() {
        Class clazz = class$org$acegisecurity$intercept$web$FilterInvocation == null ? (class$org$acegisecurity$intercept$web$FilterInvocation = FilterInvocationTests.class$("org.acegisecurity.intercept.web.FilterInvocation")) : class$org$acegisecurity$intercept$web$FilterInvocation;
        try {
            clazz.getDeclaredConstructor(null);
            FilterInvocationTests.fail((String)"Should have thrown NoSuchMethodException");
        }
        catch (NoSuchMethodException expected) {
            FilterInvocationTests.assertTrue((boolean)true);
        }
    }

    public void testRejectsNullFilterChain() {
        MockHttpServletRequest request = new MockHttpServletRequest(null, null);
        MockHttpServletResponse response = new MockHttpServletResponse();
        try {
            new FilterInvocation((ServletRequest)request, (ServletResponse)response, null);
            FilterInvocationTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            FilterInvocationTests.assertTrue((boolean)true);
        }
    }

    public void testRejectsNullServletRequest() {
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        try {
            new FilterInvocation(null, (ServletResponse)response, (FilterChain)chain);
            FilterInvocationTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            FilterInvocationTests.assertTrue((boolean)true);
        }
    }

    public void testRejectsNullServletResponse() {
        MockHttpServletRequest request = new MockHttpServletRequest(null, null);
        MockFilterChain chain = new MockFilterChain();
        try {
            new FilterInvocation((ServletRequest)request, null, (FilterChain)chain);
            FilterInvocationTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            FilterInvocationTests.assertTrue((boolean)true);
        }
    }

    public void testRejectsServletRequestWhichIsNotHttpServletRequest() {
        ServletRequest request = (ServletRequest)this.newDummy(class$javax$servlet$ServletRequest == null ? (class$javax$servlet$ServletRequest = FilterInvocationTests.class$("javax.servlet.ServletRequest")) : class$javax$servlet$ServletRequest);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        try {
            new FilterInvocation(request, (ServletResponse)response, (FilterChain)chain);
            FilterInvocationTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            FilterInvocationTests.assertEquals((String)"Can only process HttpServletRequest", (String)expected.getMessage());
        }
    }

    public void testRejectsServletResponseWhichIsNotHttpServletResponse() {
        MockHttpServletRequest request = new MockHttpServletRequest(null, null);
        ServletResponse response = (ServletResponse)this.newDummy(class$javax$servlet$ServletResponse == null ? (class$javax$servlet$ServletResponse = FilterInvocationTests.class$("javax.servlet.ServletResponse")) : class$javax$servlet$ServletResponse);
        MockFilterChain chain = new MockFilterChain();
        try {
            new FilterInvocation((ServletRequest)request, response, (FilterChain)chain);
            FilterInvocationTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            FilterInvocationTests.assertEquals((String)"Can only process HttpServletResponse", (String)expected.getMessage());
        }
    }

    public void testStringMethodsWithAQueryString() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setQueryString("foo=bar");
        request.setServletPath("/HelloWorld");
        request.setServerName("www.example.com");
        request.setScheme("http");
        request.setServerPort(80);
        request.setContextPath("/mycontext");
        request.setRequestURI("/mycontext/HelloWorld");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        FilterInvocation fi = new FilterInvocation((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        FilterInvocationTests.assertEquals((String)"/HelloWorld?foo=bar", (String)fi.getRequestUrl());
        FilterInvocationTests.assertEquals((String)"FilterInvocation: URL: /HelloWorld?foo=bar", (String)fi.toString());
        FilterInvocationTests.assertEquals((String)"http://www.example.com/mycontext/HelloWorld?foo=bar", (String)fi.getFullRequestUrl());
    }

    public void testStringMethodsWithoutAnyQueryString() {
        MockHttpServletRequest request = new MockHttpServletRequest(null, null);
        request.setServletPath("/HelloWorld");
        request.setServerName("www.example.com");
        request.setScheme("http");
        request.setServerPort(80);
        request.setContextPath("/mycontext");
        request.setRequestURI("/mycontext/HelloWorld");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        FilterInvocation fi = new FilterInvocation((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        FilterInvocationTests.assertEquals((String)"/HelloWorld", (String)fi.getRequestUrl());
        FilterInvocationTests.assertEquals((String)"FilterInvocation: URL: /HelloWorld", (String)fi.toString());
        FilterInvocationTests.assertEquals((String)"http://www.example.com/mycontext/HelloWorld", (String)fi.getFullRequestUrl());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

