/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.intercept.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.AccessDecisionManager;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.MockAccessDecisionManager;
import org.acegisecurity.MockApplicationContext;
import org.acegisecurity.MockAuthenticationManager;
import org.acegisecurity.MockRunAsManager;
import org.acegisecurity.RunAsManager;
import org.acegisecurity.SecurityConfig;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.intercept.web.FilterInvocation;
import org.acegisecurity.intercept.web.FilterInvocationDefinition;
import org.acegisecurity.intercept.web.FilterInvocationDefinitionDecorator;
import org.acegisecurity.intercept.web.FilterInvocationDefinitionSource;
import org.acegisecurity.intercept.web.FilterInvocationDefinitionSourceMapping;
import org.acegisecurity.intercept.web.FilterSecurityInterceptor;
import org.acegisecurity.intercept.web.PathBasedFilterInvocationDefinitionMap;
import org.acegisecurity.intercept.web.RegExpBasedFilterInvocationDefinitionMap;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class FilterSecurityInterceptorTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$intercept$web$FilterSecurityInterceptorTests;

    public FilterSecurityInterceptorTests() {
    }

    public FilterSecurityInterceptorTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$intercept$web$FilterSecurityInterceptorTests == null ? (class$org$acegisecurity$intercept$web$FilterSecurityInterceptorTests = FilterSecurityInterceptorTests.class$("org.acegisecurity.intercept.web.FilterSecurityInterceptorTests")) : class$org$acegisecurity$intercept$web$FilterSecurityInterceptorTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testEnsuresAccessDecisionManagerSupportsFilterInvocationClass() throws Exception {
        FilterSecurityInterceptor interceptor = new FilterSecurityInterceptor();
        interceptor.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        interceptor.setObjectDefinitionSource((FilterInvocationDefinitionSource)new RegExpBasedFilterInvocationDefinitionMap());
        interceptor.setRunAsManager((RunAsManager)new MockRunAsManager());
        interceptor.setAccessDecisionManager(new AccessDecisionManager(){

            public boolean supports(Class clazz) {
                return false;
            }

            public boolean supports(ConfigAttribute attribute) {
                return true;
            }

            public void decide(Authentication authentication, Object object, ConfigAttributeDefinition config) throws AccessDeniedException {
                throw new UnsupportedOperationException("mock method not implemented");
            }
        });
        try {
            interceptor.afterPropertiesSet();
            FilterSecurityInterceptorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            FilterSecurityInterceptorTests.assertEquals((String)"AccessDecisionManager does not support secure object class: class org.acegisecurity.intercept.web.FilterInvocation", (String)expected.getMessage());
        }
    }

    public void testEnsuresRunAsManagerSupportsFilterInvocationClass() throws Exception {
        FilterSecurityInterceptor interceptor = new FilterSecurityInterceptor();
        interceptor.setAccessDecisionManager((AccessDecisionManager)new MockAccessDecisionManager());
        interceptor.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        interceptor.setObjectDefinitionSource((FilterInvocationDefinitionSource)new RegExpBasedFilterInvocationDefinitionMap());
        interceptor.setRunAsManager(new RunAsManager(){

            public boolean supports(Class clazz) {
                return false;
            }

            public boolean supports(ConfigAttribute attribute) {
                return true;
            }

            public Authentication buildRunAs(Authentication authentication, Object object, ConfigAttributeDefinition config) {
                throw new UnsupportedOperationException("mock method not implemented");
            }
        });
        try {
            interceptor.afterPropertiesSet();
            FilterSecurityInterceptorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            FilterSecurityInterceptorTests.assertEquals((String)"RunAsManager does not support secure object class: class org.acegisecurity.intercept.web.FilterInvocation", (String)expected.getMessage());
        }
    }

    public void testHttpsInvocationReflectsPortNumber() throws Throwable {
        FilterSecurityInterceptor interceptor = new FilterSecurityInterceptor();
        interceptor.setAccessDecisionManager((AccessDecisionManager)new MockAccessDecisionManager());
        interceptor.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        interceptor.setRunAsManager((RunAsManager)new MockRunAsManager());
        interceptor.setApplicationEventPublisher((ApplicationEventPublisher)MockApplicationContext.getContext());
        ConfigAttributeDefinition def = new ConfigAttributeDefinition();
        def.addConfigAttribute((ConfigAttribute)new SecurityConfig("MOCK_OK"));
        MockFilterInvocationDefinitionMap mockSource = new MockFilterInvocationDefinitionMap("/secure/page.html", def);
        interceptor.setObjectDefinitionSource((FilterInvocationDefinitionSource)mockSource);
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServletPath("/secure/page.html");
        request.setScheme("https");
        request.setServerPort(443);
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("MOCK_OK")});
        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        FilterInvocation fi = new FilterInvocation((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        interceptor.invoke(fi);
        SecurityContextHolder.clearContext();
    }

    public void testNormalStartupAndGetter() throws Exception {
        FilterSecurityInterceptor interceptor = new FilterSecurityInterceptor();
        interceptor.setAccessDecisionManager((AccessDecisionManager)new MockAccessDecisionManager());
        interceptor.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        RegExpBasedFilterInvocationDefinitionMap fidp = new RegExpBasedFilterInvocationDefinitionMap();
        interceptor.setObjectDefinitionSource((FilterInvocationDefinitionSource)fidp);
        interceptor.setRunAsManager((RunAsManager)new MockRunAsManager());
        interceptor.afterPropertiesSet();
        FilterSecurityInterceptorTests.assertTrue((boolean)true);
        FilterSecurityInterceptorTests.assertEquals((Object)fidp, (Object)interceptor.getObjectDefinitionSource());
    }

    public void testSuccessfulInvocation() throws Throwable {
        FilterSecurityInterceptor interceptor = new FilterSecurityInterceptor();
        interceptor.setAccessDecisionManager((AccessDecisionManager)new MockAccessDecisionManager());
        interceptor.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        interceptor.setRunAsManager((RunAsManager)new MockRunAsManager());
        interceptor.setApplicationEventPublisher((ApplicationEventPublisher)MockApplicationContext.getContext());
        ConfigAttributeDefinition def = new ConfigAttributeDefinition();
        def.addConfigAttribute((ConfigAttribute)new SecurityConfig("MOCK_OK"));
        MockFilterInvocationDefinitionMap mockSource = new MockFilterInvocationDefinitionMap("/secure/page.html", def);
        interceptor.setObjectDefinitionSource((FilterInvocationDefinitionSource)mockSource);
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServletPath("/secure/page.html");
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("MOCK_OK")});
        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        FilterInvocation fi = new FilterInvocation((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        interceptor.invoke(fi);
        SecurityContextHolder.clearContext();
    }

    public void testNotLoadedFromApplicationContext() throws Exception {
        FilterInvocationDefinitionSourceMapping mapping = new FilterInvocationDefinitionSourceMapping();
        mapping.setUrl("/secure/**");
        mapping.addConfigAttribute("ROLE_USER");
        ArrayList<FilterInvocationDefinitionSourceMapping> mappings = new ArrayList<FilterInvocationDefinitionSourceMapping>(1);
        mappings.add(mapping);
        PathBasedFilterInvocationDefinitionMap filterInvocationDefinitionSource = new PathBasedFilterInvocationDefinitionMap();
        filterInvocationDefinitionSource.setConvertUrlToLowercaseBeforeComparison(true);
        FilterInvocationDefinitionDecorator decorator = new FilterInvocationDefinitionDecorator((FilterInvocationDefinition)filterInvocationDefinitionSource);
        decorator.setMappings(mappings);
        FilterSecurityInterceptor filter = new FilterSecurityInterceptor();
        filter.setObjectDefinitionSource((FilterInvocationDefinitionSource)filterInvocationDefinitionSource);
        MockFilterChain filterChain = new MockFilterChain();
        filterChain.expectToProceed = true;
        FilterInvocation fi = new FilterInvocation((ServletRequest)new MockHttpServletRequest(), (ServletResponse)new MockHttpServletResponse(), (FilterChain)filterChain);
        filter.invoke(fi);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockFilterInvocationDefinitionMap
    implements FilterInvocationDefinitionSource {
        private ConfigAttributeDefinition toReturn;
        private String servletPath;

        public MockFilterInvocationDefinitionMap(String servletPath, ConfigAttributeDefinition toReturn) {
            this.servletPath = servletPath;
            this.toReturn = toReturn;
        }

        private MockFilterInvocationDefinitionMap() {
        }

        public ConfigAttributeDefinition getAttributes(Object object) throws IllegalArgumentException {
            FilterInvocation fi = (FilterInvocation)object;
            if (this.servletPath.equals(fi.getHttpRequest().getServletPath())) {
                return this.toReturn;
            }
            return null;
        }

        public Iterator getConfigAttributeDefinitions() {
            return null;
        }

        public boolean supports(Class clazz) {
            return true;
        }
    }

    private class MockFilterChain
    implements FilterChain {
        private boolean expectToProceed;

        public MockFilterChain(boolean expectToProceed) {
            this.expectToProceed = expectToProceed;
        }

        private MockFilterChain() {
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this.expectToProceed) {
                Assert.assertTrue((boolean)true);
            } else {
                Assert.fail((String)"Did not expect filter chain to proceed");
            }
        }
    }
}

