/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.intercept.web;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.TestCase;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.MockFilterChain;
import org.acegisecurity.SecurityConfig;
import org.acegisecurity.intercept.web.FilterInvocation;
import org.acegisecurity.intercept.web.PathBasedFilterInvocationDefinitionMap;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class PathBasedFilterDefinitionMapTests
extends TestCase {
    public PathBasedFilterDefinitionMapTests() {
    }

    public PathBasedFilterDefinitionMapTests(String arg0) {
        super(arg0);
    }

    public void testConvertUrlToLowercaseIsFalseByDefault() {
        PathBasedFilterInvocationDefinitionMap map = new PathBasedFilterInvocationDefinitionMap();
        PathBasedFilterDefinitionMapTests.assertFalse((boolean)map.isConvertUrlToLowercaseBeforeComparison());
    }

    public void testConvertUrlToLowercaseSetterRespected() {
        PathBasedFilterInvocationDefinitionMap map = new PathBasedFilterInvocationDefinitionMap();
        map.setConvertUrlToLowercaseBeforeComparison(true);
        PathBasedFilterDefinitionMapTests.assertTrue((boolean)map.isConvertUrlToLowercaseBeforeComparison());
    }

    public void testLookupNotRequiringExactMatchSuccessIfNotMatching() {
        PathBasedFilterInvocationDefinitionMap map = new PathBasedFilterInvocationDefinitionMap();
        map.setConvertUrlToLowercaseBeforeComparison(true);
        ConfigAttributeDefinition def = new ConfigAttributeDefinition();
        def.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_ONE"));
        map.addSecureUrl("/secure/super/**", def);
        FilterInvocation fi = this.createFilterinvocation("/SeCuRE/super/somefile.html");
        ConfigAttributeDefinition response = map.lookupAttributes(fi.getRequestUrl());
        PathBasedFilterDefinitionMapTests.assertEquals((Object)def, (Object)response);
    }

    public void testLookupNotRequiringExactMatchSucceedsIfSecureUrlPathContainsUpperCase() {
        PathBasedFilterInvocationDefinitionMap map = new PathBasedFilterInvocationDefinitionMap();
        map.setConvertUrlToLowercaseBeforeComparison(true);
        ConfigAttributeDefinition def = new ConfigAttributeDefinition();
        def.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_ONE"));
        map.addSecureUrl("/SeCuRE/super/**", def);
        FilterInvocation fi = this.createFilterinvocation("/secure/super/somefile.html");
        ConfigAttributeDefinition response = map.lookupAttributes(fi.getRequestUrl());
        PathBasedFilterDefinitionMapTests.assertEquals((Object)def, (Object)response);
    }

    public void testLookupRequiringExactMatchFailsIfNotMatching() {
        PathBasedFilterInvocationDefinitionMap map = new PathBasedFilterInvocationDefinitionMap();
        ConfigAttributeDefinition def = new ConfigAttributeDefinition();
        def.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_ONE"));
        map.addSecureUrl("/secure/super/**", def);
        FilterInvocation fi = this.createFilterinvocation("/SeCuRE/super/somefile.html");
        ConfigAttributeDefinition response = map.lookupAttributes(fi.getRequestUrl());
        PathBasedFilterDefinitionMapTests.assertEquals(null, (Object)response);
    }

    public void testLookupRequiringExactMatchIsSuccessful() {
        PathBasedFilterInvocationDefinitionMap map = new PathBasedFilterInvocationDefinitionMap();
        ConfigAttributeDefinition def = new ConfigAttributeDefinition();
        def.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_ONE"));
        map.addSecureUrl("/SeCurE/super/**", def);
        FilterInvocation fi = this.createFilterinvocation("/SeCurE/super/somefile.html");
        ConfigAttributeDefinition response = map.lookupAttributes(fi.getRequestUrl());
        PathBasedFilterDefinitionMapTests.assertEquals((Object)def, (Object)response);
    }

    public void testLookupRequiringExactMatchWithAdditionalSlashesIsSuccessful() {
        PathBasedFilterInvocationDefinitionMap map = new PathBasedFilterInvocationDefinitionMap();
        ConfigAttributeDefinition def = new ConfigAttributeDefinition();
        def.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_ONE"));
        map.addSecureUrl("/someAdminPage.html**", def);
        FilterInvocation fi = this.createFilterinvocation("/someAdminPage.html?a=/test");
        ConfigAttributeDefinition response = map.lookupAttributes(fi.getRequestUrl());
        PathBasedFilterDefinitionMapTests.assertEquals((Object)def, (Object)response);
    }

    public void testExtraQuestionMarkStillMatches() {
        PathBasedFilterInvocationDefinitionMap map = new PathBasedFilterInvocationDefinitionMap();
        ConfigAttributeDefinition def = new ConfigAttributeDefinition();
        def.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_ONE"));
        map.addSecureUrl("/someAdminPage.html*", def);
        FilterInvocation fi = this.createFilterinvocation("/someAdminPage.html?x=2/aa?y=3");
        ConfigAttributeDefinition response = map.lookupAttributes(fi.getRequestUrl());
        PathBasedFilterDefinitionMapTests.assertEquals((Object)def, (Object)response);
        fi = this.createFilterinvocation("/someAdminPage.html??");
        response = map.lookupAttributes(fi.getRequestUrl());
        PathBasedFilterDefinitionMapTests.assertEquals((Object)def, (Object)response);
    }

    private FilterInvocation createFilterinvocation(String path) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI(null);
        request.setServletPath(path);
        return new FilterInvocation((ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain());
    }
}

