/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ldap;

import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.acegisecurity.ldap.AbstractLdapServerTestCase;
import org.acegisecurity.ldap.InitialDirContextFactory;
import org.acegisecurity.ldap.LdapCallback;
import org.acegisecurity.ldap.LdapDataAccessException;
import org.acegisecurity.ldap.LdapTemplate;
import org.acegisecurity.ldap.LdapUtils;

public class LdapTemplateTests
extends AbstractLdapServerTestCase {
    private LdapTemplate template;

    protected void onSetUp() {
        this.getInitialCtxFactory().setManagerDn("cn=manager,dc=acegisecurity,dc=org");
        this.getInitialCtxFactory().setManagerPassword("acegisecurity");
        this.template = new LdapTemplate((InitialDirContextFactory)this.getInitialCtxFactory());
    }

    public void testCompareOfCorrectByteValueSucceeds() {
        LdapTemplateTests.assertTrue((boolean)this.template.compare("uid=bob,ou=people,dc=acegisecurity,dc=org", "userPassword", (Object)LdapUtils.getUtf8Bytes((String)"bobspassword")));
    }

    public void testCompareOfCorrectValueSucceeds() {
        LdapTemplateTests.assertTrue((boolean)this.template.compare("uid=bob,ou=people,dc=acegisecurity,dc=org", "uid", (Object)"bob"));
    }

    public void testCompareOfWrongByteValueFails() {
        LdapTemplateTests.assertFalse((boolean)this.template.compare("uid=bob,ou=people,dc=acegisecurity,dc=org", "userPassword", (Object)LdapUtils.getUtf8Bytes((String)"wrongvalue")));
    }

    public void testCompareOfWrongValueFails() {
        LdapTemplateTests.assertFalse((boolean)this.template.compare("uid=bob,ou=people,dc=acegisecurity,dc=org", "uid", (Object)"wrongvalue"));
    }

    public void testNameExistsForInValidNameFails() {
        LdapTemplateTests.assertFalse((boolean)this.template.nameExists("ou=doesntexist,dc=acegisecurity,dc=org"));
    }

    public void testNameExistsForValidNameSucceeds() {
        LdapTemplateTests.assertTrue((boolean)this.template.nameExists("ou=groups,dc=acegisecurity,dc=org"));
    }

    public void testNamingExceptionIsTranslatedCorrectly() {
        try {
            this.template.execute(new LdapCallback(){

                public Object doInDirContext(DirContext dirContext) throws NamingException {
                    throw new NamingException();
                }
            });
            LdapTemplateTests.fail((String)"Expected LdapDataAccessException on NamingException");
        }
        catch (LdapDataAccessException ldapDataAccessException) {
            // empty catch block
        }
    }

    public void testSearchForSingleAttributeValues() {
        String param = "uid=ben,ou=people,dc=acegisecurity,dc=org";
        Set values = this.template.searchForSingleAttributeValues("ou=groups", "(member={0})", (Object[])new String[]{param}, "ou");
        LdapTemplateTests.assertEquals((String)"Expected 3 results from search", (int)3, (int)values.size());
        LdapTemplateTests.assertTrue((boolean)values.contains("developer"));
        LdapTemplateTests.assertTrue((boolean)values.contains("manager"));
        LdapTemplateTests.assertTrue((boolean)values.contains("submanager"));
    }
}

