/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ldap;

import javax.naming.Context;
import javax.naming.NamingException;
import org.acegisecurity.ldap.LdapDataAccessException;
import org.acegisecurity.ldap.LdapUtils;
import org.jmock.Mock;
import org.jmock.MockObjectTestCase;

public class LdapUtilsTests
extends MockObjectTestCase {
    private final LdapDataAccessException tempCoverageBoost = new LdapDataAccessException("");
    static /* synthetic */ Class class$javax$naming$directory$DirContext;

    public void testCloseContextSwallowsNamingException() {
        Mock mockCtx = this.mock(class$javax$naming$directory$DirContext == null ? (class$javax$naming$directory$DirContext = LdapUtilsTests.class$("javax.naming.directory.DirContext")) : class$javax$naming$directory$DirContext);
        mockCtx.expects(this.once()).method("close").will(this.throwException(new NamingException()));
        LdapUtils.closeContext((Context)((Context)mockCtx.proxy()));
    }

    public void testGetRelativeNameReturnsEmptyStringForDnEqualToBaseName() throws Exception {
        Mock mockCtx = this.mock(class$javax$naming$directory$DirContext == null ? (class$javax$naming$directory$DirContext = LdapUtilsTests.class$("javax.naming.directory.DirContext")) : class$javax$naming$directory$DirContext);
        mockCtx.expects(this.atLeastOnce()).method("getNameInNamespace").will(this.returnValue("dc=acegisecurity,dc=org"));
        LdapUtilsTests.assertEquals((String)"", (String)LdapUtils.getRelativeName((String)"dc=acegisecurity,dc=org", (Context)((Context)mockCtx.proxy())));
    }

    public void testGetRelativeNameReturnsFullDnWithEmptyBaseName() throws Exception {
        Mock mockCtx = this.mock(class$javax$naming$directory$DirContext == null ? (class$javax$naming$directory$DirContext = LdapUtilsTests.class$("javax.naming.directory.DirContext")) : class$javax$naming$directory$DirContext);
        mockCtx.expects(this.atLeastOnce()).method("getNameInNamespace").will(this.returnValue(""));
        LdapUtilsTests.assertEquals((String)"cn=jane,dc=acegisecurity,dc=org", (String)LdapUtils.getRelativeName((String)"cn=jane,dc=acegisecurity,dc=org", (Context)((Context)mockCtx.proxy())));
    }

    public void testRootDnsAreParsedFromUrlsCorrectly() {
        LdapUtilsTests.assertEquals((String)"", (String)LdapUtils.parseRootDnFromUrl((String)"ldap://monkeymachine"));
        LdapUtilsTests.assertEquals((String)"", (String)LdapUtils.parseRootDnFromUrl((String)"ldap://monkeymachine/"));
        LdapUtilsTests.assertEquals((String)"", (String)LdapUtils.parseRootDnFromUrl((String)"ldap://monkeymachine.co.uk/"));
        LdapUtilsTests.assertEquals((String)"dc=acegisecurity,dc=org", (String)LdapUtils.parseRootDnFromUrl((String)"ldaps://monkeymachine.co.uk/dc=acegisecurity,dc=org"));
        LdapUtilsTests.assertEquals((String)"dc=acegisecurity,dc=org", (String)LdapUtils.parseRootDnFromUrl((String)"ldap:///dc=acegisecurity,dc=org"));
        LdapUtilsTests.assertEquals((String)"dc=acegisecurity,dc=org", (String)LdapUtils.parseRootDnFromUrl((String)"ldap://monkeymachine/dc=acegisecurity,dc=org"));
        LdapUtilsTests.assertEquals((String)"dc=acegisecurity,dc=org/ou=blah", (String)LdapUtils.parseRootDnFromUrl((String)"ldap://monkeymachine.co.uk/dc=acegisecurity,dc=org/ou=blah"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

