/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ldap.search;

import org.acegisecurity.ldap.AbstractLdapServerTestCase;
import org.acegisecurity.ldap.DefaultInitialDirContextFactory;
import org.acegisecurity.ldap.InitialDirContextFactory;
import org.acegisecurity.ldap.search.FilterBasedLdapUserSearch;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.acegisecurity.userdetails.ldap.LdapUserDetails;
import org.springframework.dao.IncorrectResultSizeDataAccessException;

public class FilterBasedLdapUserSearchTests
extends AbstractLdapServerTestCase {
    private DefaultInitialDirContextFactory dirCtxFactory;

    public FilterBasedLdapUserSearchTests(String string) {
        super(string);
    }

    public FilterBasedLdapUserSearchTests() {
    }

    public void onSetUp() {
        this.dirCtxFactory = this.getInitialCtxFactory();
        this.dirCtxFactory.setManagerDn("cn=manager,dc=acegisecurity,dc=org");
        this.dirCtxFactory.setManagerPassword("acegisecurity");
    }

    public void testBasicSearch() {
        FilterBasedLdapUserSearch locator = new FilterBasedLdapUserSearch("ou=people", "(uid={0})", (InitialDirContextFactory)this.dirCtxFactory);
        locator.setSearchSubtree(false);
        locator.setSearchTimeLimit(0);
        locator.setDerefLinkFlag(false);
        LdapUserDetails bob = locator.searchForUser("bob");
        FilterBasedLdapUserSearchTests.assertEquals((String)"bob", (String)bob.getUsername());
    }

    public void testExtraFilterPartToExcludeBob() throws Exception {
        FilterBasedLdapUserSearch locator = new FilterBasedLdapUserSearch("ou=people", "(&(cn=*)(!(|(uid={0})(uid=marissa))))", (InitialDirContextFactory)this.dirCtxFactory);
        LdapUserDetails ben = locator.searchForUser("bob");
        String cn = (String)ben.getAttributes().get("cn").get();
        FilterBasedLdapUserSearchTests.assertEquals((String)"Ben Alex", (String)cn);
    }

    public void testFailsOnMultipleMatches() {
        FilterBasedLdapUserSearch locator = new FilterBasedLdapUserSearch("ou=people", "(cn=*)", (InitialDirContextFactory)this.dirCtxFactory);
        try {
            locator.searchForUser("Ignored");
            FilterBasedLdapUserSearchTests.fail((String)"Expected exception for multiple search matches.");
        }
        catch (IncorrectResultSizeDataAccessException incorrectResultSizeDataAccessException) {
            // empty catch block
        }
    }

    public void testSearchForInvalidUserFails() {
        FilterBasedLdapUserSearch locator = new FilterBasedLdapUserSearch("ou=people", "(uid={0})", (InitialDirContextFactory)this.dirCtxFactory);
        try {
            locator.searchForUser("Joe");
            FilterBasedLdapUserSearchTests.fail((String)"Expected UsernameNotFoundException for non-existent user.");
        }
        catch (UsernameNotFoundException usernameNotFoundException) {
            // empty catch block
        }
    }

    public void testSubTreeSearchSucceeds() {
        FilterBasedLdapUserSearch locator = new FilterBasedLdapUserSearch("", "(cn={0})", (InitialDirContextFactory)this.dirCtxFactory);
        locator.setSearchSubtree(true);
        LdapUserDetails ben = locator.searchForUser("Ben Alex");
        FilterBasedLdapUserSearchTests.assertEquals((String)"Ben Alex", (String)ben.getUsername());
    }
}

