/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers;

import java.util.Vector;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationServiceException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.concurrent.ConcurrentSessionController;
import org.acegisecurity.concurrent.ConcurrentSessionControllerImpl;
import org.acegisecurity.concurrent.NullConcurrentSessionController;
import org.acegisecurity.providers.AuthenticationProvider;
import org.acegisecurity.providers.ProviderManager;
import org.acegisecurity.providers.ProviderNotFoundException;
import org.acegisecurity.providers.TestingAuthenticationToken;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class ProviderManagerTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$providers$ProviderManagerTests;
    static /* synthetic */ Class class$org$acegisecurity$providers$TestingAuthenticationToken;

    public ProviderManagerTests() {
    }

    public ProviderManagerTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$providers$ProviderManagerTests == null ? (class$org$acegisecurity$providers$ProviderManagerTests = ProviderManagerTests.class$("org.acegisecurity.providers.ProviderManagerTests")) : class$org$acegisecurity$providers$ProviderManagerTests));
    }

    private ProviderManager makeProviderManager() throws Exception {
        MockProvider provider1 = new MockProvider();
        Vector<MockProvider> providers = new Vector<MockProvider>();
        providers.add(provider1);
        ProviderManager mgr = new ProviderManager();
        mgr.setProviders(providers);
        mgr.afterPropertiesSet();
        return mgr;
    }

    private ProviderManager makeProviderManagerWithMockProviderWhichReturnsNullInList() {
        MockProviderWhichReturnsNull provider1 = new MockProviderWhichReturnsNull();
        MockProvider provider2 = new MockProvider();
        Vector<Object> providers = new Vector<Object>();
        providers.add(provider1);
        providers.add(provider2);
        ProviderManager mgr = new ProviderManager();
        mgr.setProviders(providers);
        return mgr;
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testAuthenticationFails() throws Exception {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        ProviderManager mgr = this.makeProviderManager();
        mgr.setApplicationEventPublisher((ApplicationEventPublisher)new MockApplicationEventPublisher(true));
        try {
            mgr.authenticate((Authentication)token);
            ProviderManagerTests.fail((String)"Should have thrown ProviderNotFoundException");
        }
        catch (ProviderNotFoundException expected) {
            ProviderManagerTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticationSuccess() throws Exception {
        TestingAuthenticationToken token = new TestingAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        ProviderManager mgr = this.makeProviderManager();
        mgr.setApplicationEventPublisher((ApplicationEventPublisher)new MockApplicationEventPublisher(true));
        Authentication result = mgr.authenticate((Authentication)token);
        if (!(result instanceof TestingAuthenticationToken)) {
            ProviderManagerTests.fail((String)"Should have returned instance of TestingAuthenticationToken");
        }
        TestingAuthenticationToken castResult = (TestingAuthenticationToken)result;
        ProviderManagerTests.assertEquals((Object)"Test", (Object)castResult.getPrincipal());
        ProviderManagerTests.assertEquals((Object)"Password", (Object)castResult.getCredentials());
        ProviderManagerTests.assertEquals((String)"ROLE_ONE", (String)castResult.getAuthorities()[0].getAuthority());
        ProviderManagerTests.assertEquals((String)"ROLE_TWO", (String)castResult.getAuthorities()[1].getAuthority());
    }

    public void testAuthenticationSuccessWhenFirstProviderReturnsNullButSecondAuthenticates() {
        TestingAuthenticationToken token = new TestingAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        ProviderManager mgr = this.makeProviderManagerWithMockProviderWhichReturnsNullInList();
        mgr.setApplicationEventPublisher((ApplicationEventPublisher)new MockApplicationEventPublisher(true));
        Authentication result = mgr.authenticate((Authentication)token);
        if (!(result instanceof TestingAuthenticationToken)) {
            ProviderManagerTests.fail((String)"Should have returned instance of TestingAuthenticationToken");
        }
        TestingAuthenticationToken castResult = (TestingAuthenticationToken)result;
        ProviderManagerTests.assertEquals((Object)"Test", (Object)castResult.getPrincipal());
        ProviderManagerTests.assertEquals((Object)"Password", (Object)castResult.getCredentials());
        ProviderManagerTests.assertEquals((String)"ROLE_ONE", (String)castResult.getAuthorities()[0].getAuthority());
        ProviderManagerTests.assertEquals((String)"ROLE_TWO", (String)castResult.getAuthorities()[1].getAuthority());
    }

    public void testConcurrentSessionControllerConfiguration() throws Exception {
        ProviderManager target = new ProviderManager();
        ProviderManagerTests.assertNotNull((Object)target.getSessionController());
        ProviderManagerTests.assertTrue((boolean)(target.getSessionController() instanceof NullConcurrentSessionController));
        ConcurrentSessionControllerImpl impl = new ConcurrentSessionControllerImpl();
        target.setSessionController((ConcurrentSessionController)impl);
        ProviderManagerTests.assertEquals((Object)impl, (Object)target.getSessionController());
    }

    public void testStartupFailsIfProviderListDoesNotContainingProviders() throws Exception {
        Vector<String> providers = new Vector<String>();
        providers.add("THIS_IS_NOT_A_PROVIDER");
        ProviderManager mgr = new ProviderManager();
        try {
            mgr.setProviders(providers);
            ProviderManagerTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            ProviderManagerTests.assertTrue((boolean)true);
        }
    }

    public void testStartupFailsIfProviderListNotSet() throws Exception {
        ProviderManager mgr = new ProviderManager();
        try {
            mgr.afterPropertiesSet();
            ProviderManagerTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            ProviderManagerTests.assertTrue((boolean)true);
        }
    }

    public void testStartupFailsIfProviderListNull() throws Exception {
        ProviderManager mgr = new ProviderManager();
        try {
            mgr.setProviders(null);
            ProviderManagerTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            ProviderManagerTests.assertTrue((boolean)true);
        }
    }

    public void testSuccessfulStartup() throws Exception {
        ProviderManager mgr = this.makeProviderManager();
        mgr.afterPropertiesSet();
        ProviderManagerTests.assertTrue((boolean)true);
        ProviderManagerTests.assertEquals((int)1, (int)mgr.getProviders().size());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockProviderWhichReturnsNull
    implements AuthenticationProvider {
        private MockProviderWhichReturnsNull() {
        }

        public Authentication authenticate(Authentication authentication) throws AuthenticationException {
            if (this.supports(authentication.getClass())) {
                return null;
            }
            throw new AuthenticationServiceException("Don't support this class");
        }

        public boolean supports(Class authentication) {
            return (class$org$acegisecurity$providers$TestingAuthenticationToken == null ? (class$org$acegisecurity$providers$TestingAuthenticationToken = ProviderManagerTests.class$("org.acegisecurity.providers.TestingAuthenticationToken")) : class$org$acegisecurity$providers$TestingAuthenticationToken).isAssignableFrom(authentication);
        }
    }

    private class MockProvider
    implements AuthenticationProvider {
        private MockProvider() {
        }

        public Authentication authenticate(Authentication authentication) throws AuthenticationException {
            if (this.supports(authentication.getClass())) {
                return authentication;
            }
            throw new AuthenticationServiceException("Don't support this class");
        }

        public boolean supports(Class authentication) {
            return (class$org$acegisecurity$providers$TestingAuthenticationToken == null ? (class$org$acegisecurity$providers$TestingAuthenticationToken = ProviderManagerTests.class$("org.acegisecurity.providers.TestingAuthenticationToken")) : class$org$acegisecurity$providers$TestingAuthenticationToken).isAssignableFrom(authentication);
        }
    }

    private class MockApplicationEventPublisher
    implements ApplicationEventPublisher {
        private boolean expectedEvent;

        public MockApplicationEventPublisher(boolean expectedEvent) {
            this.expectedEvent = expectedEvent;
        }

        public void publishEvent(ApplicationEvent event) {
            if (!this.expectedEvent) {
                throw new IllegalStateException("The ApplicationEventPublisher did not expect to receive this event");
            }
        }
    }
}

