/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.anonymous;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.Authentication;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.TestingAuthenticationToken;
import org.acegisecurity.providers.anonymous.AnonymousAuthenticationProvider;
import org.acegisecurity.providers.anonymous.AnonymousAuthenticationToken;

public class AnonymousAuthenticationProviderTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$providers$anonymous$AnonymousAuthenticationProviderTests;
    static /* synthetic */ Class class$org$acegisecurity$providers$TestingAuthenticationToken;
    static /* synthetic */ Class class$org$acegisecurity$providers$anonymous$AnonymousAuthenticationToken;

    public AnonymousAuthenticationProviderTests() {
    }

    public AnonymousAuthenticationProviderTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$providers$anonymous$AnonymousAuthenticationProviderTests == null ? (class$org$acegisecurity$providers$anonymous$AnonymousAuthenticationProviderTests = AnonymousAuthenticationProviderTests.class$("org.acegisecurity.providers.anonymous.AnonymousAuthenticationProviderTests")) : class$org$acegisecurity$providers$anonymous$AnonymousAuthenticationProviderTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testDetectsAnInvalidKey() throws Exception {
        AnonymousAuthenticationProvider aap = new AnonymousAuthenticationProvider();
        aap.setKey("qwerty");
        AnonymousAuthenticationToken token = new AnonymousAuthenticationToken("WRONG_KEY", (Object)"Test", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        try {
            Authentication result = aap.authenticate((Authentication)token);
            AnonymousAuthenticationProviderTests.fail((String)"Should have thrown BadCredentialsException");
        }
        catch (BadCredentialsException expected) {
            AnonymousAuthenticationProviderTests.assertEquals((String)"The presented AnonymousAuthenticationToken does not contain the expected key", (String)expected.getMessage());
        }
    }

    public void testDetectsMissingKey() throws Exception {
        AnonymousAuthenticationProvider aap = new AnonymousAuthenticationProvider();
        try {
            aap.afterPropertiesSet();
            AnonymousAuthenticationProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AnonymousAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testGettersSetters() throws Exception {
        AnonymousAuthenticationProvider aap = new AnonymousAuthenticationProvider();
        aap.setKey("qwerty");
        aap.afterPropertiesSet();
        AnonymousAuthenticationProviderTests.assertEquals((String)"qwerty", (String)aap.getKey());
    }

    public void testIgnoresClassesItDoesNotSupport() throws Exception {
        AnonymousAuthenticationProvider aap = new AnonymousAuthenticationProvider();
        aap.setKey("qwerty");
        TestingAuthenticationToken token = new TestingAuthenticationToken((Object)"user", (Object)"password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_A")});
        AnonymousAuthenticationProviderTests.assertFalse((boolean)aap.supports(class$org$acegisecurity$providers$TestingAuthenticationToken == null ? (class$org$acegisecurity$providers$TestingAuthenticationToken = AnonymousAuthenticationProviderTests.class$("org.acegisecurity.providers.TestingAuthenticationToken")) : class$org$acegisecurity$providers$TestingAuthenticationToken));
        AnonymousAuthenticationProviderTests.assertNull((Object)aap.authenticate((Authentication)token));
    }

    public void testNormalOperation() throws Exception {
        AnonymousAuthenticationProvider aap = new AnonymousAuthenticationProvider();
        aap.setKey("qwerty");
        AnonymousAuthenticationToken token = new AnonymousAuthenticationToken("qwerty", (Object)"Test", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        Authentication result = aap.authenticate((Authentication)token);
        AnonymousAuthenticationProviderTests.assertEquals((Object)result, (Object)token);
    }

    public void testSupports() {
        AnonymousAuthenticationProvider aap = new AnonymousAuthenticationProvider();
        AnonymousAuthenticationProviderTests.assertTrue((boolean)aap.supports(class$org$acegisecurity$providers$anonymous$AnonymousAuthenticationToken == null ? (class$org$acegisecurity$providers$anonymous$AnonymousAuthenticationToken = AnonymousAuthenticationProviderTests.class$("org.acegisecurity.providers.anonymous.AnonymousAuthenticationToken")) : class$org$acegisecurity$providers$anonymous$AnonymousAuthenticationToken));
        AnonymousAuthenticationProviderTests.assertFalse((boolean)aap.supports(class$org$acegisecurity$providers$TestingAuthenticationToken == null ? (class$org$acegisecurity$providers$TestingAuthenticationToken = AnonymousAuthenticationProviderTests.class$("org.acegisecurity.providers.TestingAuthenticationToken")) : class$org$acegisecurity$providers$TestingAuthenticationToken));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

