/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.cas.cache;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.cas.CasAuthenticationToken;
import org.acegisecurity.providers.cas.StatelessTicketCache;
import org.acegisecurity.providers.cas.cache.NullStatelessTicketCache;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;

public class NullStatelessTicketCacheTests
extends TestCase {
    private StatelessTicketCache cache = new NullStatelessTicketCache();

    public void testGetter() {
        NullStatelessTicketCacheTests.assertNull((Object)this.cache.getByTicketId(null));
        NullStatelessTicketCacheTests.assertNull((Object)this.cache.getByTicketId("test"));
    }

    public void testInsertAndGet() {
        CasAuthenticationToken token = this.getToken();
        this.cache.putTicketInCache(token);
        NullStatelessTicketCacheTests.assertNull((Object)this.cache.getByTicketId((String)token.getCredentials()));
    }

    private CasAuthenticationToken getToken() {
        ArrayList<String> proxyList = new ArrayList<String>();
        proxyList.add("https://localhost/newPortal/j_spring_cas_security_check");
        User user = new User("marissa", "password", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        return new CasAuthenticationToken("key", (Object)user, (Object)"ST-0-ER94xMJmn6pha35CQRoZ", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, (UserDetails)user, proxyList, "PGTIOU-0-R0zlgrl4pdAQwBvJWO3vnNpevwqStbSGcq3vKB2SqSFFRnjPHt");
    }
}

