/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.cas.populator;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.cas.populator.DaoCasAuthoritiesPopulator;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;

public class DaoCasAuthoritiesPopulatorTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$providers$cas$populator$DaoCasAuthoritiesPopulatorTests;

    public DaoCasAuthoritiesPopulatorTests() {
    }

    public DaoCasAuthoritiesPopulatorTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$providers$cas$populator$DaoCasAuthoritiesPopulatorTests == null ? (class$org$acegisecurity$providers$cas$populator$DaoCasAuthoritiesPopulatorTests = DaoCasAuthoritiesPopulatorTests.class$("org.acegisecurity.providers.cas.populator.DaoCasAuthoritiesPopulatorTests")) : class$org$acegisecurity$providers$cas$populator$DaoCasAuthoritiesPopulatorTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testDetectsMissingAuthenticationDao() throws Exception {
        DaoCasAuthoritiesPopulator populator = new DaoCasAuthoritiesPopulator();
        try {
            populator.afterPropertiesSet();
            DaoCasAuthoritiesPopulatorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            DaoCasAuthoritiesPopulatorTests.assertEquals((String)"A UserDetailsService must be set", (String)expected.getMessage());
        }
    }

    public void testGetGrantedAuthoritiesForInvalidUsername() throws Exception {
        DaoCasAuthoritiesPopulator populator = new DaoCasAuthoritiesPopulator();
        populator.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserMarissa());
        populator.afterPropertiesSet();
        try {
            populator.getUserDetails("scott");
            DaoCasAuthoritiesPopulatorTests.fail((String)"Should have thrown UsernameNotFoundException");
        }
        catch (UsernameNotFoundException expected) {
            DaoCasAuthoritiesPopulatorTests.assertTrue((boolean)true);
        }
    }

    public void testGetGrantedAuthoritiesForValidUsername() throws Exception {
        DaoCasAuthoritiesPopulator populator = new DaoCasAuthoritiesPopulator();
        populator.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserMarissa());
        populator.afterPropertiesSet();
        UserDetails results = populator.getUserDetails("marissa");
        DaoCasAuthoritiesPopulatorTests.assertEquals((int)2, (int)results.getAuthorities().length);
        DaoCasAuthoritiesPopulatorTests.assertEquals((Object)new GrantedAuthorityImpl("ROLE_ONE"), (Object)results.getAuthorities()[0]);
        DaoCasAuthoritiesPopulatorTests.assertEquals((Object)new GrantedAuthorityImpl("ROLE_TWO"), (Object)results.getAuthorities()[1]);
    }

    public void testGetGrantedAuthoritiesWhenDaoThrowsException() throws Exception {
        DaoCasAuthoritiesPopulator populator = new DaoCasAuthoritiesPopulator();
        populator.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoSimulateBackendError());
        populator.afterPropertiesSet();
        try {
            populator.getUserDetails("THE_DAO_WILL_FAIL");
            DaoCasAuthoritiesPopulatorTests.fail((String)"Should have thrown DataRetrievalFailureException");
        }
        catch (DataRetrievalFailureException expected) {
            DaoCasAuthoritiesPopulatorTests.assertTrue((boolean)true);
        }
    }

    public void testGettersSetters() {
        DaoCasAuthoritiesPopulator populator = new DaoCasAuthoritiesPopulator();
        MockAuthenticationDaoUserMarissa dao = new MockAuthenticationDaoUserMarissa();
        populator.setUserDetailsService((UserDetailsService)dao);
        DaoCasAuthoritiesPopulatorTests.assertEquals((Object)dao, (Object)populator.getUserDetailsService());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockAuthenticationDaoUserMarissa
    implements UserDetailsService {
        private MockAuthenticationDaoUserMarissa() {
        }

        public long getRefreshDuration() {
            return 0L;
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            if ("marissa".equals(username)) {
                return new User("marissa", "koala", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            }
            throw new UsernameNotFoundException("Could not find: " + username);
        }
    }

    private class MockAuthenticationDaoSimulateBackendError
    implements UserDetailsService {
        private MockAuthenticationDaoSimulateBackendError() {
        }

        public long getRefreshDuration() {
            return 0L;
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            throw new DataRetrievalFailureException("This mock simulator is designed to fail");
        }
    }
}

