/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.cas.ticketvalidator;

import java.util.Vector;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.providers.cas.TicketResponse;
import org.acegisecurity.providers.cas.ticketvalidator.AbstractTicketValidator;
import org.acegisecurity.ui.cas.ServiceProperties;

public class AbstractTicketValidatorTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$providers$cas$ticketvalidator$AbstractTicketValidatorTests;

    public AbstractTicketValidatorTests() {
    }

    public AbstractTicketValidatorTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$providers$cas$ticketvalidator$AbstractTicketValidatorTests == null ? (class$org$acegisecurity$providers$cas$ticketvalidator$AbstractTicketValidatorTests = AbstractTicketValidatorTests.class$("org.acegisecurity.providers.cas.ticketvalidator.AbstractTicketValidatorTests")) : class$org$acegisecurity$providers$cas$ticketvalidator$AbstractTicketValidatorTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testDetectsMissingCasValidate() throws Exception {
        MockAbstractTicketValidator tv = new MockAbstractTicketValidator();
        tv.setServiceProperties(new ServiceProperties());
        try {
            tv.afterPropertiesSet();
            AbstractTicketValidatorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AbstractTicketValidatorTests.assertEquals((String)"A casValidate URL must be set", (String)expected.getMessage());
        }
    }

    public void testDetectsMissingServiceProperties() throws Exception {
        MockAbstractTicketValidator tv = new MockAbstractTicketValidator();
        tv.setCasValidate("https://company.com/cas/proxyvalidate");
        try {
            tv.afterPropertiesSet();
            AbstractTicketValidatorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AbstractTicketValidatorTests.assertEquals((String)"serviceProperties must be specified", (String)expected.getMessage());
        }
    }

    public void testGetters() throws Exception {
        MockAbstractTicketValidator tv = new MockAbstractTicketValidator();
        tv.setCasValidate("https://company.com/cas/proxyvalidate");
        AbstractTicketValidatorTests.assertEquals((String)"https://company.com/cas/proxyvalidate", (String)tv.getCasValidate());
        tv.setServiceProperties(new ServiceProperties());
        AbstractTicketValidatorTests.assertTrue((tv.getServiceProperties() != null ? 1 : 0) != 0);
        tv.afterPropertiesSet();
        tv.setTrustStore("/some/file/cacerts");
        AbstractTicketValidatorTests.assertEquals((String)"/some/file/cacerts", (String)tv.getTrustStore());
    }

    public void testSystemPropertySetDuringAfterPropertiesSet() throws Exception {
        MockAbstractTicketValidator tv = new MockAbstractTicketValidator();
        tv.setCasValidate("https://company.com/cas/proxyvalidate");
        AbstractTicketValidatorTests.assertEquals((String)"https://company.com/cas/proxyvalidate", (String)tv.getCasValidate());
        tv.setServiceProperties(new ServiceProperties());
        AbstractTicketValidatorTests.assertTrue((tv.getServiceProperties() != null ? 1 : 0) != 0);
        tv.setTrustStore("/some/file/cacerts");
        AbstractTicketValidatorTests.assertEquals((String)"/some/file/cacerts", (String)tv.getTrustStore());
        String before = System.getProperty("javax.net.ssl.trustStore");
        tv.afterPropertiesSet();
        AbstractTicketValidatorTests.assertEquals((String)"/some/file/cacerts", (String)System.getProperty("javax.net.ssl.trustStore"));
        if (before == null) {
            System.setProperty("javax.net.ssl.trustStore", "");
        } else {
            System.setProperty("javax.net.ssl.trustStore", before);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockAbstractTicketValidator
    extends AbstractTicketValidator {
        private boolean returnTicket;

        public MockAbstractTicketValidator(boolean returnTicket) {
            this.returnTicket = returnTicket;
        }

        private MockAbstractTicketValidator() {
        }

        public TicketResponse confirmTicketValid(String serviceTicket) throws AuthenticationException {
            if (this.returnTicket) {
                return new TicketResponse("user", new Vector(), "PGTIOU-0-R0zlgrl4pdAQwBvJWO3vnNpevwqStbSGcq3vKB2SqSFFRnjPHt");
            }
            throw new BadCredentialsException("As requested by mock");
        }
    }
}

