/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.dao.cache;

import junit.framework.TestCase;
import net.sf.ehcache.Ehcache;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.MockApplicationContext;
import org.acegisecurity.providers.dao.cache.EhCacheBasedUserCache;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;
import org.springframework.context.ConfigurableApplicationContext;

public class EhCacheBasedUserCacheTests
extends TestCase {
    public EhCacheBasedUserCacheTests() {
    }

    public EhCacheBasedUserCacheTests(String arg0) {
        super(arg0);
    }

    private Ehcache getCache() {
        ConfigurableApplicationContext ctx = MockApplicationContext.getContext();
        return (Ehcache)ctx.getBean("eHCacheBackend");
    }

    private User getUser() {
        return new User("john", "password", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testCacheOperation() throws Exception {
        EhCacheBasedUserCache cache = new EhCacheBasedUserCache();
        cache.setCache(this.getCache());
        cache.afterPropertiesSet();
        cache.putUserInCache((UserDetails)this.getUser());
        EhCacheBasedUserCacheTests.assertEquals((String)this.getUser().getPassword(), (String)cache.getUserFromCache(this.getUser().getUsername()).getPassword());
        cache.removeUserFromCache((UserDetails)this.getUser());
        EhCacheBasedUserCacheTests.assertNull((Object)cache.getUserFromCache(this.getUser().getUsername()));
        EhCacheBasedUserCacheTests.assertNull((Object)cache.getUserFromCache(null));
        EhCacheBasedUserCacheTests.assertNull((Object)cache.getUserFromCache("UNKNOWN_USER"));
    }

    public void testStartupDetectsMissingCache() throws Exception {
        EhCacheBasedUserCache cache = new EhCacheBasedUserCache();
        try {
            cache.afterPropertiesSet();
            EhCacheBasedUserCacheTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            EhCacheBasedUserCacheTests.assertTrue((boolean)true);
        }
        Ehcache myCache = this.getCache();
        cache.setCache(myCache);
        EhCacheBasedUserCacheTests.assertEquals((Object)myCache, (Object)cache.getCache());
    }
}

