/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.dao.salt;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.AuthenticationServiceException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.dao.salt.ReflectionSaltSource;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;

public class ReflectionSaltSourceTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$providers$dao$salt$ReflectionSaltSourceTests;

    public ReflectionSaltSourceTests() {
    }

    public ReflectionSaltSourceTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$providers$dao$salt$ReflectionSaltSourceTests == null ? (class$org$acegisecurity$providers$dao$salt$ReflectionSaltSourceTests = ReflectionSaltSourceTests.class$("org.acegisecurity.providers.dao.salt.ReflectionSaltSourceTests")) : class$org$acegisecurity$providers$dao$salt$ReflectionSaltSourceTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testDetectsMissingUserPropertyToUse() throws Exception {
        ReflectionSaltSource saltSource = new ReflectionSaltSource();
        try {
            saltSource.afterPropertiesSet();
            ReflectionSaltSourceTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            ReflectionSaltSourceTests.assertEquals((String)"A userPropertyToUse must be set", (String)expected.getMessage());
        }
    }

    public void testExceptionWhenInvalidPropertyRequested() {
        ReflectionSaltSource saltSource = new ReflectionSaltSource();
        saltSource.setUserPropertyToUse("getDoesNotExist");
        User user = new User("scott", "wombat", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("HOLDER")});
        try {
            saltSource.getSalt((UserDetails)user);
            ReflectionSaltSourceTests.fail((String)"Should have thrown AuthenticationServiceException");
        }
        catch (AuthenticationServiceException expected) {
            ReflectionSaltSourceTests.assertTrue((boolean)true);
        }
    }

    public void testGettersSetters() {
        ReflectionSaltSource saltSource = new ReflectionSaltSource();
        saltSource.setUserPropertyToUse("getUsername");
        ReflectionSaltSourceTests.assertEquals((String)"getUsername", (String)saltSource.getUserPropertyToUse());
    }

    public void testNormalOperation() throws Exception {
        ReflectionSaltSource saltSource = new ReflectionSaltSource();
        saltSource.setUserPropertyToUse("getUsername");
        saltSource.afterPropertiesSet();
        User user = new User("scott", "wombat", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("HOLDER")});
        ReflectionSaltSourceTests.assertEquals((Object)"scott", (Object)saltSource.getSalt((UserDetails)user));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

