/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.encoding;

import junit.framework.TestCase;
import org.acegisecurity.providers.encoding.Md5PasswordEncoder;

public class Md5PasswordEncoderTests
extends TestCase {
    public void testBasicFunctionality() {
        Md5PasswordEncoder pe = new Md5PasswordEncoder();
        String raw = "abc123";
        String badRaw = "abc321";
        String salt = "THIS_IS_A_SALT";
        String encoded = pe.encodePassword(raw, (Object)salt);
        Md5PasswordEncoderTests.assertTrue((boolean)pe.isPasswordValid(encoded, raw, (Object)salt));
        Md5PasswordEncoderTests.assertFalse((boolean)pe.isPasswordValid(encoded, badRaw, (Object)salt));
        Md5PasswordEncoderTests.assertEquals((String)"a68aafd90299d0b137de28fb4bb68573", (String)encoded);
        Md5PasswordEncoderTests.assertEquals((String)"MD5", (String)pe.getAlgorithm());
    }

    public void testBase64() throws Exception {
        Md5PasswordEncoder pe = new Md5PasswordEncoder();
        pe.setEncodeHashAsBase64(true);
        String raw = "abc123";
        String badRaw = "abc321";
        String salt = "THIS_IS_A_SALT";
        String encoded = pe.encodePassword(raw, (Object)salt);
        Md5PasswordEncoderTests.assertTrue((boolean)pe.isPasswordValid(encoded, raw, (Object)salt));
        Md5PasswordEncoderTests.assertFalse((boolean)pe.isPasswordValid(encoded, badRaw, (Object)salt));
        Md5PasswordEncoderTests.assertTrue((encoded.length() != 32 ? 1 : 0) != 0);
    }
}

