/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.encoding;

import junit.framework.TestCase;
import org.acegisecurity.providers.encoding.ShaPasswordEncoder;

public class ShaPasswordEncoderTests
extends TestCase {
    public void testBasicFunctionality() {
        ShaPasswordEncoder pe = new ShaPasswordEncoder();
        String raw = "abc123";
        String badRaw = "abc321";
        String salt = "THIS_IS_A_SALT";
        String encoded = pe.encodePassword(raw, (Object)salt);
        ShaPasswordEncoderTests.assertTrue((boolean)pe.isPasswordValid(encoded, raw, (Object)salt));
        ShaPasswordEncoderTests.assertFalse((boolean)pe.isPasswordValid(encoded, badRaw, (Object)salt));
        ShaPasswordEncoderTests.assertEquals((String)"b2f50ffcbd3407fe9415c062d55f54731f340d32", (String)encoded);
    }

    public void testBase64() throws Exception {
        ShaPasswordEncoder pe = new ShaPasswordEncoder();
        pe.setEncodeHashAsBase64(true);
        String raw = "abc123";
        String badRaw = "abc321";
        String salt = "THIS_IS_A_SALT";
        String encoded = pe.encodePassword(raw, (Object)salt);
        ShaPasswordEncoderTests.assertTrue((boolean)pe.isPasswordValid(encoded, raw, (Object)salt));
        ShaPasswordEncoderTests.assertFalse((boolean)pe.isPasswordValid(encoded, badRaw, (Object)salt));
        ShaPasswordEncoderTests.assertTrue((encoded.length() != 40 ? 1 : 0) != 0);
    }

    public void test256() throws Exception {
        ShaPasswordEncoder pe = new ShaPasswordEncoder(256);
        String encoded = pe.encodePassword("abc123", null);
        ShaPasswordEncoderTests.assertEquals((String)"6ca13d52ca70c883e0f0bb101e425a89e8624de51db2d2392593af6a84118090", (String)encoded);
        String encodedWithSalt = pe.encodePassword("abc123", (Object)"THIS_IS_A_SALT");
        ShaPasswordEncoderTests.assertEquals((String)"4b79b7de23eb23b78cc5ede227d532b8a51f89b2ec166f808af76b0dbedc47d7", (String)encodedWithSalt);
    }

    public void testInvalidStrength() throws Exception {
        try {
            new ShaPasswordEncoder(666);
            ShaPasswordEncoderTests.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

