/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.ldap.authenticator;

import org.acegisecurity.AcegiMessageSource;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.ldap.AbstractLdapServerTestCase;
import org.acegisecurity.ldap.InitialDirContextFactory;
import org.acegisecurity.ldap.LdapUserSearch;
import org.acegisecurity.providers.ldap.authenticator.BindAuthenticator;
import org.acegisecurity.providers.ldap.authenticator.MockUserSearch;
import org.acegisecurity.userdetails.ldap.LdapUserDetails;
import org.acegisecurity.userdetails.ldap.LdapUserDetailsImpl;
import org.acegisecurity.userdetails.ldap.LdapUserDetailsMapper;
import org.springframework.context.MessageSource;

public class BindAuthenticatorTests
extends AbstractLdapServerTestCase {
    private BindAuthenticator authenticator;

    public void onSetUp() {
        this.authenticator = new BindAuthenticator((InitialDirContextFactory)this.getInitialCtxFactory());
        this.authenticator.setMessageSource((MessageSource)new AcegiMessageSource());
    }

    public void testAuthenticationWithCorrectPasswordSucceeds() {
        this.authenticator.setUserDnPatterns(new String[]{"uid={0},ou=people"});
        LdapUserDetails user = this.authenticator.authenticate("bob", "bobspassword");
        BindAuthenticatorTests.assertEquals((String)"bob", (String)user.getUsername());
    }

    public void testAuthenticationWithInvalidUserNameFails() {
        this.authenticator.setUserDnPatterns(new String[]{"uid={0},ou=people"});
        try {
            this.authenticator.authenticate("nonexistentsuser", "bobspassword");
            BindAuthenticatorTests.fail((String)"Shouldn't be able to bind with invalid username");
        }
        catch (BadCredentialsException badCredentialsException) {
            // empty catch block
        }
    }

    public void testAuthenticationWithUserSearch() throws Exception {
        LdapUserDetailsImpl.Essence userEssence = new LdapUserDetailsImpl.Essence();
        userEssence.setDn("uid=bob,ou=people,dc=acegisecurity,dc=org");
        this.authenticator.setUserSearch((LdapUserSearch)new MockUserSearch(userEssence.createUserDetails()));
        this.authenticator.afterPropertiesSet();
        this.authenticator.authenticate("bob", "bobspassword");
    }

    public void testAuthenticationWithWrongPasswordFails() {
        this.authenticator.setUserDnPatterns(new String[]{"uid={0},ou=people"});
        try {
            this.authenticator.authenticate("bob", "wrongpassword");
            BindAuthenticatorTests.fail((String)"Shouldn't be able to bind with wrong password");
        }
        catch (BadCredentialsException badCredentialsException) {
            // empty catch block
        }
    }

    public void testRoleRetrieval() {
        this.authenticator.setUserDnPatterns(new String[]{"uid={0},ou=people"});
        LdapUserDetailsMapper userMapper = new LdapUserDetailsMapper();
        userMapper.setRoleAttributes(new String[]{"uid"});
        this.authenticator.setUserDetailsMapper(userMapper);
        LdapUserDetails user = this.authenticator.authenticate("bob", "bobspassword");
        BindAuthenticatorTests.assertEquals((int)1, (int)user.getAuthorities().length);
        BindAuthenticatorTests.assertEquals((Object)new GrantedAuthorityImpl("ROLE_BOB"), (Object)user.getAuthorities()[0]);
    }

    public void testUserDnPatternReturnsCorrectDn() {
        this.authenticator.setUserDnPatterns(new String[]{"cn={0},ou=people"});
        BindAuthenticatorTests.assertEquals((Object)("cn=Joe,ou=people," + this.getInitialCtxFactory().getRootDn()), this.authenticator.getUserDns("Joe").get(0));
    }
}

