/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.ldap.authenticator;

import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.ldap.AbstractLdapServerTestCase;
import org.acegisecurity.ldap.InitialDirContextFactory;
import org.acegisecurity.ldap.LdapUserSearch;
import org.acegisecurity.providers.encoding.PasswordEncoder;
import org.acegisecurity.providers.encoding.PlaintextPasswordEncoder;
import org.acegisecurity.providers.ldap.authenticator.MockUserSearch;
import org.acegisecurity.providers.ldap.authenticator.PasswordComparisonAuthenticator;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.acegisecurity.userdetails.ldap.LdapUserDetails;
import org.acegisecurity.userdetails.ldap.LdapUserDetailsImpl;
import org.acegisecurity.userdetails.ldap.LdapUserDetailsMapper;

public class PasswordComparisonAuthenticatorTests
extends AbstractLdapServerTestCase {
    private PasswordComparisonAuthenticator authenticator;

    public void onSetUp() {
        this.getInitialCtxFactory().setManagerDn("cn=manager,dc=acegisecurity,dc=org");
        this.getInitialCtxFactory().setManagerPassword("acegisecurity");
        this.authenticator = new PasswordComparisonAuthenticator((InitialDirContextFactory)this.getInitialCtxFactory());
        this.authenticator.setUserDnPatterns(new String[]{"uid={0},ou=people"});
    }

    public void tearDown() {
    }

    public void testAllAttributesAreRetrivedByDefault() {
        LdapUserDetails user = this.authenticator.authenticate("Bob", "bobspassword");
        PasswordComparisonAuthenticatorTests.assertEquals((String)"User should have 5 attributes", (int)5, (int)user.getAttributes().size());
    }

    public void testFailedSearchGivesUserNotFoundException() throws Exception {
        this.authenticator = new PasswordComparisonAuthenticator((InitialDirContextFactory)this.getInitialCtxFactory());
        PasswordComparisonAuthenticatorTests.assertTrue((String)"User DN matches shouldn't be available", (boolean)this.authenticator.getUserDns("Bob").isEmpty());
        this.authenticator.setUserSearch((LdapUserSearch)new MockUserSearch(null));
        this.authenticator.afterPropertiesSet();
        try {
            this.authenticator.authenticate("Joe", "password");
            PasswordComparisonAuthenticatorTests.fail((String)"Expected exception on failed user search");
        }
        catch (UsernameNotFoundException usernameNotFoundException) {
            // empty catch block
        }
    }

    public void testLocalComparisonSucceedsWithShaEncodedPassword() {
        this.authenticator.authenticate("ben", "benspassword");
    }

    public void testLocalPasswordComparisonFailsWithWrongPassword() {
        try {
            this.authenticator.authenticate("Bob", "wrongpassword");
            PasswordComparisonAuthenticatorTests.fail((String)"Authentication should fail with wrong password.");
        }
        catch (BadCredentialsException badCredentialsException) {
            // empty catch block
        }
    }

    public void testLocalPasswordComparisonSucceedsWithCorrectPassword() {
        LdapUserDetails user = this.authenticator.authenticate("Bob", "bobspassword");
        PasswordComparisonAuthenticatorTests.assertEquals((String)"Bob", (String)user.getUsername());
        PasswordComparisonAuthenticatorTests.assertEquals((String)"bobspassword", (String)user.getPassword());
    }

    public void testMultipleDnPatternsWorkOk() {
        this.authenticator.setUserDnPatterns(new String[]{"uid={0},ou=nonexistent", "uid={0},ou=people"});
        this.authenticator.authenticate("Bob", "bobspassword");
    }

    public void testOnlySpecifiedAttributesAreRetrieved() throws Exception {
        this.authenticator.setUserAttributes(new String[]{"userPassword"});
        this.authenticator.setPasswordEncoder((PasswordEncoder)new PlaintextPasswordEncoder());
        LdapUserDetails user = this.authenticator.authenticate("Bob", "bobspassword");
        PasswordComparisonAuthenticatorTests.assertEquals((String)"Should have retrieved 1 attribute (userPassword)", (int)1, (int)user.getAttributes().size());
    }

    public void testPasswordEncoderCantBeNull() {
        try {
            this.authenticator.setPasswordEncoder(null);
            PasswordComparisonAuthenticatorTests.fail((String)"Password encoder can't be null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testUseOfDifferentPasswordAttribute() {
        LdapUserDetailsMapper mapper = new LdapUserDetailsMapper();
        mapper.setPasswordAttributeName("uid");
        this.authenticator.setPasswordAttributeName("uid");
        this.authenticator.setUserDetailsMapper(mapper);
        LdapUserDetails bob = this.authenticator.authenticate("bob", "bob");
    }

    public void testWithUserSearch() {
        this.authenticator = new PasswordComparisonAuthenticator((InitialDirContextFactory)this.getInitialCtxFactory());
        PasswordComparisonAuthenticatorTests.assertTrue((String)"User DN matches shouldn't be available", (boolean)this.authenticator.getUserDns("Bob").isEmpty());
        LdapUserDetailsImpl.Essence userEssence = new LdapUserDetailsImpl.Essence();
        userEssence.setDn("uid=Bob,ou=people,dc=acegisecurity,dc=org");
        userEssence.setPassword("bobspassword");
        this.authenticator.setUserSearch((LdapUserSearch)new MockUserSearch(userEssence.createUserDetails()));
        this.authenticator.authenticate("ShouldntBeUsed", "bobspassword");
    }
}

