/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.x509.cache;

import junit.framework.TestCase;
import net.sf.ehcache.Ehcache;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.MockApplicationContext;
import org.acegisecurity.providers.x509.X509TestUtils;
import org.acegisecurity.providers.x509.cache.EhCacheBasedX509UserCache;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;
import org.springframework.context.ConfigurableApplicationContext;

public class EhCacheBasedX509UserCacheTests
extends TestCase {
    public EhCacheBasedX509UserCacheTests() {
    }

    public EhCacheBasedX509UserCacheTests(String arg0) {
        super(arg0);
    }

    private Ehcache getCache() {
        ConfigurableApplicationContext ctx = MockApplicationContext.getContext();
        return (Ehcache)ctx.getBean("eHCacheBackend");
    }

    private UserDetails getUser() {
        return new User("marissa", "password", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testCacheOperation() throws Exception {
        EhCacheBasedX509UserCache cache = new EhCacheBasedX509UserCache();
        cache.setCache(this.getCache());
        cache.afterPropertiesSet();
        cache.putUserInCache(X509TestUtils.buildTestCertificate(), this.getUser());
        EhCacheBasedX509UserCacheTests.assertEquals((String)this.getUser().getPassword(), (String)cache.getUserFromCache(X509TestUtils.buildTestCertificate()).getPassword());
        cache.removeUserFromCache(X509TestUtils.buildTestCertificate());
        EhCacheBasedX509UserCacheTests.assertNull((Object)cache.getUserFromCache(X509TestUtils.buildTestCertificate()));
        EhCacheBasedX509UserCacheTests.assertNull((Object)cache.getUserFromCache(null));
    }
}

