/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.runas;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.Authentication;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.runas.RunAsImplAuthenticationProvider;
import org.acegisecurity.runas.RunAsUserToken;

public class RunAsImplAuthenticationProviderTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$runas$RunAsImplAuthenticationProviderTests;
    static /* synthetic */ Class class$org$acegisecurity$providers$UsernamePasswordAuthenticationToken;
    static /* synthetic */ Class class$org$acegisecurity$runas$RunAsUserToken;
    static /* synthetic */ Class class$org$acegisecurity$providers$TestingAuthenticationToken;

    public RunAsImplAuthenticationProviderTests() {
    }

    public RunAsImplAuthenticationProviderTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$runas$RunAsImplAuthenticationProviderTests == null ? (class$org$acegisecurity$runas$RunAsImplAuthenticationProviderTests = RunAsImplAuthenticationProviderTests.class$("org.acegisecurity.runas.RunAsImplAuthenticationProviderTests")) : class$org$acegisecurity$runas$RunAsImplAuthenticationProviderTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testAuthenticationFailDueToWrongKey() {
        RunAsUserToken token = new RunAsUserToken("WRONG_PASSWORD", (Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, class$org$acegisecurity$providers$UsernamePasswordAuthenticationToken == null ? (class$org$acegisecurity$providers$UsernamePasswordAuthenticationToken = RunAsImplAuthenticationProviderTests.class$("org.acegisecurity.providers.UsernamePasswordAuthenticationToken")) : class$org$acegisecurity$providers$UsernamePasswordAuthenticationToken);
        RunAsImplAuthenticationProvider provider = new RunAsImplAuthenticationProvider();
        provider.setKey("hello_world");
        try {
            provider.authenticate((Authentication)token);
            RunAsImplAuthenticationProviderTests.fail((String)"Should have thrown BadCredentialsException");
        }
        catch (BadCredentialsException expected) {
            RunAsImplAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticationSuccess() {
        RunAsUserToken token = new RunAsUserToken("my_password", (Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, class$org$acegisecurity$providers$UsernamePasswordAuthenticationToken == null ? (class$org$acegisecurity$providers$UsernamePasswordAuthenticationToken = RunAsImplAuthenticationProviderTests.class$("org.acegisecurity.providers.UsernamePasswordAuthenticationToken")) : class$org$acegisecurity$providers$UsernamePasswordAuthenticationToken);
        RunAsImplAuthenticationProvider provider = new RunAsImplAuthenticationProvider();
        provider.setKey("my_password");
        Authentication result = provider.authenticate((Authentication)token);
        if (!(result instanceof RunAsUserToken)) {
            RunAsImplAuthenticationProviderTests.fail((String)"Should have returned RunAsUserToken");
        }
        RunAsUserToken resultCast = (RunAsUserToken)result;
        RunAsImplAuthenticationProviderTests.assertEquals((int)"my_password".hashCode(), (int)resultCast.getKeyHash());
    }

    public void testStartupFailsIfNoKey() throws Exception {
        RunAsImplAuthenticationProvider provider = new RunAsImplAuthenticationProvider();
        try {
            provider.afterPropertiesSet();
            RunAsImplAuthenticationProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            RunAsImplAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testStartupSuccess() throws Exception {
        RunAsImplAuthenticationProvider provider = new RunAsImplAuthenticationProvider();
        provider.setKey("hello_world");
        RunAsImplAuthenticationProviderTests.assertEquals((String)"hello_world", (String)provider.getKey());
        provider.afterPropertiesSet();
        RunAsImplAuthenticationProviderTests.assertTrue((boolean)true);
    }

    public void testSupports() {
        RunAsImplAuthenticationProvider provider = new RunAsImplAuthenticationProvider();
        RunAsImplAuthenticationProviderTests.assertTrue((boolean)provider.supports(class$org$acegisecurity$runas$RunAsUserToken == null ? (class$org$acegisecurity$runas$RunAsUserToken = RunAsImplAuthenticationProviderTests.class$("org.acegisecurity.runas.RunAsUserToken")) : class$org$acegisecurity$runas$RunAsUserToken));
        RunAsImplAuthenticationProviderTests.assertTrue((!provider.supports(class$org$acegisecurity$providers$TestingAuthenticationToken == null ? (class$org$acegisecurity$providers$TestingAuthenticationToken = RunAsImplAuthenticationProviderTests.class$("org.acegisecurity.providers.TestingAuthenticationToken")) : class$org$acegisecurity$providers$TestingAuthenticationToken) ? 1 : 0) != 0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

