/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.runas;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.Authentication;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.SecurityConfig;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.runas.RunAsManagerImpl;
import org.acegisecurity.runas.RunAsUserToken;

public class RunAsManagerImplTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$runas$RunAsManagerImplTests;
    static /* synthetic */ Class class$java$lang$String;

    public RunAsManagerImplTests() {
    }

    public RunAsManagerImplTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$runas$RunAsManagerImplTests == null ? (class$org$acegisecurity$runas$RunAsManagerImplTests = RunAsManagerImplTests.class$("org.acegisecurity.runas.RunAsManagerImplTests")) : class$org$acegisecurity$runas$RunAsManagerImplTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testAlwaysSupportsClass() {
        RunAsManagerImpl runAs = new RunAsManagerImpl();
        RunAsManagerImplTests.assertTrue((boolean)runAs.supports(class$java$lang$String == null ? (class$java$lang$String = RunAsManagerImplTests.class$("java.lang.String")) : class$java$lang$String));
    }

    public void testDoesNotReturnAdditionalAuthoritiesIfCalledWithoutARunAsSetting() throws Exception {
        ConfigAttributeDefinition def = new ConfigAttributeDefinition();
        def.addConfigAttribute((ConfigAttribute)new SecurityConfig("SOMETHING_WE_IGNORE"));
        UsernamePasswordAuthenticationToken inputToken = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        RunAsManagerImpl runAs = new RunAsManagerImpl();
        runAs.setKey("my_password");
        Authentication resultingToken = runAs.buildRunAs((Authentication)inputToken, new Object(), def);
        RunAsManagerImplTests.assertEquals(null, (Object)resultingToken);
    }

    public void testRespectsRolePrefix() throws Exception {
        ConfigAttributeDefinition def = new ConfigAttributeDefinition();
        def.addConfigAttribute((ConfigAttribute)new SecurityConfig("RUN_AS_SOMETHING"));
        UsernamePasswordAuthenticationToken inputToken = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ONE"), new GrantedAuthorityImpl("TWO")});
        RunAsManagerImpl runAs = new RunAsManagerImpl();
        runAs.setKey("my_password");
        runAs.setRolePrefix("FOOBAR_");
        Authentication resultingToken = runAs.buildRunAs((Authentication)inputToken, new Object(), def);
        if (!(resultingToken instanceof RunAsUserToken)) {
            RunAsManagerImplTests.fail((String)"Should have returned a RunAsUserToken");
        }
        RunAsManagerImplTests.assertEquals((Object)inputToken.getPrincipal(), (Object)resultingToken.getPrincipal());
        RunAsManagerImplTests.assertEquals((Object)inputToken.getCredentials(), (Object)resultingToken.getCredentials());
        RunAsManagerImplTests.assertEquals((String)"FOOBAR_RUN_AS_SOMETHING", (String)resultingToken.getAuthorities()[0].getAuthority());
        RunAsManagerImplTests.assertEquals((String)"ONE", (String)resultingToken.getAuthorities()[1].getAuthority());
        RunAsManagerImplTests.assertEquals((String)"TWO", (String)resultingToken.getAuthorities()[2].getAuthority());
        RunAsUserToken resultCast = (RunAsUserToken)resultingToken;
        RunAsManagerImplTests.assertEquals((int)"my_password".hashCode(), (int)resultCast.getKeyHash());
    }

    public void testReturnsAdditionalGrantedAuthorities() throws Exception {
        ConfigAttributeDefinition def = new ConfigAttributeDefinition();
        def.addConfigAttribute((ConfigAttribute)new SecurityConfig("RUN_AS_SOMETHING"));
        UsernamePasswordAuthenticationToken inputToken = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        RunAsManagerImpl runAs = new RunAsManagerImpl();
        runAs.setKey("my_password");
        Authentication resultingToken = runAs.buildRunAs((Authentication)inputToken, new Object(), def);
        if (!(resultingToken instanceof RunAsUserToken)) {
            RunAsManagerImplTests.fail((String)"Should have returned a RunAsUserToken");
        }
        RunAsManagerImplTests.assertEquals((Object)inputToken.getPrincipal(), (Object)resultingToken.getPrincipal());
        RunAsManagerImplTests.assertEquals((Object)inputToken.getCredentials(), (Object)resultingToken.getCredentials());
        RunAsManagerImplTests.assertEquals((String)"ROLE_RUN_AS_SOMETHING", (String)resultingToken.getAuthorities()[0].getAuthority());
        RunAsManagerImplTests.assertEquals((String)"ROLE_ONE", (String)resultingToken.getAuthorities()[1].getAuthority());
        RunAsManagerImplTests.assertEquals((String)"ROLE_TWO", (String)resultingToken.getAuthorities()[2].getAuthority());
        RunAsUserToken resultCast = (RunAsUserToken)resultingToken;
        RunAsManagerImplTests.assertEquals((int)"my_password".hashCode(), (int)resultCast.getKeyHash());
    }

    public void testStartupDetectsMissingKey() throws Exception {
        RunAsManagerImpl runAs = new RunAsManagerImpl();
        try {
            runAs.afterPropertiesSet();
            RunAsManagerImplTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            RunAsManagerImplTests.assertTrue((boolean)true);
        }
    }

    public void testStartupSuccessfulWithKey() throws Exception {
        RunAsManagerImpl runAs = new RunAsManagerImpl();
        runAs.setKey("hello_world");
        runAs.afterPropertiesSet();
        RunAsManagerImplTests.assertEquals((String)"hello_world", (String)runAs.getKey());
    }

    public void testSupports() throws Exception {
        RunAsManagerImpl runAs = new RunAsManagerImpl();
        RunAsManagerImplTests.assertTrue((boolean)runAs.supports((ConfigAttribute)new SecurityConfig("RUN_AS_SOMETHING")));
        RunAsManagerImplTests.assertTrue((!runAs.supports((ConfigAttribute)new SecurityConfig("ROLE_WHICH_IS_IGNORED")) ? 1 : 0) != 0);
        RunAsManagerImplTests.assertTrue((!runAs.supports((ConfigAttribute)new SecurityConfig("role_LOWER_CASE_FAILS")) ? 1 : 0) != 0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

