/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.securechannel;

import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.MockFilterChain;
import org.acegisecurity.SecurityConfig;
import org.acegisecurity.intercept.web.FilterInvocation;
import org.acegisecurity.securechannel.ChannelDecisionManagerImpl;
import org.acegisecurity.securechannel.ChannelProcessor;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class ChannelDecisionManagerImplTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$securechannel$ChannelDecisionManagerImplTests;

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$securechannel$ChannelDecisionManagerImplTests == null ? (class$org$acegisecurity$securechannel$ChannelDecisionManagerImplTests = ChannelDecisionManagerImplTests.class$("org.acegisecurity.securechannel.ChannelDecisionManagerImplTests")) : class$org$acegisecurity$securechannel$ChannelDecisionManagerImplTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testCannotSetEmptyChannelProcessorsList() throws Exception {
        ChannelDecisionManagerImpl cdm = new ChannelDecisionManagerImpl();
        try {
            cdm.setChannelProcessors(new Vector());
            ChannelDecisionManagerImplTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            ChannelDecisionManagerImplTests.assertEquals((String)"A list of ChannelProcessors is required", (String)expected.getMessage());
        }
    }

    public void testCannotSetIncorrectObjectTypesIntoChannelProcessorsList() throws Exception {
        ChannelDecisionManagerImpl cdm = new ChannelDecisionManagerImpl();
        Vector<String> list = new Vector<String>();
        list.add("THIS IS NOT A CHANNELPROCESSOR");
        try {
            cdm.setChannelProcessors(list);
            ChannelDecisionManagerImplTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            ChannelDecisionManagerImplTests.assertTrue((boolean)true);
        }
    }

    public void testCannotSetNullChannelProcessorsList() throws Exception {
        ChannelDecisionManagerImpl cdm = new ChannelDecisionManagerImpl();
        try {
            cdm.setChannelProcessors(null);
            ChannelDecisionManagerImplTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            ChannelDecisionManagerImplTests.assertEquals((String)"A list of ChannelProcessors is required", (String)expected.getMessage());
        }
    }

    public void testDecideIsOperational() throws Exception {
        ChannelDecisionManagerImpl cdm = new ChannelDecisionManagerImpl();
        MockChannelProcessor cpXyz = new MockChannelProcessor("xyz", false);
        MockChannelProcessor cpAbc = new MockChannelProcessor("abc", true);
        Vector<MockChannelProcessor> list = new Vector<MockChannelProcessor>();
        list.add(cpXyz);
        list.add(cpAbc);
        cdm.setChannelProcessors(list);
        cdm.afterPropertiesSet();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        FilterInvocation fi = new FilterInvocation((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        ConfigAttributeDefinition cad = new ConfigAttributeDefinition();
        cad.addConfigAttribute((ConfigAttribute)new SecurityConfig("xyz"));
        cdm.decide(fi, cad);
        ChannelDecisionManagerImplTests.assertTrue((boolean)fi.getResponse().isCommitted());
    }

    public void testDecideIteratesAllProcessorsIfNoneCommitAResponse() throws Exception {
        ChannelDecisionManagerImpl cdm = new ChannelDecisionManagerImpl();
        MockChannelProcessor cpXyz = new MockChannelProcessor("xyz", false);
        MockChannelProcessor cpAbc = new MockChannelProcessor("abc", false);
        Vector<MockChannelProcessor> list = new Vector<MockChannelProcessor>();
        list.add(cpXyz);
        list.add(cpAbc);
        cdm.setChannelProcessors(list);
        cdm.afterPropertiesSet();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        FilterInvocation fi = new FilterInvocation((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        ConfigAttributeDefinition cad = new ConfigAttributeDefinition();
        cad.addConfigAttribute((ConfigAttribute)new SecurityConfig("SOME_ATTRIBUTE_NO_PROCESSORS_SUPPORT"));
        cdm.decide(fi, cad);
        ChannelDecisionManagerImplTests.assertFalse((boolean)fi.getResponse().isCommitted());
    }

    public void testDelegatesSupports() throws Exception {
        ChannelDecisionManagerImpl cdm = new ChannelDecisionManagerImpl();
        MockChannelProcessor cpXyz = new MockChannelProcessor("xyz", false);
        MockChannelProcessor cpAbc = new MockChannelProcessor("abc", false);
        Vector<MockChannelProcessor> list = new Vector<MockChannelProcessor>();
        list.add(cpXyz);
        list.add(cpAbc);
        cdm.setChannelProcessors(list);
        cdm.afterPropertiesSet();
        ChannelDecisionManagerImplTests.assertTrue((boolean)cdm.supports((ConfigAttribute)new SecurityConfig("xyz")));
        ChannelDecisionManagerImplTests.assertTrue((boolean)cdm.supports((ConfigAttribute)new SecurityConfig("abc")));
        ChannelDecisionManagerImplTests.assertFalse((boolean)cdm.supports((ConfigAttribute)new SecurityConfig("UNSUPPORTED")));
    }

    public void testGettersSetters() {
        ChannelDecisionManagerImpl cdm = new ChannelDecisionManagerImpl();
        ChannelDecisionManagerImplTests.assertNull((Object)cdm.getChannelProcessors());
        MockChannelProcessor cpXyz = new MockChannelProcessor("xyz", false);
        MockChannelProcessor cpAbc = new MockChannelProcessor("abc", false);
        Vector<MockChannelProcessor> list = new Vector<MockChannelProcessor>();
        list.add(cpXyz);
        list.add(cpAbc);
        cdm.setChannelProcessors(list);
        ChannelDecisionManagerImplTests.assertEquals(list, (Object)cdm.getChannelProcessors());
    }

    public void testStartupFailsWithEmptyChannelProcessorsList() throws Exception {
        ChannelDecisionManagerImpl cdm = new ChannelDecisionManagerImpl();
        try {
            cdm.afterPropertiesSet();
            ChannelDecisionManagerImplTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            ChannelDecisionManagerImplTests.assertEquals((String)"A list of ChannelProcessors is required", (String)expected.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockChannelProcessor
    implements ChannelProcessor {
        private String configAttribute;
        private boolean failIfCalled;

        public MockChannelProcessor(String configAttribute, boolean failIfCalled) {
            this.configAttribute = configAttribute;
            this.failIfCalled = failIfCalled;
        }

        private MockChannelProcessor() {
        }

        public void decide(FilterInvocation invocation, ConfigAttributeDefinition config) throws IOException, ServletException {
            Iterator iter = config.getConfigAttributes();
            if (this.failIfCalled) {
                Assert.fail((String)("Should not have called this channel processor: " + this.configAttribute));
            }
            while (iter.hasNext()) {
                ConfigAttribute attr = (ConfigAttribute)iter.next();
                if (!attr.getAttribute().equals(this.configAttribute)) continue;
                invocation.getHttpResponse().sendRedirect("/redirected");
                return;
            }
        }

        public boolean supports(ConfigAttribute attribute) {
            return attribute.getAttribute().equals(this.configAttribute);
        }
    }
}

