/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.securechannel;

import java.util.HashMap;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.MockPortResolver;
import org.acegisecurity.securechannel.RetryWithHttpEntryPoint;
import org.acegisecurity.util.PortMapper;
import org.acegisecurity.util.PortMapperImpl;
import org.acegisecurity.util.PortResolver;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class RetryWithHttpEntryPointTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$securechannel$RetryWithHttpEntryPointTests;

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$securechannel$RetryWithHttpEntryPointTests == null ? (class$org$acegisecurity$securechannel$RetryWithHttpEntryPointTests = RetryWithHttpEntryPointTests.class$("org.acegisecurity.securechannel.RetryWithHttpEntryPointTests")) : class$org$acegisecurity$securechannel$RetryWithHttpEntryPointTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testDetectsMissingPortMapper() throws Exception {
        RetryWithHttpEntryPoint ep = new RetryWithHttpEntryPoint();
        ep.setPortMapper(null);
        try {
            ep.afterPropertiesSet();
            RetryWithHttpEntryPointTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            RetryWithHttpEntryPointTests.assertEquals((String)"portMapper is required", (String)expected.getMessage());
        }
    }

    public void testDetectsMissingPortResolver() throws Exception {
        RetryWithHttpEntryPoint ep = new RetryWithHttpEntryPoint();
        ep.setPortResolver(null);
        try {
            ep.afterPropertiesSet();
            RetryWithHttpEntryPointTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            RetryWithHttpEntryPointTests.assertEquals((String)"portResolver is required", (String)expected.getMessage());
        }
    }

    public void testGettersSetters() {
        RetryWithHttpEntryPoint ep = new RetryWithHttpEntryPoint();
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setPortResolver((PortResolver)new MockPortResolver(8080, 8443));
        RetryWithHttpEntryPointTests.assertTrue((ep.getPortMapper() != null ? 1 : 0) != 0);
        RetryWithHttpEntryPointTests.assertTrue((ep.getPortResolver() != null ? 1 : 0) != 0);
    }

    public void testNormalOperation() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setQueryString("open=true");
        request.setScheme("https");
        request.setServerName("www.example.com");
        request.setContextPath("/bigWebApp");
        request.setServletPath("/hello");
        request.setPathInfo("/pathInfo.html");
        request.setServerPort(443);
        MockHttpServletResponse response = new MockHttpServletResponse();
        RetryWithHttpEntryPoint ep = new RetryWithHttpEntryPoint();
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setPortResolver((PortResolver)new MockPortResolver(80, 443));
        ep.afterPropertiesSet();
        ep.commence((ServletRequest)request, (ServletResponse)response);
        RetryWithHttpEntryPointTests.assertEquals((String)"http://www.example.com/bigWebApp/hello/pathInfo.html?open=true", (String)response.getRedirectedUrl());
    }

    public void testNormalOperationWithNullPathInfoAndNullQueryString() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setScheme("https");
        request.setServerName("www.example.com");
        request.setContextPath("/bigWebApp");
        request.setServletPath("/hello");
        request.setPathInfo(null);
        request.setServerPort(443);
        MockHttpServletResponse response = new MockHttpServletResponse();
        RetryWithHttpEntryPoint ep = new RetryWithHttpEntryPoint();
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setPortResolver((PortResolver)new MockPortResolver(80, 443));
        ep.afterPropertiesSet();
        ep.commence((ServletRequest)request, (ServletResponse)response);
        RetryWithHttpEntryPointTests.assertEquals((String)"http://www.example.com/bigWebApp/hello", (String)response.getRedirectedUrl());
    }

    public void testOperationWhenTargetPortIsUnknown() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setQueryString("open=true");
        request.setScheme("https");
        request.setServerName("www.example.com");
        request.setContextPath("/bigWebApp");
        request.setServletPath("/hello");
        request.setPathInfo("/pathInfo.html");
        request.setServerPort(8768);
        MockHttpServletResponse response = new MockHttpServletResponse();
        RetryWithHttpEntryPoint ep = new RetryWithHttpEntryPoint();
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setPortResolver((PortResolver)new MockPortResolver(8768, 1234));
        ep.afterPropertiesSet();
        ep.commence((ServletRequest)request, (ServletResponse)response);
        RetryWithHttpEntryPointTests.assertEquals((String)"/bigWebApp", (String)response.getRedirectedUrl());
    }

    public void testOperationWithNonStandardPort() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setQueryString("open=true");
        request.setScheme("https");
        request.setServerName("www.example.com");
        request.setContextPath("/bigWebApp");
        request.setServletPath("/hello");
        request.setPathInfo("/pathInfo.html");
        request.setServerPort(9999);
        MockHttpServletResponse response = new MockHttpServletResponse();
        PortMapperImpl portMapper = new PortMapperImpl();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("8888", "9999");
        portMapper.setPortMappings(map);
        RetryWithHttpEntryPoint ep = new RetryWithHttpEntryPoint();
        ep.setPortResolver((PortResolver)new MockPortResolver(8888, 9999));
        ep.setPortMapper((PortMapper)portMapper);
        ep.afterPropertiesSet();
        ep.commence((ServletRequest)request, (ServletResponse)response);
        RetryWithHttpEntryPointTests.assertEquals((String)"http://www.example.com:8888/bigWebApp/hello/pathInfo.html?open=true", (String)response.getRedirectedUrl());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

