/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.taglibs.authz;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import junit.framework.TestCase;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.MockAclManager;
import org.acegisecurity.MockApplicationContext;
import org.acegisecurity.acl.AclEntry;
import org.acegisecurity.acl.basic.AclObjectIdentity;
import org.acegisecurity.acl.basic.MockAclObjectIdentity;
import org.acegisecurity.acl.basic.SimpleAclEntry;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.TestingAuthenticationToken;
import org.acegisecurity.taglibs.authz.AclTag;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class AclTagTests
extends TestCase {
    private final MyAclTag aclTag = new MyAclTag();

    public void testInclusionDeniedWhenAclManagerUnawareOfObject() throws JspException {
        TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)"marissa", (Object)"koala", new GrantedAuthority[0]);
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        this.aclTag.setHasPermission(new Long(SimpleAclEntry.ADMINISTRATION).toString());
        this.aclTag.setDomainObject(new Integer(54));
        AclTagTests.assertEquals((int)0, (int)this.aclTag.doStartTag());
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    public void testInclusionDeniedWhenNoListOfPermissionsGiven() throws JspException {
        TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)"marissa", (Object)"koala", new GrantedAuthority[0]);
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        this.aclTag.setHasPermission(null);
        this.aclTag.setDomainObject("object1");
        AclTagTests.assertEquals((int)0, (int)this.aclTag.doStartTag());
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    public void testInclusionDeniedWhenPrincipalDoesNotHoldAnyPermissions() throws JspException {
        TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)"john", (Object)"crow", new GrantedAuthority[0]);
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        this.aclTag.setHasPermission(new Integer(SimpleAclEntry.ADMINISTRATION) + "," + new Integer(SimpleAclEntry.READ));
        AclTagTests.assertEquals((String)(new Integer(SimpleAclEntry.ADMINISTRATION) + "," + new Integer(SimpleAclEntry.READ)), (String)this.aclTag.getHasPermission());
        this.aclTag.setDomainObject("object1");
        AclTagTests.assertEquals((Object)"object1", (Object)this.aclTag.getDomainObject());
        AclTagTests.assertEquals((int)0, (int)this.aclTag.doStartTag());
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    public void testInclusionDeniedWhenPrincipalDoesNotHoldRequiredPermissions() throws JspException {
        TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)"marissa", (Object)"koala", new GrantedAuthority[0]);
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        this.aclTag.setHasPermission(new Integer(SimpleAclEntry.DELETE).toString());
        this.aclTag.setDomainObject("object1");
        AclTagTests.assertEquals((int)0, (int)this.aclTag.doStartTag());
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    public void testInclusionDeniedWhenSecurityContextEmpty() throws JspException {
        SecurityContextHolder.getContext().setAuthentication(null);
        this.aclTag.setHasPermission(new Long(SimpleAclEntry.ADMINISTRATION).toString());
        this.aclTag.setDomainObject("object1");
        AclTagTests.assertEquals((int)0, (int)this.aclTag.doStartTag());
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    public void testInclusionPermittedWhenDomainObjectIsNull() throws JspException {
        this.aclTag.setHasPermission(new Integer(SimpleAclEntry.READ).toString());
        this.aclTag.setDomainObject(null);
        AclTagTests.assertEquals((int)1, (int)this.aclTag.doStartTag());
    }

    public void testJspExceptionThrownIfHasPermissionNotValidFormat() throws JspException {
        TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)"john", (Object)"crow", new GrantedAuthority[0]);
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        this.aclTag.setHasPermission("0,5, 6");
        try {
            this.aclTag.doStartTag();
            AclTagTests.fail((String)"Should have thrown JspException");
        }
        catch (JspException expected) {
            AclTagTests.assertTrue((boolean)true);
        }
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    public void testOperationWhenPrincipalHoldsPermissionOfMultipleList() throws JspException {
        TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)"marissa", (Object)"koala", new GrantedAuthority[0]);
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        this.aclTag.setHasPermission(new Integer(SimpleAclEntry.ADMINISTRATION) + "," + new Integer(SimpleAclEntry.READ));
        this.aclTag.setDomainObject("object1");
        AclTagTests.assertEquals((int)1, (int)this.aclTag.doStartTag());
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    public void testOperationWhenPrincipalHoldsPermissionOfSingleList() throws JspException {
        TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)"marissa", (Object)"koala", new GrantedAuthority[0]);
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        this.aclTag.setHasPermission(new Integer(SimpleAclEntry.READ).toString());
        this.aclTag.setDomainObject("object1");
        AclTagTests.assertEquals((int)1, (int)this.aclTag.doStartTag());
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    private class MyAclTag
    extends AclTag {
        private MyAclTag() {
        }

        protected ApplicationContext getContext(PageContext pageContext) {
            ConfigurableApplicationContext context = MockApplicationContext.getContext();
            MockAclManager aclManager = new MockAclManager("object1", "marissa", new AclEntry[]{new MockAclEntry(), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ)});
            context.getBeanFactory().registerSingleton("aclManager", (Object)aclManager);
            return context;
        }
    }

    private class MockAclEntry
    implements AclEntry {
        private MockAclEntry() {
        }
    }
}

