/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.taglibs.authz;

import javax.servlet.jsp.JspException;
import junit.framework.TestCase;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.TestingAuthenticationToken;
import org.acegisecurity.taglibs.authz.AuthorizeTag;

public class AuthorizeTagCustomGrantedAuthorityTests
extends TestCase {
    private final AuthorizeTag authorizeTag = new AuthorizeTag();
    private TestingAuthenticationToken currentUser;

    protected void setUp() throws Exception {
        super.setUp();
        this.currentUser = new TestingAuthenticationToken((Object)"abc", (Object)"123", new GrantedAuthority[]{new CustomGrantedAuthority("ROLE_TELLER")});
        SecurityContextHolder.getContext().setAuthentication((Authentication)this.currentUser);
    }

    protected void tearDown() throws Exception {
        SecurityContextHolder.clearContext();
    }

    public void testAllowsRequestWhenCustomAuthorityPresentsCorrectRole() throws JspException {
        this.authorizeTag.setIfAnyGranted("ROLE_TELLER");
        AuthorizeTagCustomGrantedAuthorityTests.assertEquals((String)"authorized - ROLE_TELLER in both sets", (int)1, (int)this.authorizeTag.doStartTag());
    }

    public void testRejectsRequestWhenCustomAuthorityReturnsNull() throws JspException {
        this.authorizeTag.setIfAnyGranted("ROLE_TELLER");
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)"abc", (Object)"123", new GrantedAuthority[]{new CustomGrantedAuthority(null)}));
        try {
            this.authorizeTag.doStartTag();
            AuthorizeTagCustomGrantedAuthorityTests.fail((String)"Failed to reject GrantedAuthority with NULL getAuthority()");
        }
        catch (IllegalArgumentException expected) {
            AuthorizeTagCustomGrantedAuthorityTests.assertTrue((String)"expected", (boolean)true);
        }
    }

    private static class CustomGrantedAuthority
    implements GrantedAuthority {
        private final String authority;

        public CustomGrantedAuthority(String authority) {
            this.authority = authority;
        }

        public String getAuthority() {
            return this.authority;
        }
    }
}

