/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.taglibs.authz;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import junit.framework.TestCase;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.TestingAuthenticationToken;
import org.acegisecurity.taglibs.authz.AuthorizeTag;
import org.springframework.mock.web.MockPageContext;

public class AuthorizeTagExpressionLanguageTests
extends TestCase {
    private final AuthorizeTag authorizeTag = new AuthorizeTag();
    private MockPageContext pageContext;
    private TestingAuthenticationToken currentUser;

    protected void setUp() throws Exception {
        super.setUp();
        this.pageContext = new MockPageContext();
        this.authorizeTag.setPageContext((PageContext)this.pageContext);
        this.currentUser = new TestingAuthenticationToken((Object)"abc", (Object)"123", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_TELLER")});
        SecurityContextHolder.getContext().setAuthentication((Authentication)this.currentUser);
    }

    protected void tearDown() throws Exception {
        SecurityContextHolder.clearContext();
    }

    public void testAllGrantedUsesExpressionLanguageWhenExpressionIsEL() throws JspException {
        this.pageContext.setAttribute("authority", (Object)"ROLE_TELLER");
        this.authorizeTag.setIfAllGranted("${authority}");
        AuthorizeTagExpressionLanguageTests.assertEquals((String)"allows body - authority var contains ROLE_TELLER", (int)1, (int)this.authorizeTag.doStartTag());
    }

    public void testAnyGrantedUsesExpressionLanguageWhenExpressionIsEL() throws JspException {
        this.pageContext.setAttribute("authority", (Object)"ROLE_TELLER");
        this.authorizeTag.setIfAnyGranted("${authority}");
        AuthorizeTagExpressionLanguageTests.assertEquals((String)"allows body - authority var contains ROLE_TELLER", (int)1, (int)this.authorizeTag.doStartTag());
    }

    public void testNotGrantedUsesExpressionLanguageWhenExpressionIsEL() throws JspException {
        this.pageContext.setAttribute("authority", (Object)"ROLE_TELLER");
        this.authorizeTag.setIfNotGranted("${authority}");
        AuthorizeTagExpressionLanguageTests.assertEquals((String)"allows body - authority var contains ROLE_TELLER", (int)0, (int)this.authorizeTag.doStartTag());
    }
}

