/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.taglibs.velocity;

import junit.framework.TestCase;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.TestingAuthenticationToken;
import org.acegisecurity.taglibs.velocity.Authz;
import org.acegisecurity.taglibs.velocity.AuthzImpl;

public class AuthzImplAuthorizeTagTest
extends TestCase {
    private Authz authz = new AuthzImpl();
    private TestingAuthenticationToken currentUser;

    protected void setUp() throws Exception {
        super.setUp();
        this.currentUser = new TestingAuthenticationToken((Object)"abc", (Object)"123", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_SUPERVISOR"), new GrantedAuthorityImpl("ROLE_TELLER")});
        SecurityContextHolder.getContext().setAuthentication((Authentication)this.currentUser);
    }

    protected void tearDown() throws Exception {
        SecurityContextHolder.clearContext();
    }

    public void testAlwaysReturnsUnauthorizedIfNoUserFound() {
        SecurityContextHolder.getContext().setAuthentication(null);
        AuthzImplAuthorizeTagTest.assertFalse((boolean)this.authz.allGranted("ROLE_TELLER"));
    }

    public void testDefaultsToNotOutputtingBodyWhenNoRequiredAuthorities() {
        AuthzImplAuthorizeTagTest.assertFalse((boolean)this.authz.allGranted(""));
        AuthzImplAuthorizeTagTest.assertFalse((boolean)this.authz.anyGranted(""));
        AuthzImplAuthorizeTagTest.assertFalse((boolean)this.authz.noneGranted(""));
    }

    public void testOutputsBodyIfOneRolePresent() {
        AuthzImplAuthorizeTagTest.assertTrue((boolean)this.authz.anyGranted("ROLE_TELLER"));
    }

    public void testOutputsBodyWhenAllGranted() {
        AuthzImplAuthorizeTagTest.assertTrue((boolean)this.authz.allGranted("ROLE_SUPERVISOR,ROLE_TELLER"));
    }

    public void testOutputsBodyWhenNotGrantedSatisfied() {
        AuthzImplAuthorizeTagTest.assertTrue((boolean)this.authz.noneGranted("ROLE_BANKER"));
    }

    public void testPreventsBodyOutputIfNoSecureContext() {
        SecurityContextHolder.getContext().setAuthentication(null);
        AuthzImplAuthorizeTagTest.assertFalse((boolean)this.authz.anyGranted("ROLE_BANKER"));
    }

    public void testSkipsBodyIfNoAnyRolePresent() {
        AuthzImplAuthorizeTagTest.assertFalse((boolean)this.authz.anyGranted("ROLE_BANKER"));
    }

    public void testSkipsBodyWhenMissingAnAllGranted() {
        AuthzImplAuthorizeTagTest.assertFalse((boolean)this.authz.allGranted("ROLE_SUPERVISOR,ROLE_TELLER,ROLE_BANKER"));
    }

    public void testSkipsBodyWhenNotGrantedUnsatisfied() {
        AuthzImplAuthorizeTagTest.assertFalse((boolean)this.authz.noneGranted("ROLE_TELLER"));
    }
}

