/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.taglibs.velocity;

import junit.framework.TestCase;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.MockAclManager;
import org.acegisecurity.acl.AclEntry;
import org.acegisecurity.acl.basic.AclObjectIdentity;
import org.acegisecurity.acl.basic.MockAclObjectIdentity;
import org.acegisecurity.acl.basic.SimpleAclEntry;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.TestingAuthenticationToken;
import org.acegisecurity.taglibs.velocity.Authz;
import org.acegisecurity.taglibs.velocity.AuthzImpl;
import org.acegisecurity.userdetails.User;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

public class AuthzImplTest
extends TestCase {
    private Authz authz = new AuthzImpl();
    private ConfigurableApplicationContext ctx;

    protected void setUp() throws Exception {
        super.setUp();
        this.ctx = new StaticApplicationContext();
        MockAclManager aclManager = new MockAclManager("object1", "marissa", new AclEntry[]{new MockAclEntry(), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ)});
        this.ctx.getBeanFactory().registerSingleton("aclManager", (Object)aclManager);
    }

    public void testIllegalArgumentExceptionThrownIfHasPermissionNotValidFormat() {
        TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)"john", (Object)"crow", new GrantedAuthority[0]);
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        this.authz.setAppCtx((ApplicationContext)this.ctx);
        String permissions = "0,5, 6";
        try {
            this.authz.hasPermission(null, permissions);
        }
        catch (IllegalArgumentException iae) {
            AuthzImplTest.assertTrue((boolean)true);
        }
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    public void testInclusionDeniedWhenAclManagerUnawareOfObject() {
        TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)"marissa", (Object)"koala", new GrantedAuthority[0]);
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        this.authz.setAppCtx((ApplicationContext)this.ctx);
        boolean result = this.authz.hasPermission((Object)new Integer(54), new Long(SimpleAclEntry.ADMINISTRATION).toString());
        AuthzImplTest.assertFalse((boolean)result);
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    public void testInclusionDeniedWhenNoListOfPermissionsGiven() {
        TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)"marissa", (Object)"koala", new GrantedAuthority[0]);
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        this.authz.setAppCtx((ApplicationContext)this.ctx);
        boolean result = this.authz.hasPermission((Object)"object1", null);
        AuthzImplTest.assertFalse((boolean)result);
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    public void testInclusionDeniedWhenPrincipalDoesNotHoldAnyPermissions() {
        TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)"john", (Object)"crow", new GrantedAuthority[0]);
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        this.authz.setAppCtx((ApplicationContext)this.ctx);
        String permissions = new Integer(SimpleAclEntry.ADMINISTRATION) + "," + new Integer(SimpleAclEntry.READ);
        boolean result = this.authz.hasPermission((Object)"object1", permissions);
        AuthzImplTest.assertFalse((boolean)result);
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    public void testInclusionDeniedWhenPrincipalDoesNotHoldRequiredPermissions() {
        TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)"marissa", (Object)"koala", new GrantedAuthority[0]);
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        this.authz.setAppCtx((ApplicationContext)this.ctx);
        String permissions = new Integer(SimpleAclEntry.DELETE).toString();
        boolean result = this.authz.hasPermission((Object)"object1", permissions);
        AuthzImplTest.assertFalse((boolean)result);
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    public void testInclusionDeniedWhenSecurityContextEmpty() {
        SecurityContextHolder.getContext().setAuthentication(null);
        this.authz.setAppCtx((ApplicationContext)this.ctx);
        String permissions = new Long(SimpleAclEntry.ADMINISTRATION).toString();
        boolean result = this.authz.hasPermission((Object)"object1", permissions);
        AuthzImplTest.assertFalse((boolean)result);
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    public void testInclusionPermittedWhenDomainObjectIsNull() {
        this.authz.setAppCtx((ApplicationContext)this.ctx);
        String permissions = new Integer(SimpleAclEntry.READ).toString();
        boolean result = this.authz.hasPermission(null, permissions);
        AuthzImplTest.assertTrue((boolean)result);
    }

    public void testOperationWhenPrincipalHoldsPermissionOfMultipleList() {
        TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)"marissa", (Object)"koala", new GrantedAuthority[0]);
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        this.authz.setAppCtx((ApplicationContext)this.ctx);
        String permissions = new Integer(SimpleAclEntry.ADMINISTRATION) + "," + new Integer(SimpleAclEntry.READ);
        boolean result = this.authz.hasPermission((Object)"object1", permissions);
        AuthzImplTest.assertTrue((boolean)result);
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    public void testOperationWhenPrincipalHoldsPermissionOfSingleList() {
        TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)"marissa", (Object)"koala", new GrantedAuthority[0]);
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        this.authz.setAppCtx((ApplicationContext)this.ctx);
        String permissions = new Integer(SimpleAclEntry.READ).toString();
        boolean result = this.authz.hasPermission((Object)"object1", permissions);
        AuthzImplTest.assertTrue((boolean)result);
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    public void testOperationWhenPrincipalIsAString() {
        TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)"marissaAsString", (Object)"koala", new GrantedAuthority[0]);
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        AuthzImplTest.assertEquals((String)"marissaAsString", (String)this.authz.getPrincipal());
    }

    public void testOperationWhenPrincipalIsAUserDetailsInstance() {
        TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)new User("marissaUserDetails", "koala", true, true, true, true, new GrantedAuthority[0]), (Object)"koala", new GrantedAuthority[0]);
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        AuthzImplTest.assertEquals((String)"marissaUserDetails", (String)this.authz.getPrincipal());
    }

    public void testOperationWhenPrincipalIsNull() {
        TestingAuthenticationToken auth = new TestingAuthenticationToken(null, (Object)"koala", new GrantedAuthority[0]);
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        AuthzImplTest.assertNull((Object)this.authz.getPrincipal());
    }

    public void testOperationWhenSecurityContextIsNull() {
        SecurityContextHolder.getContext().setAuthentication(null);
        AuthzImplTest.assertEquals(null, (String)this.authz.getPrincipal());
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    private class MockAclEntry
    implements AclEntry {
        private static final long serialVersionUID = 1L;

        private MockAclEntry() {
        }
    }
}

