/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ui;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.AccountExpiredException;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.MockAuthenticationManager;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.ui.AbstractProcessingFilter;
import org.acegisecurity.ui.rememberme.RememberMeServices;
import org.acegisecurity.ui.rememberme.TokenBasedRememberMeServices;
import org.acegisecurity.ui.savedrequest.SavedRequest;
import org.acegisecurity.util.PortResolver;
import org.acegisecurity.util.PortResolverImpl;
import org.springframework.mock.web.MockFilterConfig;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class AbstractProcessingFilterTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$ui$AbstractProcessingFilterTests;
    static /* synthetic */ Class class$org$acegisecurity$AccountExpiredException;
    static /* synthetic */ Class class$org$acegisecurity$ui$rememberme$TokenBasedRememberMeServices;

    public AbstractProcessingFilterTests() {
    }

    public AbstractProcessingFilterTests(String arg0) {
        super(arg0);
    }

    private MockHttpServletRequest createMockRequest() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServletPath("/j_mock_post");
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setRequestURI("/mycontext/j_mock_post");
        request.setContextPath("/mycontext");
        return request;
    }

    private void executeFilterInContainerSimulator(FilterConfig filterConfig, Filter filter, ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        filter.init(filterConfig);
        filter.doFilter(request, response, filterChain);
        filter.destroy();
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$ui$AbstractProcessingFilterTests == null ? (class$org$acegisecurity$ui$AbstractProcessingFilterTests = AbstractProcessingFilterTests.class$("org.acegisecurity.ui.AbstractProcessingFilterTests")) : class$org$acegisecurity$ui$AbstractProcessingFilterTests));
    }

    private SavedRequest makeSavedRequestForUrl() {
        MockHttpServletRequest request = this.createMockRequest();
        request.setServletPath("/some_protected_file.html");
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setRequestURI("/mycontext/some_protected_file.html");
        return new SavedRequest((HttpServletRequest)request, (PortResolver)new PortResolverImpl());
    }

    protected void setUp() throws Exception {
        super.setUp();
        SecurityContextHolder.clearContext();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        SecurityContextHolder.clearContext();
    }

    public void testDefaultProcessesFilterUrlWithPathParameter() {
        MockHttpServletRequest request = this.createMockRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter();
        filter.setFilterProcessesUrl("/j_acegi_security_check");
        request.setRequestURI("/mycontext/j_acegi_security_check;jsessionid=I8MIONOSTHOR");
        AbstractProcessingFilterTests.assertTrue((boolean)filter.requiresAuthentication((HttpServletRequest)request, (HttpServletResponse)response));
    }

    public void testDoFilterWithNonHttpServletRequestDetected() throws Exception {
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter();
        try {
            filter.doFilter(null, (ServletResponse)new MockHttpServletResponse(), new MockFilterChain());
            AbstractProcessingFilterTests.fail((String)"Should have thrown ServletException");
        }
        catch (ServletException expected) {
            AbstractProcessingFilterTests.assertEquals((String)"Can only process HttpServletRequest", (String)expected.getMessage());
        }
    }

    public void testDoFilterWithNonHttpServletResponseDetected() throws Exception {
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter();
        try {
            filter.doFilter((ServletRequest)new MockHttpServletRequest(null, null), null, new MockFilterChain());
            AbstractProcessingFilterTests.fail((String)"Should have thrown ServletException");
        }
        catch (ServletException expected) {
            AbstractProcessingFilterTests.assertEquals((String)"Can only process HttpServletResponse", (String)expected.getMessage());
        }
    }

    public void testFailedAuthenticationRedirectsAppropriately() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(false);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter(false);
        filter.setAuthenticationFailureUrl("/failed.jsp");
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractProcessingFilterTests.assertEquals((String)"/mycontext/failed.jsp", (String)response.getRedirectedUrl());
        AbstractProcessingFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        filter = new MockAbstractProcessingFilter((AuthenticationException)((Object)new AccountExpiredException("You're account is expired")));
        filter.setAuthenticationFailureUrl("/failed.jsp");
        Properties exceptionMappings = filter.getExceptionMappings();
        exceptionMappings.setProperty((class$org$acegisecurity$AccountExpiredException == null ? (class$org$acegisecurity$AccountExpiredException = AbstractProcessingFilterTests.class$("org.acegisecurity.AccountExpiredException")) : class$org$acegisecurity$AccountExpiredException).getName(), "/accountExpired.jsp");
        filter.setExceptionMappings(exceptionMappings);
        response = new MockHttpServletResponse();
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractProcessingFilterTests.assertEquals((String)"/mycontext/accountExpired.jsp", (String)response.getRedirectedUrl());
        AbstractProcessingFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        AbstractProcessingFilterTests.assertEquals((int)8192, (int)response.getBufferSize());
    }

    public void testFilterProcessesUrlVariationsRespected() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        request.setServletPath("/j_OTHER_LOCATION");
        request.setRequestURI("/mycontext/j_OTHER_LOCATION");
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(false);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter(true);
        filter.setFilterProcessesUrl("/j_OTHER_LOCATION");
        filter.setDefaultTargetUrl("/logged_in.jsp");
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractProcessingFilterTests.assertEquals((String)"/mycontext/logged_in.jsp", (String)response.getRedirectedUrl());
        AbstractProcessingFilterTests.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        AbstractProcessingFilterTests.assertEquals((String)"test", (String)SecurityContextHolder.getContext().getAuthentication().getPrincipal().toString());
        AbstractProcessingFilterTests.assertEquals((int)8192, (int)response.getBufferSize());
    }

    public void testGettersSetters() {
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter();
        AbstractProcessingFilterTests.assertNotNull((Object)filter.getRememberMeServices());
        filter.setRememberMeServices((RememberMeServices)new TokenBasedRememberMeServices());
        AbstractProcessingFilterTests.assertEquals((Object)(class$org$acegisecurity$ui$rememberme$TokenBasedRememberMeServices == null ? (class$org$acegisecurity$ui$rememberme$TokenBasedRememberMeServices = AbstractProcessingFilterTests.class$("org.acegisecurity.ui.rememberme.TokenBasedRememberMeServices")) : class$org$acegisecurity$ui$rememberme$TokenBasedRememberMeServices), filter.getRememberMeServices().getClass());
        filter.setAuthenticationFailureUrl("/x");
        AbstractProcessingFilterTests.assertEquals((String)"/x", (String)filter.getAuthenticationFailureUrl());
        filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        AbstractProcessingFilterTests.assertTrue((filter.getAuthenticationManager() != null ? 1 : 0) != 0);
        filter.setDefaultTargetUrl("/default");
        AbstractProcessingFilterTests.assertEquals((String)"/default", (String)filter.getDefaultTargetUrl());
        filter.setFilterProcessesUrl("/p");
        AbstractProcessingFilterTests.assertEquals((String)"/p", (String)filter.getFilterProcessesUrl());
        filter.setAuthenticationFailureUrl("/fail");
        AbstractProcessingFilterTests.assertEquals((String)"/fail", (String)filter.getAuthenticationFailureUrl());
    }

    public void testDefaultUrlMuststartWithSlashOrHttpScheme() {
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter();
        filter.setDefaultTargetUrl("/acceptableRelativeUrl");
        filter.setDefaultTargetUrl("http://some.site.org/index.html");
        filter.setDefaultTargetUrl("https://some.site.org/index.html");
        try {
            filter.setDefaultTargetUrl("missingSlash");
            AbstractProcessingFilterTests.fail((String)"Shouldn't accept default target without leading slash");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testIgnoresAnyServletPathOtherThanFilterProcessesUrl() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        request.setServletPath("/some.file.html");
        request.setRequestURI("/mycontext/some.file.html");
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter(false);
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
    }

    public void testNormalOperationWithDefaultFilterProcessesUrl() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(false);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter(true);
        filter.setFilterProcessesUrl("/j_mock_post");
        filter.setDefaultTargetUrl("/logged_in.jsp");
        filter.setAuthenticationFailureUrl("/failure.jsp");
        filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager(true));
        filter.afterPropertiesSet();
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractProcessingFilterTests.assertEquals((String)"/mycontext/logged_in.jsp", (String)response.getRedirectedUrl());
        AbstractProcessingFilterTests.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        AbstractProcessingFilterTests.assertEquals((String)"test", (String)SecurityContextHolder.getContext().getAuthentication().getPrincipal().toString());
        AbstractProcessingFilterTests.assertEquals((int)8192, (int)response.getBufferSize());
    }

    public void testStartupDetectsInvalidAuthenticationFailureUrl() throws Exception {
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        filter.setDefaultTargetUrl("/");
        filter.setFilterProcessesUrl("/j_acegi_security_check");
        try {
            filter.afterPropertiesSet();
            AbstractProcessingFilterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AbstractProcessingFilterTests.assertEquals((String)"authenticationFailureUrl must be specified", (String)expected.getMessage());
        }
    }

    public void testStartupDetectsInvalidAuthenticationManager() throws Exception {
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter();
        filter.setAuthenticationFailureUrl("/failed.jsp");
        filter.setDefaultTargetUrl("/");
        filter.setFilterProcessesUrl("/j_acegi_security_check");
        try {
            filter.afterPropertiesSet();
            AbstractProcessingFilterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AbstractProcessingFilterTests.assertEquals((String)"authenticationManager must be specified", (String)expected.getMessage());
        }
    }

    public void testStartupDetectsInvalidDefaultTargetUrl() throws Exception {
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter();
        filter.setAuthenticationFailureUrl("/failed.jsp");
        filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        filter.setFilterProcessesUrl("/j_acegi_security_check");
        try {
            filter.afterPropertiesSet();
            AbstractProcessingFilterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AbstractProcessingFilterTests.assertEquals((String)"defaultTargetUrl must be specified", (String)expected.getMessage());
        }
    }

    public void testStartupDetectsInvalidFilterProcessesUrl() throws Exception {
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter();
        filter.setAuthenticationFailureUrl("/failed.jsp");
        filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        filter.setDefaultTargetUrl("/");
        filter.setFilterProcessesUrl(null);
        try {
            filter.afterPropertiesSet();
            AbstractProcessingFilterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AbstractProcessingFilterTests.assertEquals((String)"filterProcessesUrl must be specified", (String)expected.getMessage());
        }
    }

    public void testSuccessLoginThenFailureLoginResultsInSessionLosingToken() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(false);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter(true);
        filter.setFilterProcessesUrl("/j_mock_post");
        filter.setDefaultTargetUrl("/logged_in.jsp");
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractProcessingFilterTests.assertEquals((String)"/mycontext/logged_in.jsp", (String)response.getRedirectedUrl());
        AbstractProcessingFilterTests.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        AbstractProcessingFilterTests.assertEquals((String)"test", (String)SecurityContextHolder.getContext().getAuthentication().getPrincipal().toString());
        AbstractProcessingFilterTests.assertEquals((int)8192, (int)response.getBufferSize());
        chain = new MockFilterChain(false);
        response = new MockHttpServletResponse();
        filter = new MockAbstractProcessingFilter(false);
        filter.setFilterProcessesUrl("/j_mock_post");
        filter.setAuthenticationFailureUrl("/failed.jsp");
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractProcessingFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    public void testSuccessfulAuthenticationButWithAlwaysUseDefaultTargetUrlCausesRedirectToDefaultTargetUrl() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        request.getSession().setAttribute("ACEGI_SAVED_REQUEST_KEY", (Object)this.makeSavedRequestForUrl());
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter(true);
        filter.setFilterProcessesUrl("/j_mock_post");
        filter.setDefaultTargetUrl("/foobar");
        AbstractProcessingFilterTests.assertFalse((boolean)filter.isAlwaysUseDefaultTargetUrl());
        filter.setAlwaysUseDefaultTargetUrl(true);
        AbstractProcessingFilterTests.assertTrue((boolean)filter.isAlwaysUseDefaultTargetUrl());
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractProcessingFilterTests.assertEquals((String)"/mycontext/foobar", (String)response.getRedirectedUrl());
        AbstractProcessingFilterTests.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    public void testSuccessfulAuthenticationCausesRedirectToSessionSpecifiedUrl() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        request.getSession().setAttribute("ACEGI_SAVED_REQUEST_KEY", (Object)this.makeSavedRequestForUrl());
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter(true);
        filter.setFilterProcessesUrl("/j_mock_post");
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractProcessingFilterTests.assertEquals((String)this.makeSavedRequestForUrl().getFullRequestUrl(), (String)response.getRedirectedUrl());
        AbstractProcessingFilterTests.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        AbstractProcessingFilterTests.assertEquals((int)8192, (int)response.getBufferSize());
    }

    public void testFullDefaultTargetUrlDoesNotHaveContextPathPrepended() throws Exception {
        MockHttpServletRequest request = this.createMockRequest();
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockAbstractProcessingFilter filter = new MockAbstractProcessingFilter(true);
        filter.setFilterProcessesUrl("/j_mock_post");
        filter.setDefaultTargetUrl("http://monkeymachine.co.uk/");
        filter.setAlwaysUseDefaultTargetUrl(true);
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        AbstractProcessingFilterTests.assertEquals((String)"http://monkeymachine.co.uk/", (String)response.getRedirectedUrl());
        AbstractProcessingFilterTests.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockFilterChain
    implements FilterChain {
        private boolean expectToProceed;

        public MockFilterChain(boolean expectToProceed) {
            this.expectToProceed = expectToProceed;
        }

        private MockFilterChain() {
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this.expectToProceed) {
                Assert.assertTrue((boolean)true);
            } else {
                Assert.fail((String)"Did not expect filter chain to proceed");
            }
        }
    }

    private class MockAbstractProcessingFilter
    extends AbstractProcessingFilter {
        private AuthenticationException exceptionToThrow;
        private boolean grantAccess;

        public MockAbstractProcessingFilter(boolean grantAccess) {
            this.grantAccess = grantAccess;
            this.exceptionToThrow = new BadCredentialsException("Mock requested to do so");
        }

        public MockAbstractProcessingFilter(AuthenticationException exceptionToThrow) {
            this.grantAccess = false;
            this.exceptionToThrow = exceptionToThrow;
        }

        private MockAbstractProcessingFilter() {
        }

        public Authentication attemptAuthentication(HttpServletRequest request) throws AuthenticationException {
            if (this.grantAccess) {
                return new UsernamePasswordAuthenticationToken((Object)"test", (Object)"test", new GrantedAuthority[]{new GrantedAuthorityImpl("TEST")});
            }
            throw this.exceptionToThrow;
        }

        public String getDefaultFilterProcessesUrl() {
            return "/j_mock_post";
        }

        public void init(FilterConfig arg0) throws ServletException {
        }

        public boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
            return super.requiresAuthentication(request, response);
        }
    }
}

