/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ui;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.MockAuthenticationEntryPoint;
import org.acegisecurity.MockPortResolver;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.anonymous.AnonymousAuthenticationToken;
import org.acegisecurity.ui.AbstractProcessingFilter;
import org.acegisecurity.ui.AccessDeniedHandler;
import org.acegisecurity.ui.AccessDeniedHandlerImpl;
import org.acegisecurity.ui.AuthenticationEntryPoint;
import org.acegisecurity.ui.ExceptionTranslationFilter;
import org.acegisecurity.util.PortResolver;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class ExceptionTranslationFilterTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$ui$ExceptionTranslationFilterTests;
    static /* synthetic */ Class class$org$acegisecurity$AccessDeniedException;

    public ExceptionTranslationFilterTests() {
    }

    public ExceptionTranslationFilterTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$ui$ExceptionTranslationFilterTests == null ? (class$org$acegisecurity$ui$ExceptionTranslationFilterTests = ExceptionTranslationFilterTests.class$("org.acegisecurity.ui.ExceptionTranslationFilterTests")) : class$org$acegisecurity$ui$ExceptionTranslationFilterTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        SecurityContextHolder.clearContext();
    }

    public void testAccessDeniedWhenAnonymous() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServletPath("/secure/page.html");
        request.setServerPort(80);
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setContextPath("/mycontext");
        request.setRequestURI("/mycontext/secure/page.html");
        MockFilterChain chain = new MockFilterChain(true, false, false, false);
        SecurityContextHolder.getContext().setAuthentication((Authentication)new AnonymousAuthenticationToken("ignored", (Object)"ignored", new GrantedAuthority[]{new GrantedAuthorityImpl("IGNORED")}));
        ExceptionTranslationFilter filter = new ExceptionTranslationFilter();
        filter.setAuthenticationEntryPoint((AuthenticationEntryPoint)new MockAuthenticationEntryPoint("/login.jsp"));
        MockHttpServletResponse response = new MockHttpServletResponse();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        ExceptionTranslationFilterTests.assertEquals((String)"/mycontext/login.jsp", (String)response.getRedirectedUrl());
        ExceptionTranslationFilterTests.assertEquals((String)"http://www.example.com/mycontext/secure/page.html", (String)AbstractProcessingFilter.obtainFullRequestUrl((HttpServletRequest)request));
    }

    public void testAccessDeniedWhenNonAnonymous() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServletPath("/secure/page.html");
        MockFilterChain chain = new MockFilterChain(true, false, false, false);
        SecurityContextHolder.getContext().setAuthentication(null);
        AccessDeniedHandlerImpl adh = new AccessDeniedHandlerImpl();
        adh.setErrorPage("/error.jsp");
        ExceptionTranslationFilter filter = new ExceptionTranslationFilter();
        filter.setAuthenticationEntryPoint((AuthenticationEntryPoint)new MockAuthenticationEntryPoint("/login.jsp"));
        filter.setAccessDeniedHandler((AccessDeniedHandler)adh);
        MockHttpServletResponse response = new MockHttpServletResponse();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        ExceptionTranslationFilterTests.assertEquals((int)403, (int)response.getStatus());
        ExceptionTranslationFilterTests.assertEquals((Object)(class$org$acegisecurity$AccessDeniedException == null ? (class$org$acegisecurity$AccessDeniedException = ExceptionTranslationFilterTests.class$("org.acegisecurity.AccessDeniedException")) : class$org$acegisecurity$AccessDeniedException), request.getAttribute("ACEGI_SECURITY_403_EXCEPTION").getClass());
    }

    public void testDoFilterWithNonHttpServletRequestDetected() throws Exception {
        ExceptionTranslationFilter filter = new ExceptionTranslationFilter();
        try {
            filter.doFilter(null, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain(false, false, false, false));
            ExceptionTranslationFilterTests.fail((String)"Should have thrown ServletException");
        }
        catch (ServletException expected) {
            ExceptionTranslationFilterTests.assertEquals((String)"HttpServletRequest required", (String)expected.getMessage());
        }
    }

    public void testDoFilterWithNonHttpServletResponseDetected() throws Exception {
        ExceptionTranslationFilter filter = new ExceptionTranslationFilter();
        try {
            filter.doFilter((ServletRequest)new MockHttpServletRequest(null, null), null, (FilterChain)new MockFilterChain(false, false, false, false));
            ExceptionTranslationFilterTests.fail((String)"Should have thrown ServletException");
        }
        catch (ServletException expected) {
            ExceptionTranslationFilterTests.assertEquals((String)"HttpServletResponse required", (String)expected.getMessage());
        }
    }

    public void testGettersSetters() {
        ExceptionTranslationFilter filter = new ExceptionTranslationFilter();
        filter.setAuthenticationEntryPoint((AuthenticationEntryPoint)new MockAuthenticationEntryPoint("/login.jsp"));
        ExceptionTranslationFilterTests.assertTrue((filter.getAuthenticationEntryPoint() != null ? 1 : 0) != 0);
        filter.setPortResolver((PortResolver)new MockPortResolver(80, 443));
        ExceptionTranslationFilterTests.assertTrue((filter.getPortResolver() != null ? 1 : 0) != 0);
    }

    public void testRedirectedToLoginFormAndSessionShowsOriginalTargetWhenAuthenticationException() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServletPath("/secure/page.html");
        request.setServerPort(80);
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setContextPath("/mycontext");
        request.setRequestURI("/mycontext/secure/page.html");
        MockFilterChain chain = new MockFilterChain(false, true, false, false);
        ExceptionTranslationFilter filter = new ExceptionTranslationFilter();
        filter.setAuthenticationEntryPoint((AuthenticationEntryPoint)new MockAuthenticationEntryPoint("/login.jsp"));
        filter.setPortResolver((PortResolver)new MockPortResolver(80, 443));
        MockHttpServletResponse response = new MockHttpServletResponse();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        ExceptionTranslationFilterTests.assertEquals((String)"/mycontext/login.jsp", (String)response.getRedirectedUrl());
        ExceptionTranslationFilterTests.assertEquals((String)"http://www.example.com/mycontext/secure/page.html", (String)AbstractProcessingFilter.obtainFullRequestUrl((HttpServletRequest)request));
    }

    public void testRedirectedToLoginFormAndSessionShowsOriginalTargetWithExoticPortWhenAuthenticationException() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServletPath("/secure/page.html");
        request.setServerPort(8080);
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setContextPath("/mycontext");
        request.setRequestURI("/mycontext/secure/page.html");
        MockFilterChain chain = new MockFilterChain(false, true, false, false);
        ExceptionTranslationFilter filter = new ExceptionTranslationFilter();
        filter.setAuthenticationEntryPoint((AuthenticationEntryPoint)new MockAuthenticationEntryPoint("/login.jsp"));
        filter.setPortResolver((PortResolver)new MockPortResolver(8080, 8443));
        MockHttpServletResponse response = new MockHttpServletResponse();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        ExceptionTranslationFilterTests.assertEquals((String)"/mycontext/login.jsp", (String)response.getRedirectedUrl());
        ExceptionTranslationFilterTests.assertEquals((String)"http://www.example.com:8080/mycontext/secure/page.html", (String)AbstractProcessingFilter.obtainFullRequestUrl((HttpServletRequest)request));
    }

    public void testStartupDetectsMissingAuthenticationEntryPoint() throws Exception {
        ExceptionTranslationFilter filter = new ExceptionTranslationFilter();
        try {
            filter.afterPropertiesSet();
            ExceptionTranslationFilterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            ExceptionTranslationFilterTests.assertEquals((String)"authenticationEntryPoint must be specified", (String)expected.getMessage());
        }
    }

    public void testStartupDetectsMissingPortResolver() throws Exception {
        ExceptionTranslationFilter filter = new ExceptionTranslationFilter();
        filter.setAuthenticationEntryPoint((AuthenticationEntryPoint)new MockAuthenticationEntryPoint("/login.jsp"));
        filter.setPortResolver(null);
        try {
            filter.afterPropertiesSet();
            ExceptionTranslationFilterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            ExceptionTranslationFilterTests.assertEquals((String)"portResolver must be specified", (String)expected.getMessage());
        }
    }

    public void testSuccessfulAccessGrant() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServletPath("/secure/page.html");
        MockFilterChain chain = new MockFilterChain(false, false, false, false);
        ExceptionTranslationFilter filter = new ExceptionTranslationFilter();
        filter.setAuthenticationEntryPoint((AuthenticationEntryPoint)new MockAuthenticationEntryPoint("/login.jsp"));
        MockHttpServletResponse response = new MockHttpServletResponse();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
    }

    public void testSuccessfulStartupAndShutdownDown() throws Exception {
        ExceptionTranslationFilter filter = new ExceptionTranslationFilter();
        filter.init(null);
        filter.destroy();
        ExceptionTranslationFilterTests.assertTrue((boolean)true);
    }

    public void testThrowIOException() throws Exception {
        ExceptionTranslationFilter filter = new ExceptionTranslationFilter();
        filter.setAuthenticationEntryPoint((AuthenticationEntryPoint)new MockAuthenticationEntryPoint(""));
        try {
            filter.doFilter((ServletRequest)new MockHttpServletRequest(), (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain(false, false, false, true));
            ExceptionTranslationFilterTests.fail((String)"Should have thrown IOException");
        }
        catch (IOException e) {
            ExceptionTranslationFilterTests.assertNull((String)"The IOException thrown should not have been wrapped", (Object)e.getCause());
        }
    }

    public void testThrowServletException() throws Exception {
        ExceptionTranslationFilter filter = new ExceptionTranslationFilter();
        filter.setAuthenticationEntryPoint((AuthenticationEntryPoint)new MockAuthenticationEntryPoint(""));
        try {
            filter.doFilter((ServletRequest)new MockHttpServletRequest(), (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain(false, false, true, false));
            ExceptionTranslationFilterTests.fail((String)"Should have thrown ServletException");
        }
        catch (ServletException e) {
            ExceptionTranslationFilterTests.assertNull((String)"The ServletException thrown should not have been wrapped", (Object)e.getCause());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockFilterChain
    implements FilterChain {
        private boolean throwAccessDenied;
        private boolean throwAuthenticationFailure;
        private boolean throwIOException;
        private boolean throwServletException;

        public MockFilterChain(boolean throwAccessDenied, boolean throwAuthenticationFailure, boolean throwServletException, boolean throwIOException) {
            this.throwAccessDenied = throwAccessDenied;
            this.throwAuthenticationFailure = throwAuthenticationFailure;
            this.throwServletException = throwServletException;
            this.throwIOException = throwIOException;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this.throwAccessDenied) {
                throw new AccessDeniedException("As requested");
            }
            if (this.throwAuthenticationFailure) {
                throw new BadCredentialsException("As requested");
            }
            if (this.throwServletException) {
                throw new ServletException("As requested");
            }
            if (this.throwIOException) {
                throw new IOException("As requested");
            }
        }
    }
}

