/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ui.digestauth;

import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.DisabledException;
import org.acegisecurity.ui.digestauth.DigestProcessingFilterEntryPoint;
import org.acegisecurity.ui.digestauth.NonceExpiredException;
import org.acegisecurity.util.StringSplitUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.util.StringUtils;

public class DigestProcessingFilterEntryPointTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$ui$digestauth$DigestProcessingFilterEntryPointTests;

    public DigestProcessingFilterEntryPointTests() {
    }

    public DigestProcessingFilterEntryPointTests(String arg0) {
        super(arg0);
    }

    private void checkNonceValid(String nonce) {
        DigestProcessingFilterEntryPointTests.assertTrue((boolean)Base64.isArrayByteBase64((byte[])nonce.getBytes()));
        String decodedNonce = new String(Base64.decodeBase64((byte[])nonce.getBytes()));
        String[] nonceTokens = StringUtils.delimitedListToStringArray((String)decodedNonce, (String)":");
        DigestProcessingFilterEntryPointTests.assertEquals((int)2, (int)nonceTokens.length);
        String expectedNonceSignature = DigestUtils.md5Hex((String)(nonceTokens[0] + ":" + "key"));
        DigestProcessingFilterEntryPointTests.assertEquals((String)expectedNonceSignature, (String)nonceTokens[1]);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$ui$digestauth$DigestProcessingFilterEntryPointTests == null ? (class$org$acegisecurity$ui$digestauth$DigestProcessingFilterEntryPointTests = DigestProcessingFilterEntryPointTests.class$("org.acegisecurity.ui.digestauth.DigestProcessingFilterEntryPointTests")) : class$org$acegisecurity$ui$digestauth$DigestProcessingFilterEntryPointTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testDetectsMissingKey() throws Exception {
        DigestProcessingFilterEntryPoint ep = new DigestProcessingFilterEntryPoint();
        ep.setRealmName("realm");
        try {
            ep.afterPropertiesSet();
            DigestProcessingFilterEntryPointTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            DigestProcessingFilterEntryPointTests.assertEquals((String)"key must be specified", (String)expected.getMessage());
        }
    }

    public void testDetectsMissingRealmName() throws Exception {
        DigestProcessingFilterEntryPoint ep = new DigestProcessingFilterEntryPoint();
        ep.setKey("dcdc");
        ep.setNonceValiditySeconds(12);
        try {
            ep.afterPropertiesSet();
            DigestProcessingFilterEntryPointTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            DigestProcessingFilterEntryPointTests.assertEquals((String)"realmName must be specified", (String)expected.getMessage());
        }
    }

    public void testGettersSetters() {
        DigestProcessingFilterEntryPoint ep = new DigestProcessingFilterEntryPoint();
        DigestProcessingFilterEntryPointTests.assertEquals((int)300, (int)ep.getNonceValiditySeconds());
        ep.setRealmName("realm");
        DigestProcessingFilterEntryPointTests.assertEquals((String)"realm", (String)ep.getRealmName());
        ep.setKey("dcdc");
        DigestProcessingFilterEntryPointTests.assertEquals((String)"dcdc", (String)ep.getKey());
        ep.setNonceValiditySeconds(12);
        DigestProcessingFilterEntryPointTests.assertEquals((int)12, (int)ep.getNonceValiditySeconds());
    }

    public void testNormalOperation() throws Exception {
        DigestProcessingFilterEntryPoint ep = new DigestProcessingFilterEntryPoint();
        ep.setRealmName("hello");
        ep.setKey("key");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/some_path");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ep.afterPropertiesSet();
        ep.commence((ServletRequest)request, (ServletResponse)response, (AuthenticationException)((Object)new DisabledException("foobar")));
        DigestProcessingFilterEntryPointTests.assertEquals((int)401, (int)response.getStatus());
        DigestProcessingFilterEntryPointTests.assertEquals((boolean)true, (boolean)response.getHeader("WWW-Authenticate").toString().startsWith("Digest "));
        String header = response.getHeader("WWW-Authenticate").toString().substring(7);
        String[] headerEntries = StringUtils.commaDelimitedListToStringArray((String)header);
        Map headerMap = StringSplitUtils.splitEachArrayElementAndCreateMap((String[])headerEntries, (String)"=", (String)"\"");
        DigestProcessingFilterEntryPointTests.assertEquals((Object)"hello", headerMap.get("realm"));
        DigestProcessingFilterEntryPointTests.assertEquals((Object)"auth", headerMap.get("qop"));
        DigestProcessingFilterEntryPointTests.assertNull(headerMap.get("stale"));
        this.checkNonceValid((String)headerMap.get("nonce"));
    }

    public void testOperationIfDueToStaleNonce() throws Exception {
        DigestProcessingFilterEntryPoint ep = new DigestProcessingFilterEntryPoint();
        ep.setRealmName("hello");
        ep.setKey("key");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/some_path");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ep.afterPropertiesSet();
        ep.commence((ServletRequest)request, (ServletResponse)response, (AuthenticationException)new NonceExpiredException("expired nonce"));
        DigestProcessingFilterEntryPointTests.assertEquals((int)401, (int)response.getStatus());
        DigestProcessingFilterEntryPointTests.assertTrue((boolean)response.getHeader("WWW-Authenticate").toString().startsWith("Digest "));
        String header = response.getHeader("WWW-Authenticate").toString().substring(7);
        String[] headerEntries = StringUtils.commaDelimitedListToStringArray((String)header);
        Map headerMap = StringSplitUtils.splitEachArrayElementAndCreateMap((String[])headerEntries, (String)"=", (String)"\"");
        DigestProcessingFilterEntryPointTests.assertEquals((Object)"hello", headerMap.get("realm"));
        DigestProcessingFilterEntryPointTests.assertEquals((Object)"auth", headerMap.get("qop"));
        DigestProcessingFilterEntryPointTests.assertEquals((Object)"true", headerMap.get("stale"));
        this.checkNonceValid((String)headerMap.get("nonce"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

