/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ui.digestauth;

import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.acegisecurity.MockFilterChain;
import org.acegisecurity.MockFilterConfig;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.dao.UserCache;
import org.acegisecurity.providers.dao.cache.NullUserCache;
import org.acegisecurity.ui.digestauth.DigestProcessingFilter;
import org.acegisecurity.ui.digestauth.DigestProcessingFilterEntryPoint;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.memory.InMemoryDaoImpl;
import org.acegisecurity.userdetails.memory.UserMap;
import org.acegisecurity.userdetails.memory.UserMapEditor;
import org.acegisecurity.util.StringSplitUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.jmock.Mock;
import org.jmock.MockObjectTestCase;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.util.StringUtils;

public class DigestProcessingFilterTests
extends MockObjectTestCase {
    private static final String NC = "00000002";
    private static final String CNONCE = "c822c727a648aba7";
    private static final String REALM = "The Actual, Correct Realm Name";
    private static final String KEY = "acegi";
    private static final String QOP = "auth";
    private static final String USERNAME = "marissa,ok";
    private static final String PASSWORD = "koala";
    private static final String REQUEST_URI = "/some_file.html";
    private static final String NONCE = DigestProcessingFilterTests.generateNonce(60);
    private DigestProcessingFilter filter;
    private MockHttpServletRequest request;
    static /* synthetic */ Class class$javax$servlet$FilterChain;

    public DigestProcessingFilterTests() {
    }

    public DigestProcessingFilterTests(String arg0) {
        super(arg0);
    }

    private String createAuthorizationHeader(String username, String realm, String nonce, String uri, String responseDigest, String qop, String nc, String cnonce) {
        return "Digest username=\"" + username + "\", realm=\"" + realm + "\", nonce=\"" + nonce + "\", uri=\"" + uri + "\", response=\"" + responseDigest + "\", qop=" + qop + ", nc=" + nc + ", cnonce=\"" + cnonce + "\"";
    }

    private MockHttpServletResponse executeFilterInContainerSimulator(Filter filter, ServletRequest request, boolean expectChainToProceed) throws ServletException, IOException {
        filter.init((FilterConfig)new MockFilterConfig());
        MockHttpServletResponse response = new MockHttpServletResponse();
        Mock mockChain = this.mock(class$javax$servlet$FilterChain == null ? (class$javax$servlet$FilterChain = DigestProcessingFilterTests.class$("javax.servlet.FilterChain")) : class$javax$servlet$FilterChain);
        FilterChain chain = (FilterChain)mockChain.proxy();
        mockChain.expects(expectChainToProceed ? this.once() : this.never()).method("doFilter");
        filter.doFilter(request, (ServletResponse)response, chain);
        filter.destroy();
        return response;
    }

    private static String generateNonce(int validitySeconds) {
        long expiryTime = System.currentTimeMillis() + (long)(validitySeconds * 1000);
        String signatureValue = new String(DigestUtils.md5Hex((String)(expiryTime + ":" + KEY)));
        String nonceValue = expiryTime + ":" + signatureValue;
        return new String(Base64.encodeBase64((byte[])nonceValue.getBytes()));
    }

    protected void setUp() throws Exception {
        super.setUp();
        SecurityContextHolder.clearContext();
        InMemoryDaoImpl dao = new InMemoryDaoImpl();
        UserMapEditor editor = new UserMapEditor();
        editor.setAsText("marissa,ok=koala,ROLE_ONE,ROLE_TWO,enabled\r\n");
        dao.setUserMap((UserMap)editor.getValue());
        DigestProcessingFilterEntryPoint ep = new DigestProcessingFilterEntryPoint();
        ep.setRealmName(REALM);
        ep.setKey(KEY);
        this.filter = new DigestProcessingFilter();
        this.filter.setUserDetailsService((UserDetailsService)dao);
        this.filter.setAuthenticationEntryPoint(ep);
        this.request = new MockHttpServletRequest("GET", REQUEST_URI);
        this.request.setServletPath(REQUEST_URI);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        SecurityContextHolder.clearContext();
    }

    public void testDoFilterWithNonHttpServletRequestDetected() throws Exception {
        DigestProcessingFilter filter = new DigestProcessingFilter();
        try {
            filter.doFilter(null, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain());
            DigestProcessingFilterTests.fail((String)"Should have thrown ServletException");
        }
        catch (ServletException expected) {
            DigestProcessingFilterTests.assertEquals((String)"Can only process HttpServletRequest", (String)expected.getMessage());
        }
    }

    public void testDoFilterWithNonHttpServletResponseDetected() throws Exception {
        DigestProcessingFilter filter = new DigestProcessingFilter();
        try {
            filter.doFilter((ServletRequest)new MockHttpServletRequest(null, null), null, (FilterChain)new MockFilterChain());
            DigestProcessingFilterTests.fail((String)"Should have thrown ServletException");
        }
        catch (ServletException expected) {
            DigestProcessingFilterTests.assertEquals((String)"Can only process HttpServletResponse", (String)expected.getMessage());
        }
    }

    public void testExpiredNonceReturnsForbiddenWithStaleHeader() throws Exception {
        String nonce = DigestProcessingFilterTests.generateNonce(0);
        String responseDigest = DigestProcessingFilter.generateDigest((boolean)false, (String)USERNAME, (String)REALM, (String)PASSWORD, (String)"GET", (String)REQUEST_URI, (String)QOP, (String)nonce, (String)NC, (String)CNONCE);
        this.request.addHeader("Authorization", (Object)this.createAuthorizationHeader(USERNAME, REALM, nonce, REQUEST_URI, responseDigest, QOP, NC, CNONCE));
        Thread.sleep(1000L);
        MockHttpServletResponse response = this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, false);
        DigestProcessingFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        DigestProcessingFilterTests.assertEquals((int)401, (int)response.getStatus());
        String header = response.getHeader("WWW-Authenticate").toString().substring(7);
        String[] headerEntries = StringUtils.commaDelimitedListToStringArray((String)header);
        Map headerMap = StringSplitUtils.splitEachArrayElementAndCreateMap((String[])headerEntries, (String)"=", (String)"\"");
        DigestProcessingFilterTests.assertEquals((Object)"true", headerMap.get("stale"));
    }

    public void testFilterIgnoresRequestsContainingNoAuthorizationHeader() throws Exception {
        this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, true);
        DigestProcessingFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    public void testGettersSetters() {
        DigestProcessingFilter filter = new DigestProcessingFilter();
        filter.setUserDetailsService((UserDetailsService)new InMemoryDaoImpl());
        DigestProcessingFilterTests.assertTrue((filter.getUserDetailsService() != null ? 1 : 0) != 0);
        filter.setAuthenticationEntryPoint(new DigestProcessingFilterEntryPoint());
        DigestProcessingFilterTests.assertTrue((filter.getAuthenticationEntryPoint() != null ? 1 : 0) != 0);
        filter.setUserCache(null);
        DigestProcessingFilterTests.assertNull((Object)filter.getUserCache());
        filter.setUserCache((UserCache)new NullUserCache());
        DigestProcessingFilterTests.assertNotNull((Object)filter.getUserCache());
    }

    public void testInvalidDigestAuthorizationTokenGeneratesError() throws Exception {
        String token = "NOT_A_VALID_TOKEN_AS_MISSING_COLON";
        this.request.addHeader("Authorization", (Object)("Digest " + new String(Base64.encodeBase64((byte[])token.getBytes()))));
        MockHttpServletResponse response = this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, false);
        DigestProcessingFilterTests.assertEquals((int)401, (int)response.getStatus());
        DigestProcessingFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    public void testMalformedHeaderReturnsForbidden() throws Exception {
        this.request.addHeader("Authorization", (Object)"Digest scsdcsdc");
        MockHttpServletResponse response = this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, false);
        DigestProcessingFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        DigestProcessingFilterTests.assertEquals((int)401, (int)response.getStatus());
    }

    public void testNonBase64EncodedNonceReturnsForbidden() throws Exception {
        String nonce = "NOT_BASE_64_ENCODED";
        String responseDigest = DigestProcessingFilter.generateDigest((boolean)false, (String)USERNAME, (String)REALM, (String)PASSWORD, (String)"GET", (String)REQUEST_URI, (String)QOP, (String)nonce, (String)NC, (String)CNONCE);
        this.request.addHeader("Authorization", (Object)this.createAuthorizationHeader(USERNAME, REALM, nonce, REQUEST_URI, responseDigest, QOP, NC, CNONCE));
        MockHttpServletResponse response = this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, false);
        DigestProcessingFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        DigestProcessingFilterTests.assertEquals((int)401, (int)response.getStatus());
    }

    public void testNonceWithIncorrectSignatureForNumericFieldReturnsForbidden() throws Exception {
        String nonce = new String(Base64.encodeBase64((byte[])"123456:incorrectStringPassword".getBytes()));
        String responseDigest = DigestProcessingFilter.generateDigest((boolean)false, (String)USERNAME, (String)REALM, (String)PASSWORD, (String)"GET", (String)REQUEST_URI, (String)QOP, (String)nonce, (String)NC, (String)CNONCE);
        this.request.addHeader("Authorization", (Object)this.createAuthorizationHeader(USERNAME, REALM, nonce, REQUEST_URI, responseDigest, QOP, NC, CNONCE));
        MockHttpServletResponse response = this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, false);
        DigestProcessingFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        DigestProcessingFilterTests.assertEquals((int)401, (int)response.getStatus());
    }

    public void testNonceWithNonNumericFirstElementReturnsForbidden() throws Exception {
        String nonce = new String(Base64.encodeBase64((byte[])"hello:ignoredSecondElement".getBytes()));
        String responseDigest = DigestProcessingFilter.generateDigest((boolean)false, (String)USERNAME, (String)REALM, (String)PASSWORD, (String)"GET", (String)REQUEST_URI, (String)QOP, (String)nonce, (String)NC, (String)CNONCE);
        this.request.addHeader("Authorization", (Object)this.createAuthorizationHeader(USERNAME, REALM, nonce, REQUEST_URI, responseDigest, QOP, NC, CNONCE));
        MockHttpServletResponse response = this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, false);
        DigestProcessingFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        DigestProcessingFilterTests.assertEquals((int)401, (int)response.getStatus());
    }

    public void testNonceWithoutTwoColonSeparatedElementsReturnsForbidden() throws Exception {
        String nonce = new String(Base64.encodeBase64((byte[])"a base 64 string without a colon".getBytes()));
        String responseDigest = DigestProcessingFilter.generateDigest((boolean)false, (String)USERNAME, (String)REALM, (String)PASSWORD, (String)"GET", (String)REQUEST_URI, (String)QOP, (String)nonce, (String)NC, (String)CNONCE);
        this.request.addHeader("Authorization", (Object)this.createAuthorizationHeader(USERNAME, REALM, nonce, REQUEST_URI, responseDigest, QOP, NC, CNONCE));
        MockHttpServletResponse response = this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, false);
        DigestProcessingFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        DigestProcessingFilterTests.assertEquals((int)401, (int)response.getStatus());
    }

    public void testNormalOperationWhenPasswordIsAlreadyEncoded() throws Exception {
        String encodedPassword = DigestProcessingFilter.encodePasswordInA1Format((String)USERNAME, (String)REALM, (String)PASSWORD);
        String responseDigest = DigestProcessingFilter.generateDigest((boolean)true, (String)USERNAME, (String)REALM, (String)encodedPassword, (String)"GET", (String)REQUEST_URI, (String)QOP, (String)NONCE, (String)NC, (String)CNONCE);
        this.request.addHeader("Authorization", (Object)this.createAuthorizationHeader(USERNAME, REALM, NONCE, REQUEST_URI, responseDigest, QOP, NC, CNONCE));
        this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, true);
        DigestProcessingFilterTests.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        DigestProcessingFilterTests.assertEquals((String)USERNAME, (String)((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername());
    }

    public void testNormalOperationWhenPasswordNotAlreadyEncoded() throws Exception {
        String responseDigest = DigestProcessingFilter.generateDigest((boolean)false, (String)USERNAME, (String)REALM, (String)PASSWORD, (String)"GET", (String)REQUEST_URI, (String)QOP, (String)NONCE, (String)NC, (String)CNONCE);
        this.request.addHeader("Authorization", (Object)this.createAuthorizationHeader(USERNAME, REALM, NONCE, REQUEST_URI, responseDigest, QOP, NC, CNONCE));
        this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, true);
        DigestProcessingFilterTests.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        DigestProcessingFilterTests.assertEquals((String)USERNAME, (String)((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername());
    }

    public void testOtherAuthorizationSchemeIsIgnored() throws Exception {
        this.request.addHeader("Authorization", (Object)"SOME_OTHER_AUTHENTICATION_SCHEME");
        this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, true);
        DigestProcessingFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    public void testStartupDetectsMissingAuthenticationEntryPoint() throws Exception {
        try {
            DigestProcessingFilter filter = new DigestProcessingFilter();
            filter.setUserDetailsService((UserDetailsService)new InMemoryDaoImpl());
            filter.afterPropertiesSet();
            DigestProcessingFilterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            DigestProcessingFilterTests.assertEquals((String)"A DigestProcessingFilterEntryPoint is required", (String)expected.getMessage());
        }
    }

    public void testStartupDetectsMissingUserDetailsService() throws Exception {
        try {
            DigestProcessingFilter filter = new DigestProcessingFilter();
            filter.setAuthenticationEntryPoint(new DigestProcessingFilterEntryPoint());
            filter.afterPropertiesSet();
            DigestProcessingFilterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            DigestProcessingFilterTests.assertEquals((String)"A UserDetailsService is required", (String)expected.getMessage());
        }
    }

    public void testSuccessLoginThenFailureLoginResultsInSessionLosingToken() throws Exception {
        String responseDigest = DigestProcessingFilter.generateDigest((boolean)false, (String)USERNAME, (String)REALM, (String)PASSWORD, (String)"GET", (String)REQUEST_URI, (String)QOP, (String)NONCE, (String)NC, (String)CNONCE);
        this.request.addHeader("Authorization", (Object)this.createAuthorizationHeader(USERNAME, REALM, NONCE, REQUEST_URI, responseDigest, QOP, NC, CNONCE));
        this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, true);
        DigestProcessingFilterTests.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        responseDigest = DigestProcessingFilter.generateDigest((boolean)false, (String)USERNAME, (String)REALM, (String)"WRONG_PASSWORD", (String)"GET", (String)REQUEST_URI, (String)QOP, (String)NONCE, (String)NC, (String)CNONCE);
        this.request = new MockHttpServletRequest();
        this.request.addHeader("Authorization", (Object)this.createAuthorizationHeader(USERNAME, REALM, NONCE, REQUEST_URI, responseDigest, QOP, NC, CNONCE));
        MockHttpServletResponse response = this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, false);
        DigestProcessingFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        DigestProcessingFilterTests.assertEquals((int)401, (int)response.getStatus());
    }

    public void testWrongCnonceBasedOnDigestReturnsForbidden() throws Exception {
        String cnonce = "NOT_SAME_AS_USED_FOR_DIGEST_COMPUTATION";
        String responseDigest = DigestProcessingFilter.generateDigest((boolean)false, (String)USERNAME, (String)REALM, (String)PASSWORD, (String)"GET", (String)REQUEST_URI, (String)QOP, (String)NONCE, (String)NC, (String)"DIFFERENT_CNONCE");
        this.request.addHeader("Authorization", (Object)this.createAuthorizationHeader(USERNAME, REALM, NONCE, REQUEST_URI, responseDigest, QOP, NC, cnonce));
        MockHttpServletResponse response = this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, false);
        DigestProcessingFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        DigestProcessingFilterTests.assertEquals((int)401, (int)response.getStatus());
    }

    public void testWrongDigestReturnsForbidden() throws Exception {
        String password = "WRONG_PASSWORD";
        String responseDigest = DigestProcessingFilter.generateDigest((boolean)false, (String)USERNAME, (String)REALM, (String)password, (String)"GET", (String)REQUEST_URI, (String)QOP, (String)NONCE, (String)NC, (String)CNONCE);
        this.request.addHeader("Authorization", (Object)this.createAuthorizationHeader(USERNAME, REALM, NONCE, REQUEST_URI, responseDigest, QOP, NC, CNONCE));
        MockHttpServletResponse response = this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, false);
        DigestProcessingFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        DigestProcessingFilterTests.assertEquals((int)401, (int)response.getStatus());
    }

    public void testWrongRealmReturnsForbidden() throws Exception {
        String realm = "WRONG_REALM";
        String responseDigest = DigestProcessingFilter.generateDigest((boolean)false, (String)USERNAME, (String)realm, (String)PASSWORD, (String)"GET", (String)REQUEST_URI, (String)QOP, (String)NONCE, (String)NC, (String)CNONCE);
        this.request.addHeader("Authorization", (Object)this.createAuthorizationHeader(USERNAME, realm, NONCE, REQUEST_URI, responseDigest, QOP, NC, CNONCE));
        MockHttpServletResponse response = this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, false);
        DigestProcessingFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        DigestProcessingFilterTests.assertEquals((int)401, (int)response.getStatus());
    }

    public void testWrongUsernameReturnsForbidden() throws Exception {
        String responseDigest = DigestProcessingFilter.generateDigest((boolean)false, (String)"NOT_A_KNOWN_USER", (String)REALM, (String)PASSWORD, (String)"GET", (String)REQUEST_URI, (String)QOP, (String)NONCE, (String)NC, (String)CNONCE);
        this.request.addHeader("Authorization", (Object)this.createAuthorizationHeader(USERNAME, REALM, NONCE, REQUEST_URI, responseDigest, QOP, NC, CNONCE));
        MockHttpServletResponse response = this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, false);
        DigestProcessingFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        DigestProcessingFilterTests.assertEquals((int)401, (int)response.getStatus());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

