/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.userdetails;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.userdetails.User;

public class UserTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$userdetails$UserTests;
    static /* synthetic */ Class class$org$acegisecurity$userdetails$User;

    public UserTests() {
    }

    public UserTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$userdetails$UserTests == null ? (class$org$acegisecurity$userdetails$UserTests = UserTests.class$("org.acegisecurity.userdetails.UserTests")) : class$org$acegisecurity$userdetails$UserTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testEquals() {
        User user1 = new User("marissa", "koala", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        UserTests.assertFalse((boolean)user1.equals(null));
        UserTests.assertFalse((boolean)user1.equals((Object)"A STRING"));
        UserTests.assertTrue((boolean)user1.equals((Object)user1));
        UserTests.assertTrue((boolean)user1.equals((Object)new User("marissa", "koala", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")})));
        UserTests.assertFalse((boolean)user1.equals((Object)new User("DIFFERENT_USERNAME", "koala", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")})));
        UserTests.assertFalse((boolean)user1.equals((Object)new User("marissa", "DIFFERENT_PASSWORD", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")})));
        UserTests.assertFalse((boolean)user1.equals((Object)new User("marissa", "koala", false, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")})));
        UserTests.assertFalse((boolean)user1.equals((Object)new User("marissa", "koala", true, false, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")})));
        UserTests.assertFalse((boolean)user1.equals((Object)new User("marissa", "koala", true, true, false, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")})));
        UserTests.assertFalse((boolean)user1.equals((Object)new User("marissa", "koala", true, true, true, false, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")})));
        UserTests.assertFalse((boolean)user1.equals((Object)new User("marissa", "koala", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE")})));
    }

    public void testNoArgConstructorDoesntExist() {
        Class clazz = class$org$acegisecurity$userdetails$User == null ? (class$org$acegisecurity$userdetails$User = UserTests.class$("org.acegisecurity.userdetails.User")) : class$org$acegisecurity$userdetails$User;
        try {
            clazz.getDeclaredConstructor(null);
            UserTests.fail((String)"Should have thrown NoSuchMethodException");
        }
        catch (NoSuchMethodException expected) {
            UserTests.assertTrue((boolean)true);
        }
    }

    public void testNullValuesRejected() throws Exception {
        User user;
        try {
            user = new User(null, "koala", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            UserTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            UserTests.assertTrue((boolean)true);
        }
        try {
            user = new User("marissa", null, true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            UserTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            UserTests.assertTrue((boolean)true);
        }
        try {
            user = new User("marissa", "koala", true, true, true, true, null);
            UserTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            UserTests.assertTrue((boolean)true);
        }
        try {
            user = new User("marissa", "koala", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), null});
            UserTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            UserTests.assertTrue((boolean)true);
        }
    }

    public void testNullWithinGrantedAuthorityElementIsRejected() throws Exception {
        try {
            User user = new User(null, "koala", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO"), null, new GrantedAuthorityImpl("ROLE_THREE")});
            UserTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            UserTests.assertTrue((boolean)true);
        }
    }

    public void testUserGettersSetter() throws Exception {
        User user = new User("marissa", "koala", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        UserTests.assertEquals((String)"marissa", (String)user.getUsername());
        UserTests.assertEquals((String)"koala", (String)user.getPassword());
        UserTests.assertTrue((boolean)user.isEnabled());
        UserTests.assertEquals((Object)new GrantedAuthorityImpl("ROLE_ONE"), (Object)user.getAuthorities()[0]);
        UserTests.assertEquals((Object)new GrantedAuthorityImpl("ROLE_TWO"), (Object)user.getAuthorities()[1]);
        UserTests.assertTrue((user.toString().indexOf("marissa") != -1 ? 1 : 0) != 0);
    }

    public void testUserIsEnabled() throws Exception {
        User user = new User("marissa", "koala", false, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        UserTests.assertTrue((!user.isEnabled() ? 1 : 0) != 0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

