/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.util;

import junit.framework.TestCase;
import org.acegisecurity.util.EncryptionUtils;

public class EncryptionUtilsTests
extends TestCase {
    private static final String STRING_TO_ENCRYPT = "Alan K Stewart";
    private static final String ENCRYPTION_KEY = "123456789012345678901234567890";

    public void testEncryptsUsingDESEde() throws EncryptionUtils.EncryptionException {
        String encryptedString = EncryptionUtils.encrypt((String)ENCRYPTION_KEY, (String)STRING_TO_ENCRYPT);
        EncryptionUtilsTests.assertEquals((String)"3YIE8sIbaEoqGZZrHamFGQ==", (String)encryptedString);
    }

    public void testEncryptByteArrayUsingDESEde() {
        byte[] encryptedArray = EncryptionUtils.encrypt((String)ENCRYPTION_KEY, (byte[])EncryptionUtils.stringToByteArray((String)STRING_TO_ENCRYPT));
        EncryptionUtilsTests.assertEquals((String)"3YIE8sIbaEoqGZZrHamFGQ==", (String)EncryptionUtils.byteArrayToString((byte[])encryptedArray));
    }

    public void testEncryptionKeyCanContainLetters() throws EncryptionUtils.EncryptionException {
        String encryptedString = EncryptionUtils.encrypt((String)"ASDF asdf 1234 8983 jklasdf J2Jaf8", (String)STRING_TO_ENCRYPT);
        EncryptionUtilsTests.assertEquals((String)"v4+DQoClx6qm5tJwBcRrkw==", (String)encryptedString);
    }

    public void testDecryptsUsingDESEde() throws EncryptionUtils.EncryptionException {
        String encryptedString = "3YIE8sIbaEoqGZZrHamFGQ==";
        String decryptedString = EncryptionUtils.decrypt((String)ENCRYPTION_KEY, (String)"3YIE8sIbaEoqGZZrHamFGQ==");
        EncryptionUtilsTests.assertEquals((String)STRING_TO_ENCRYPT, (String)decryptedString);
    }

    public void testDecryptByteArrayUsingDESEde() {
        byte[] encrypted = EncryptionUtils.stringToByteArray((String)"3YIE8sIbaEoqGZZrHamFGQ==");
        byte[] decrypted = EncryptionUtils.decrypt((String)ENCRYPTION_KEY, (byte[])encrypted);
        EncryptionUtilsTests.assertEquals((String)STRING_TO_ENCRYPT, (String)EncryptionUtils.byteArrayToString((byte[])decrypted));
    }

    public void testFailEncryptWithNullEncryptionKey() {
        try {
            EncryptionUtils.encrypt(null, (String)STRING_TO_ENCRYPT);
            EncryptionUtilsTests.fail();
        }
        catch (IllegalArgumentException e) {
            EncryptionUtilsTests.assertTrue((boolean)true);
        }
    }

    public void testFailEncryptWithEmptyEncryptionKey() {
        try {
            EncryptionUtils.encrypt((String)"", (String)STRING_TO_ENCRYPT);
            EncryptionUtilsTests.fail();
        }
        catch (IllegalArgumentException e) {
            EncryptionUtilsTests.assertTrue((boolean)true);
        }
    }

    public void teastFailEncryptWithShortEncryptionKey() {
        try {
            EncryptionUtils.encrypt((String)"01234567890123456789012", (String)STRING_TO_ENCRYPT);
            EncryptionUtilsTests.fail();
        }
        catch (IllegalArgumentException e) {
            EncryptionUtilsTests.assertTrue((boolean)true);
        }
    }

    public void testFailDecryptWithEmptyString() {
        try {
            EncryptionUtils.decrypt((String)ENCRYPTION_KEY, (String)"");
            EncryptionUtilsTests.fail();
        }
        catch (IllegalArgumentException e) {
            EncryptionUtilsTests.assertTrue((boolean)true);
        }
    }

    public void testFailEncryptWithEmptyString() {
        try {
            EncryptionUtils.encrypt((String)ENCRYPTION_KEY, (String)"");
            EncryptionUtilsTests.fail();
        }
        catch (IllegalArgumentException e) {
            EncryptionUtilsTests.assertTrue((boolean)true);
        }
    }

    public void testFailEncryptWithNullString() {
        try {
            EncryptionUtils.encrypt((String)ENCRYPTION_KEY, (String)null);
            EncryptionUtilsTests.fail();
        }
        catch (IllegalArgumentException e) {
            EncryptionUtilsTests.assertTrue((boolean)true);
        }
    }

    public void testEncryptAndDecrypt() throws EncryptionUtils.EncryptionException {
        String stringToEncrypt = "Alan Stewart";
        String encryptedString = EncryptionUtils.encrypt((String)ENCRYPTION_KEY, (String)"Alan Stewart");
        String decryptedString = EncryptionUtils.decrypt((String)ENCRYPTION_KEY, (String)encryptedString);
        EncryptionUtilsTests.assertEquals((String)"Alan Stewart", (String)decryptedString);
    }
}

