/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.util;

import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.MockApplicationContext;
import org.acegisecurity.MockFilterConfig;
import org.acegisecurity.intercept.web.FilterInvocationDefinitionSource;
import org.acegisecurity.intercept.web.MockFilterInvocationDefinitionSource;
import org.acegisecurity.intercept.web.PathBasedFilterInvocationDefinitionMap;
import org.acegisecurity.util.FilterChainProxy;
import org.acegisecurity.util.MockFilter;
import org.acegisecurity.util.MockFilterChain;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class FilterChainProxyTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$util$FilterChainProxyTests;
    static /* synthetic */ Class class$org$acegisecurity$util$FilterChainProxy;
    static /* synthetic */ Class class$org$acegisecurity$util$MockFilter;

    public FilterChainProxyTests() {
    }

    public FilterChainProxyTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$util$FilterChainProxyTests == null ? (class$org$acegisecurity$util$FilterChainProxyTests = FilterChainProxyTests.class$("org.acegisecurity.util.FilterChainProxyTests")) : class$org$acegisecurity$util$FilterChainProxyTests));
    }

    public void testDetectsFilterInvocationDefinitionSourceThatDoesNotReturnAllConfigAttributes() throws Exception {
        FilterChainProxy filterChainProxy = new FilterChainProxy();
        filterChainProxy.setApplicationContext((ApplicationContext)MockApplicationContext.getContext());
        filterChainProxy.setFilterInvocationDefinitionSource((FilterInvocationDefinitionSource)new MockFilterInvocationDefinitionSource(false, false));
        try {
            filterChainProxy.afterPropertiesSet();
            FilterChainProxyTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            FilterChainProxyTests.assertEquals((String)"FilterChainProxy requires the FilterInvocationDefinitionSource to return a non-null response to getConfigAttributeDefinitions()", (String)expected.getMessage());
        }
    }

    public void testDetectsIfConfigAttributeDoesNotReturnValueForGetAttributeMethod() throws Exception {
        FilterChainProxy filterChainProxy = new FilterChainProxy();
        filterChainProxy.setApplicationContext((ApplicationContext)MockApplicationContext.getContext());
        ConfigAttributeDefinition cad = new ConfigAttributeDefinition();
        cad.addConfigAttribute((ConfigAttribute)new MockConfigAttribute());
        PathBasedFilterInvocationDefinitionMap fids = new PathBasedFilterInvocationDefinitionMap();
        fids.addSecureUrl("/**", cad);
        filterChainProxy.setFilterInvocationDefinitionSource((FilterInvocationDefinitionSource)fids);
        filterChainProxy.afterPropertiesSet();
        try {
            filterChainProxy.init((FilterConfig)new MockFilterConfig());
            FilterChainProxyTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            FilterChainProxyTests.assertTrue((boolean)expected.getMessage().endsWith("returned null to the getAttribute() method, which is invalid when used with FilterChainProxy"));
        }
    }

    public void testDetectsMissingFilterInvocationDefinitionSource() throws Exception {
        FilterChainProxy filterChainProxy = new FilterChainProxy();
        filterChainProxy.setApplicationContext((ApplicationContext)MockApplicationContext.getContext());
        try {
            filterChainProxy.afterPropertiesSet();
            FilterChainProxyTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            FilterChainProxyTests.assertEquals((String)"filterInvocationDefinitionSource must be specified", (String)expected.getMessage());
        }
    }

    public void testDoNotFilter() throws Exception {
        ClassPathXmlApplicationContext appCtx = new ClassPathXmlApplicationContext("org/acegisecurity/util/filtertest-valid.xml");
        FilterChainProxy filterChainProxy = (FilterChainProxy)appCtx.getBean("filterChain", class$org$acegisecurity$util$FilterChainProxy == null ? (class$org$acegisecurity$util$FilterChainProxy = FilterChainProxyTests.class$("org.acegisecurity.util.FilterChainProxy")) : class$org$acegisecurity$util$FilterChainProxy);
        MockFilter filter = (MockFilter)appCtx.getBean("mockFilter", class$org$acegisecurity$util$MockFilter == null ? (class$org$acegisecurity$util$MockFilter = FilterChainProxyTests.class$("org.acegisecurity.util.MockFilter")) : class$org$acegisecurity$util$MockFilter);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServletPath("/do/not/filter/somefile.html");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain(true);
        filterChainProxy.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        FilterChainProxyTests.assertFalse((boolean)filter.isWasInitialized());
        FilterChainProxyTests.assertFalse((boolean)filter.isWasDoFiltered());
        FilterChainProxyTests.assertFalse((boolean)filter.isWasDestroyed());
    }

    public void testGettersSetters() {
        FilterChainProxy filterChainProxy = new FilterChainProxy();
        MockFilterInvocationDefinitionSource fids = new MockFilterInvocationDefinitionSource(false, false);
        filterChainProxy.setFilterInvocationDefinitionSource((FilterInvocationDefinitionSource)fids);
        FilterChainProxyTests.assertEquals((Object)((Object)fids), (Object)filterChainProxy.getFilterInvocationDefinitionSource());
    }

    public void testNormalOperation() throws Exception {
        ClassPathXmlApplicationContext appCtx = new ClassPathXmlApplicationContext("org/acegisecurity/util/filtertest-valid.xml");
        FilterChainProxy filterChainProxy = (FilterChainProxy)appCtx.getBean("filterChain", class$org$acegisecurity$util$FilterChainProxy == null ? (class$org$acegisecurity$util$FilterChainProxy = FilterChainProxyTests.class$("org.acegisecurity.util.FilterChainProxy")) : class$org$acegisecurity$util$FilterChainProxy);
        MockFilter filter = (MockFilter)appCtx.getBean("mockFilter", class$org$acegisecurity$util$MockFilter == null ? (class$org$acegisecurity$util$MockFilter = FilterChainProxyTests.class$("org.acegisecurity.util.MockFilter")) : class$org$acegisecurity$util$MockFilter);
        FilterChainProxyTests.assertFalse((boolean)filter.isWasInitialized());
        FilterChainProxyTests.assertFalse((boolean)filter.isWasDoFiltered());
        FilterChainProxyTests.assertFalse((boolean)filter.isWasDestroyed());
        filterChainProxy.init((FilterConfig)new MockFilterConfig());
        FilterChainProxyTests.assertTrue((boolean)filter.isWasInitialized());
        FilterChainProxyTests.assertFalse((boolean)filter.isWasDoFiltered());
        FilterChainProxyTests.assertFalse((boolean)filter.isWasDestroyed());
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServletPath("/foo/secure/super/somefile.html");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain(true);
        filterChainProxy.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        FilterChainProxyTests.assertTrue((boolean)filter.isWasInitialized());
        FilterChainProxyTests.assertTrue((boolean)filter.isWasDoFiltered());
        FilterChainProxyTests.assertFalse((boolean)filter.isWasDestroyed());
        request.setServletPath("/a/path/which/doesnt/match/any/filter.html");
        filterChainProxy.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        filterChainProxy.destroy();
        FilterChainProxyTests.assertTrue((boolean)filter.isWasInitialized());
        FilterChainProxyTests.assertTrue((boolean)filter.isWasDoFiltered());
        FilterChainProxyTests.assertTrue((boolean)filter.isWasDestroyed());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockConfigAttribute
    implements ConfigAttribute {
        private MockConfigAttribute() {
        }

        public String getAttribute() {
            return null;
        }
    }
}

