/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.util;

import java.util.Map;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.util.StringSplitUtils;
import org.springframework.util.StringUtils;

public class StringSplitUtilsTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$util$StringSplitUtilsTests;

    public StringSplitUtilsTests() {
    }

    public StringSplitUtilsTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$util$StringSplitUtilsTests == null ? (class$org$acegisecurity$util$StringSplitUtilsTests = StringSplitUtilsTests.class$("org.acegisecurity.util.StringSplitUtilsTests")) : class$org$acegisecurity$util$StringSplitUtilsTests));
    }

    public void testSplitEachArrayElementAndCreateMapNormalOperation() {
        String unsplit = "username=\"marissa\", invalidEntryThatHasNoEqualsSign, realm=\"Contacts Realm\", nonce=\"MTEwOTAyMzU1MTQ4NDo1YzY3OWViYWM5NDNmZWUwM2UwY2NmMDBiNDQzMTQ0OQ==\", uri=\"/acegi-security-sample-contacts-filter/secure/adminPermission.htm?contactId=4\", response=\"38644211cf9ac3da63ab639807e2baff\", qop=auth, nc=00000004, cnonce=\"2b8d329a8571b99a\"";
        String[] headerEntries = StringUtils.commaDelimitedListToStringArray((String)unsplit);
        Map headerMap = StringSplitUtils.splitEachArrayElementAndCreateMap((String[])headerEntries, (String)"=", (String)"\"");
        StringSplitUtilsTests.assertEquals((Object)"marissa", headerMap.get("username"));
        StringSplitUtilsTests.assertEquals((Object)"Contacts Realm", headerMap.get("realm"));
        StringSplitUtilsTests.assertEquals((Object)"MTEwOTAyMzU1MTQ4NDo1YzY3OWViYWM5NDNmZWUwM2UwY2NmMDBiNDQzMTQ0OQ==", headerMap.get("nonce"));
        StringSplitUtilsTests.assertEquals((Object)"/acegi-security-sample-contacts-filter/secure/adminPermission.htm?contactId=4", headerMap.get("uri"));
        StringSplitUtilsTests.assertEquals((Object)"38644211cf9ac3da63ab639807e2baff", headerMap.get("response"));
        StringSplitUtilsTests.assertEquals((Object)"auth", headerMap.get("qop"));
        StringSplitUtilsTests.assertEquals((Object)"00000004", headerMap.get("nc"));
        StringSplitUtilsTests.assertEquals((Object)"2b8d329a8571b99a", headerMap.get("cnonce"));
        StringSplitUtilsTests.assertEquals((int)8, (int)headerMap.size());
    }

    public void testSplitEachArrayElementAndCreateMapRespectsInstructionNotToRemoveCharacters() {
        String unsplit = "username=\"marissa\", realm=\"Contacts Realm\", nonce=\"MTEwOTAyMzU1MTQ4NDo1YzY3OWViYWM5NDNmZWUwM2UwY2NmMDBiNDQzMTQ0OQ==\", uri=\"/acegi-security-sample-contacts-filter/secure/adminPermission.htm?contactId=4\", response=\"38644211cf9ac3da63ab639807e2baff\", qop=auth, nc=00000004, cnonce=\"2b8d329a8571b99a\"";
        String[] headerEntries = StringUtils.commaDelimitedListToStringArray((String)unsplit);
        Map headerMap = StringSplitUtils.splitEachArrayElementAndCreateMap((String[])headerEntries, (String)"=", null);
        StringSplitUtilsTests.assertEquals((Object)"\"marissa\"", headerMap.get("username"));
        StringSplitUtilsTests.assertEquals((Object)"\"Contacts Realm\"", headerMap.get("realm"));
        StringSplitUtilsTests.assertEquals((Object)"\"MTEwOTAyMzU1MTQ4NDo1YzY3OWViYWM5NDNmZWUwM2UwY2NmMDBiNDQzMTQ0OQ==\"", headerMap.get("nonce"));
        StringSplitUtilsTests.assertEquals((Object)"\"/acegi-security-sample-contacts-filter/secure/adminPermission.htm?contactId=4\"", headerMap.get("uri"));
        StringSplitUtilsTests.assertEquals((Object)"\"38644211cf9ac3da63ab639807e2baff\"", headerMap.get("response"));
        StringSplitUtilsTests.assertEquals((Object)"auth", headerMap.get("qop"));
        StringSplitUtilsTests.assertEquals((Object)"00000004", headerMap.get("nc"));
        StringSplitUtilsTests.assertEquals((Object)"\"2b8d329a8571b99a\"", headerMap.get("cnonce"));
        StringSplitUtilsTests.assertEquals((int)8, (int)headerMap.size());
    }

    public void testSplitEachArrayElementAndCreateMapReturnsNullIfArrayEmptyOrNull() {
        StringSplitUtilsTests.assertNull((Object)StringSplitUtils.splitEachArrayElementAndCreateMap(null, (String)"=", (String)"\""));
        StringSplitUtilsTests.assertNull((Object)StringSplitUtils.splitEachArrayElementAndCreateMap((String[])new String[0], (String)"=", (String)"\""));
    }

    public void testSplitNormalOperation() {
        String unsplit = "username=\"marissa==\"";
        StringSplitUtilsTests.assertEquals((String)"username", (String)StringSplitUtils.split((String)unsplit, (String)"=")[0]);
        StringSplitUtilsTests.assertEquals((String)"\"marissa==\"", (String)StringSplitUtils.split((String)unsplit, (String)"=")[1]);
    }

    public void testSplitRejectsNullsAndIncorrectLengthStrings() {
        try {
            StringSplitUtils.split(null, (String)"=");
            StringSplitUtilsTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            StringSplitUtilsTests.assertTrue((boolean)true);
        }
        try {
            StringSplitUtils.split((String)"", (String)"=");
            StringSplitUtilsTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            StringSplitUtilsTests.assertTrue((boolean)true);
        }
        try {
            StringSplitUtils.split((String)"sdch=dfgf", null);
            StringSplitUtilsTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            StringSplitUtilsTests.assertTrue((boolean)true);
        }
        try {
            StringSplitUtils.split((String)"fvfv=dcdc", (String)"");
            StringSplitUtilsTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            StringSplitUtilsTests.assertTrue((boolean)true);
        }
        try {
            StringSplitUtils.split((String)"dfdc=dcdc", (String)"BIGGER_THAN_ONE_CHARACTER");
            StringSplitUtilsTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            StringSplitUtilsTests.assertTrue((boolean)true);
        }
    }

    public void testSplitWorksWithDifferentDelimiters() {
        StringSplitUtilsTests.assertEquals((int)2, (int)StringSplitUtils.split((String)"18/marissa", (String)"/").length);
        StringSplitUtilsTests.assertNull((Object)StringSplitUtils.split((String)"18/marissa", (String)"!"));
        StringSplitUtilsTests.assertEquals((int)2, (int)StringSplitUtils.split((String)"18|marissa|foo|bar", (String)"|").length);
    }

    public void testAuthorizationHeaderWithCommasIsSplitCorrectly() {
        String header = "Digest username=\"hamilton,bob\", realm=\"bobs,ok,realm\", nonce=\"the,nonce\", uri=\"the,Uri\", response=\"the,response,Digest\", qop=theqop, nc=thenc, cnonce=\"the,cnonce\"";
        String[] parts = StringSplitUtils.splitIgnoringQuotes((String)header, (char)',');
        StringSplitUtilsTests.assertEquals((int)8, (int)parts.length);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

