/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.vote;

import java.util.Vector;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.SecurityConfig;
import org.acegisecurity.providers.TestingAuthenticationToken;
import org.acegisecurity.vote.AffirmativeBased;
import org.acegisecurity.vote.DenyAgainVoter;
import org.acegisecurity.vote.DenyVoter;
import org.acegisecurity.vote.RoleVoter;

public class AffirmativeBasedTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$vote$AffirmativeBasedTests;

    public AffirmativeBasedTests() {
    }

    public AffirmativeBasedTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$vote$AffirmativeBasedTests == null ? (class$org$acegisecurity$vote$AffirmativeBasedTests = AffirmativeBasedTests.class$("org.acegisecurity.vote.AffirmativeBasedTests")) : class$org$acegisecurity$vote$AffirmativeBasedTests));
    }

    private AffirmativeBased makeDecisionManager() {
        AffirmativeBased decisionManager = new AffirmativeBased();
        RoleVoter roleVoter = new RoleVoter();
        DenyVoter denyForSureVoter = new DenyVoter();
        DenyAgainVoter denyAgainForSureVoter = new DenyAgainVoter();
        Vector<Object> voters = new Vector<Object>();
        voters.add(roleVoter);
        voters.add(denyForSureVoter);
        voters.add(denyAgainForSureVoter);
        decisionManager.setDecisionVoters(voters);
        return decisionManager;
    }

    private TestingAuthenticationToken makeTestToken() {
        return new TestingAuthenticationToken((Object)"somebody", (Object)"password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_1"), new GrantedAuthorityImpl("ROLE_2")});
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testOneAffirmativeVoteOneDenyVoteOneAbstainVoteGrantsAccess() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        AffirmativeBased mgr = this.makeDecisionManager();
        ConfigAttributeDefinition config = new ConfigAttributeDefinition();
        config.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_1"));
        config.addConfigAttribute((ConfigAttribute)new SecurityConfig("DENY_FOR_SURE"));
        mgr.decide((Authentication)auth, new Object(), config);
        AffirmativeBasedTests.assertTrue((boolean)true);
    }

    public void testOneAffirmativeVoteTwoAbstainVotesGrantsAccess() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        AffirmativeBased mgr = this.makeDecisionManager();
        ConfigAttributeDefinition config = new ConfigAttributeDefinition();
        config.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_2"));
        mgr.decide((Authentication)auth, new Object(), config);
        AffirmativeBasedTests.assertTrue((boolean)true);
    }

    public void testOneDenyVoteTwoAbstainVotesDeniesAccess() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        AffirmativeBased mgr = this.makeDecisionManager();
        ConfigAttributeDefinition config = new ConfigAttributeDefinition();
        config.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_WE_DO_NOT_HAVE"));
        try {
            mgr.decide((Authentication)auth, new Object(), config);
            AffirmativeBasedTests.fail((String)"Should have thrown AccessDeniedException");
        }
        catch (AccessDeniedException expected) {
            AffirmativeBasedTests.assertTrue((boolean)true);
        }
    }

    public void testThreeAbstainVotesDeniesAccessWithDefault() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        AffirmativeBased mgr = this.makeDecisionManager();
        AffirmativeBasedTests.assertTrue((!mgr.isAllowIfAllAbstainDecisions() ? 1 : 0) != 0);
        ConfigAttributeDefinition config = new ConfigAttributeDefinition();
        config.addConfigAttribute((ConfigAttribute)new SecurityConfig("IGNORED_BY_ALL"));
        try {
            mgr.decide((Authentication)auth, new Object(), config);
            AffirmativeBasedTests.fail((String)"Should have thrown AccessDeniedException");
        }
        catch (AccessDeniedException expected) {
            AffirmativeBasedTests.assertTrue((boolean)true);
        }
    }

    public void testThreeAbstainVotesGrantsAccessWithoutDefault() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        AffirmativeBased mgr = this.makeDecisionManager();
        mgr.setAllowIfAllAbstainDecisions(true);
        AffirmativeBasedTests.assertTrue((boolean)mgr.isAllowIfAllAbstainDecisions());
        ConfigAttributeDefinition config = new ConfigAttributeDefinition();
        config.addConfigAttribute((ConfigAttribute)new SecurityConfig("IGNORED_BY_ALL"));
        mgr.decide((Authentication)auth, new Object(), config);
        AffirmativeBasedTests.assertTrue((boolean)true);
    }

    public void testTwoAffirmativeVotesTwoAbstainVotesGrantsAccess() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        AffirmativeBased mgr = this.makeDecisionManager();
        ConfigAttributeDefinition config = new ConfigAttributeDefinition();
        config.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_1"));
        config.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_2"));
        mgr.decide((Authentication)auth, new Object(), config);
        AffirmativeBasedTests.assertTrue((boolean)true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

