/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.vote;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.Authentication;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.SecurityConfig;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.anonymous.AnonymousAuthenticationToken;
import org.acegisecurity.providers.rememberme.RememberMeAuthenticationToken;
import org.acegisecurity.vote.AuthenticatedVoter;

public class AuthenticatedVoterTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$vote$AuthenticatedVoterTests;
    static /* synthetic */ Class class$java$lang$String;

    public AuthenticatedVoterTests() {
    }

    public AuthenticatedVoterTests(String arg0) {
        super(arg0);
    }

    private Authentication createAnonymous() {
        return new AnonymousAuthenticationToken("ignored", (Object)"ignored", new GrantedAuthority[]{new GrantedAuthorityImpl("ignored")});
    }

    private Authentication createFullyAuthenticated() {
        return new UsernamePasswordAuthenticationToken((Object)"ignored", (Object)"ignored", new GrantedAuthority[]{new GrantedAuthorityImpl("ignored")});
    }

    private Authentication createRememberMe() {
        return new RememberMeAuthenticationToken("ignored", (Object)"ignored", new GrantedAuthority[]{new GrantedAuthorityImpl("ignored")});
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$vote$AuthenticatedVoterTests == null ? (class$org$acegisecurity$vote$AuthenticatedVoterTests = AuthenticatedVoterTests.class$("org.acegisecurity.vote.AuthenticatedVoterTests")) : class$org$acegisecurity$vote$AuthenticatedVoterTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testAnonymousWorks() {
        AuthenticatedVoter voter = new AuthenticatedVoter();
        ConfigAttributeDefinition def = new ConfigAttributeDefinition();
        def.addConfigAttribute((ConfigAttribute)new SecurityConfig("IS_AUTHENTICATED_ANONYMOUSLY"));
        AuthenticatedVoterTests.assertEquals((int)1, (int)voter.vote(this.createAnonymous(), null, def));
        AuthenticatedVoterTests.assertEquals((int)1, (int)voter.vote(this.createRememberMe(), null, def));
        AuthenticatedVoterTests.assertEquals((int)1, (int)voter.vote(this.createFullyAuthenticated(), null, def));
    }

    public void testFullyWorks() {
        AuthenticatedVoter voter = new AuthenticatedVoter();
        ConfigAttributeDefinition def = new ConfigAttributeDefinition();
        def.addConfigAttribute((ConfigAttribute)new SecurityConfig("IS_AUTHENTICATED_FULLY"));
        AuthenticatedVoterTests.assertEquals((int)-1, (int)voter.vote(this.createAnonymous(), null, def));
        AuthenticatedVoterTests.assertEquals((int)-1, (int)voter.vote(this.createRememberMe(), null, def));
        AuthenticatedVoterTests.assertEquals((int)1, (int)voter.vote(this.createFullyAuthenticated(), null, def));
    }

    public void testRememberMeWorks() {
        AuthenticatedVoter voter = new AuthenticatedVoter();
        ConfigAttributeDefinition def = new ConfigAttributeDefinition();
        def.addConfigAttribute((ConfigAttribute)new SecurityConfig("IS_AUTHENTICATED_REMEMBERED"));
        AuthenticatedVoterTests.assertEquals((int)-1, (int)voter.vote(this.createAnonymous(), null, def));
        AuthenticatedVoterTests.assertEquals((int)1, (int)voter.vote(this.createRememberMe(), null, def));
        AuthenticatedVoterTests.assertEquals((int)1, (int)voter.vote(this.createFullyAuthenticated(), null, def));
    }

    public void testSetterRejectsNull() {
        AuthenticatedVoter voter = new AuthenticatedVoter();
        try {
            voter.setAuthenticationTrustResolver(null);
            AuthenticatedVoterTests.fail((String)"Expected IAE");
        }
        catch (IllegalArgumentException expected) {
            AuthenticatedVoterTests.assertTrue((boolean)true);
        }
    }

    public void testSupports() {
        AuthenticatedVoter voter = new AuthenticatedVoter();
        AuthenticatedVoterTests.assertTrue((boolean)voter.supports(class$java$lang$String == null ? (class$java$lang$String = AuthenticatedVoterTests.class$("java.lang.String")) : class$java$lang$String));
        AuthenticatedVoterTests.assertTrue((boolean)voter.supports((ConfigAttribute)new SecurityConfig("IS_AUTHENTICATED_ANONYMOUSLY")));
        AuthenticatedVoterTests.assertTrue((boolean)voter.supports((ConfigAttribute)new SecurityConfig("IS_AUTHENTICATED_FULLY")));
        AuthenticatedVoterTests.assertTrue((boolean)voter.supports((ConfigAttribute)new SecurityConfig("IS_AUTHENTICATED_REMEMBERED")));
        AuthenticatedVoterTests.assertFalse((boolean)voter.supports((ConfigAttribute)new SecurityConfig("FOO")));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

