/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.vote;

import java.util.Vector;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.SecurityConfig;
import org.acegisecurity.providers.TestingAuthenticationToken;
import org.acegisecurity.vote.ConsensusBased;
import org.acegisecurity.vote.DenyAgainVoter;
import org.acegisecurity.vote.DenyVoter;
import org.acegisecurity.vote.RoleVoter;

public class ConsensusBasedTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$vote$ConsensusBasedTests;

    public ConsensusBasedTests() {
    }

    public ConsensusBasedTests(String arg0) {
        super(arg0);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$vote$ConsensusBasedTests == null ? (class$org$acegisecurity$vote$ConsensusBasedTests = ConsensusBasedTests.class$("org.acegisecurity.vote.ConsensusBasedTests")) : class$org$acegisecurity$vote$ConsensusBasedTests));
    }

    public void testOneAffirmativeVoteOneDenyVoteOneAbstainVoteDeniesAccessWithoutDefault() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        ConsensusBased mgr = this.makeDecisionManager();
        mgr.setAllowIfEqualGrantedDeniedDecisions(false);
        ConsensusBasedTests.assertTrue((!mgr.isAllowIfEqualGrantedDeniedDecisions() ? 1 : 0) != 0);
        ConfigAttributeDefinition config = new ConfigAttributeDefinition();
        config.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_1"));
        config.addConfigAttribute((ConfigAttribute)new SecurityConfig("DENY_FOR_SURE"));
        try {
            mgr.decide((Authentication)auth, new Object(), config);
            ConsensusBasedTests.fail((String)"Should have thrown AccessDeniedException");
        }
        catch (AccessDeniedException expected) {
            ConsensusBasedTests.assertTrue((boolean)true);
        }
    }

    public void testOneAffirmativeVoteOneDenyVoteOneAbstainVoteGrantsAccessWithDefault() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        ConsensusBased mgr = this.makeDecisionManager();
        ConsensusBasedTests.assertTrue((boolean)mgr.isAllowIfEqualGrantedDeniedDecisions());
        ConfigAttributeDefinition config = new ConfigAttributeDefinition();
        config.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_1"));
        config.addConfigAttribute((ConfigAttribute)new SecurityConfig("DENY_FOR_SURE"));
        mgr.decide((Authentication)auth, new Object(), config);
        ConsensusBasedTests.assertTrue((boolean)true);
    }

    public void testOneAffirmativeVoteTwoAbstainVotesGrantsAccess() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        ConsensusBased mgr = this.makeDecisionManager();
        ConfigAttributeDefinition config = new ConfigAttributeDefinition();
        config.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_2"));
        mgr.decide((Authentication)auth, new Object(), config);
        ConsensusBasedTests.assertTrue((boolean)true);
    }

    public void testOneDenyVoteTwoAbstainVotesDeniesAccess() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        ConsensusBased mgr = this.makeDecisionManager();
        ConfigAttributeDefinition config = new ConfigAttributeDefinition();
        config.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_WE_DO_NOT_HAVE"));
        try {
            mgr.decide((Authentication)auth, new Object(), config);
            ConsensusBasedTests.fail((String)"Should have thrown AccessDeniedException");
        }
        catch (AccessDeniedException expected) {
            ConsensusBasedTests.assertTrue((boolean)true);
        }
    }

    public void testThreeAbstainVotesDeniesAccessWithDefault() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        ConsensusBased mgr = this.makeDecisionManager();
        ConsensusBasedTests.assertTrue((!mgr.isAllowIfAllAbstainDecisions() ? 1 : 0) != 0);
        ConfigAttributeDefinition config = new ConfigAttributeDefinition();
        config.addConfigAttribute((ConfigAttribute)new SecurityConfig("IGNORED_BY_ALL"));
        try {
            mgr.decide((Authentication)auth, new Object(), config);
            ConsensusBasedTests.fail((String)"Should have thrown AccessDeniedException");
        }
        catch (AccessDeniedException expected) {
            ConsensusBasedTests.assertTrue((boolean)true);
        }
    }

    public void testThreeAbstainVotesGrantsAccessWithoutDefault() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        ConsensusBased mgr = this.makeDecisionManager();
        mgr.setAllowIfAllAbstainDecisions(true);
        ConsensusBasedTests.assertTrue((boolean)mgr.isAllowIfAllAbstainDecisions());
        ConfigAttributeDefinition config = new ConfigAttributeDefinition();
        config.addConfigAttribute((ConfigAttribute)new SecurityConfig("IGNORED_BY_ALL"));
        mgr.decide((Authentication)auth, new Object(), config);
        ConsensusBasedTests.assertTrue((boolean)true);
    }

    public void testTwoAffirmativeVotesTwoAbstainVotesGrantsAccess() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        ConsensusBased mgr = this.makeDecisionManager();
        ConfigAttributeDefinition config = new ConfigAttributeDefinition();
        config.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_1"));
        config.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_2"));
        mgr.decide((Authentication)auth, new Object(), config);
        ConsensusBasedTests.assertTrue((boolean)true);
    }

    private ConsensusBased makeDecisionManager() {
        ConsensusBased decisionManager = new ConsensusBased();
        RoleVoter roleVoter = new RoleVoter();
        DenyVoter denyForSureVoter = new DenyVoter();
        DenyAgainVoter denyAgainForSureVoter = new DenyAgainVoter();
        Vector<Object> voters = new Vector<Object>();
        voters.add(roleVoter);
        voters.add(denyForSureVoter);
        voters.add(denyAgainForSureVoter);
        decisionManager.setDecisionVoters(voters);
        return decisionManager;
    }

    private TestingAuthenticationToken makeTestToken() {
        return new TestingAuthenticationToken((Object)"somebody", (Object)"password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_1"), new GrantedAuthorityImpl("ROLE_2")});
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

