/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.vote;

import java.util.Vector;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.SecurityConfig;
import org.acegisecurity.providers.TestingAuthenticationToken;
import org.acegisecurity.vote.DenyAgainVoter;
import org.acegisecurity.vote.DenyVoter;
import org.acegisecurity.vote.RoleVoter;
import org.acegisecurity.vote.UnanimousBased;

public class UnanimousBasedTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$vote$UnanimousBasedTests;

    public UnanimousBasedTests() {
    }

    public UnanimousBasedTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$vote$UnanimousBasedTests == null ? (class$org$acegisecurity$vote$UnanimousBasedTests = UnanimousBasedTests.class$("org.acegisecurity.vote.UnanimousBasedTests")) : class$org$acegisecurity$vote$UnanimousBasedTests));
    }

    private UnanimousBased makeDecisionManager() {
        UnanimousBased decisionManager = new UnanimousBased();
        RoleVoter roleVoter = new RoleVoter();
        DenyVoter denyForSureVoter = new DenyVoter();
        DenyAgainVoter denyAgainForSureVoter = new DenyAgainVoter();
        Vector<Object> voters = new Vector<Object>();
        voters.add(roleVoter);
        voters.add(denyForSureVoter);
        voters.add(denyAgainForSureVoter);
        decisionManager.setDecisionVoters(voters);
        return decisionManager;
    }

    private UnanimousBased makeDecisionManagerWithFooBarPrefix() {
        UnanimousBased decisionManager = new UnanimousBased();
        RoleVoter roleVoter = new RoleVoter();
        roleVoter.setRolePrefix("FOOBAR_");
        DenyVoter denyForSureVoter = new DenyVoter();
        DenyAgainVoter denyAgainForSureVoter = new DenyAgainVoter();
        Vector<Object> voters = new Vector<Object>();
        voters.add(roleVoter);
        voters.add(denyForSureVoter);
        voters.add(denyAgainForSureVoter);
        decisionManager.setDecisionVoters(voters);
        return decisionManager;
    }

    private TestingAuthenticationToken makeTestToken() {
        return new TestingAuthenticationToken((Object)"somebody", (Object)"password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_1"), new GrantedAuthorityImpl("ROLE_2")});
    }

    private TestingAuthenticationToken makeTestTokenWithFooBarPrefix() {
        return new TestingAuthenticationToken((Object)"somebody", (Object)"password", new GrantedAuthority[]{new GrantedAuthorityImpl("FOOBAR_1"), new GrantedAuthorityImpl("FOOBAR_2")});
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testOneAffirmativeVoteOneDenyVoteOneAbstainVoteDeniesAccess() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        UnanimousBased mgr = this.makeDecisionManager();
        ConfigAttributeDefinition config = new ConfigAttributeDefinition();
        config.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_1"));
        config.addConfigAttribute((ConfigAttribute)new SecurityConfig("DENY_FOR_SURE"));
        try {
            mgr.decide((Authentication)auth, new Object(), config);
            UnanimousBasedTests.fail((String)"Should have thrown AccessDeniedException");
        }
        catch (AccessDeniedException expected) {
            UnanimousBasedTests.assertTrue((boolean)true);
        }
    }

    public void testOneAffirmativeVoteTwoAbstainVotesGrantsAccess() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        UnanimousBased mgr = this.makeDecisionManager();
        ConfigAttributeDefinition config = new ConfigAttributeDefinition();
        config.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_2"));
        mgr.decide((Authentication)auth, new Object(), config);
        UnanimousBasedTests.assertTrue((boolean)true);
    }

    public void testOneDenyVoteTwoAbstainVotesDeniesAccess() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        UnanimousBased mgr = this.makeDecisionManager();
        ConfigAttributeDefinition config = new ConfigAttributeDefinition();
        config.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_WE_DO_NOT_HAVE"));
        try {
            mgr.decide((Authentication)auth, new Object(), config);
            UnanimousBasedTests.fail((String)"Should have thrown AccessDeniedException");
        }
        catch (AccessDeniedException expected) {
            UnanimousBasedTests.assertTrue((boolean)true);
        }
    }

    public void testRoleVoterPrefixObserved() throws Exception {
        TestingAuthenticationToken auth = this.makeTestTokenWithFooBarPrefix();
        UnanimousBased mgr = this.makeDecisionManagerWithFooBarPrefix();
        ConfigAttributeDefinition config = new ConfigAttributeDefinition();
        config.addConfigAttribute((ConfigAttribute)new SecurityConfig("FOOBAR_1"));
        config.addConfigAttribute((ConfigAttribute)new SecurityConfig("FOOBAR_2"));
        mgr.decide((Authentication)auth, new Object(), config);
        UnanimousBasedTests.assertTrue((boolean)true);
    }

    public void testThreeAbstainVotesDeniesAccessWithDefault() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        UnanimousBased mgr = this.makeDecisionManager();
        UnanimousBasedTests.assertTrue((!mgr.isAllowIfAllAbstainDecisions() ? 1 : 0) != 0);
        ConfigAttributeDefinition config = new ConfigAttributeDefinition();
        config.addConfigAttribute((ConfigAttribute)new SecurityConfig("IGNORED_BY_ALL"));
        try {
            mgr.decide((Authentication)auth, new Object(), config);
            UnanimousBasedTests.fail((String)"Should have thrown AccessDeniedException");
        }
        catch (AccessDeniedException expected) {
            UnanimousBasedTests.assertTrue((boolean)true);
        }
    }

    public void testThreeAbstainVotesGrantsAccessWithoutDefault() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        UnanimousBased mgr = this.makeDecisionManager();
        mgr.setAllowIfAllAbstainDecisions(true);
        UnanimousBasedTests.assertTrue((boolean)mgr.isAllowIfAllAbstainDecisions());
        ConfigAttributeDefinition config = new ConfigAttributeDefinition();
        config.addConfigAttribute((ConfigAttribute)new SecurityConfig("IGNORED_BY_ALL"));
        mgr.decide((Authentication)auth, new Object(), config);
        UnanimousBasedTests.assertTrue((boolean)true);
    }

    public void testTwoAffirmativeVotesTwoAbstainVotesGrantsAccess() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        UnanimousBased mgr = this.makeDecisionManager();
        ConfigAttributeDefinition config = new ConfigAttributeDefinition();
        config.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_1"));
        config.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_2"));
        mgr.decide((Authentication)auth, new Object(), config);
        UnanimousBasedTests.assertTrue((boolean)true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

