/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.acl.basic.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import org.acegisecurity.acl.basic.AclObjectIdentity;
import org.acegisecurity.acl.basic.BasicAclEntry;
import org.acegisecurity.acl.basic.BasicAclEntryCache;
import org.acegisecurity.acl.basic.BasicAclExtendedDao;
import org.acegisecurity.acl.basic.cache.NullAclEntryCache;
import org.acegisecurity.acl.basic.jdbc.JdbcDaoImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.object.MappingSqlQuery;
import org.springframework.jdbc.object.SqlUpdate;
import org.springframework.util.Assert;

public class JdbcExtendedDaoImpl
extends JdbcDaoImpl
implements BasicAclExtendedDao {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$acl$basic$jdbc$JdbcExtendedDaoImpl == null ? (class$org$acegisecurity$acl$basic$jdbc$JdbcExtendedDaoImpl = JdbcExtendedDaoImpl.class$("org.acegisecurity.acl.basic.jdbc.JdbcExtendedDaoImpl")) : class$org$acegisecurity$acl$basic$jdbc$JdbcExtendedDaoImpl));
    public static final String DEF_ACL_OBJECT_IDENTITY_DELETE_STATEMENT = "DELETE FROM acl_object_identity WHERE id = ?";
    public static final String DEF_ACL_OBJECT_IDENTITY_INSERT_STATEMENT = "INSERT INTO acl_object_identity (object_identity, parent_object, acl_class) VALUES (?, ?, ?)";
    public static final String DEF_ACL_PERMISSION_DELETE_STATEMENT = "DELETE FROM acl_permission WHERE acl_object_identity = ? AND recipient = ?";
    public static final String DEF_ACL_PERMISSION_INSERT_STATEMENT = "INSERT INTO acl_permission (acl_object_identity, recipient, mask) VALUES (?, ?, ?)";
    public static final String DEF_ACL_PERMISSION_UPDATE_STATEMENT = "UPDATE acl_permission SET mask = ? WHERE id = ?";
    public static final String DEF_LOOKUP_PERMISSION_ID_QUERY = "SELECT id FROM acl_permission WHERE acl_object_identity = ? AND recipient = ?";
    private AclObjectIdentityDelete aclObjectIdentityDelete;
    private AclObjectIdentityInsert aclObjectIdentityInsert;
    private AclPermissionDelete aclPermissionDelete;
    private AclPermissionInsert aclPermissionInsert;
    private AclPermissionUpdate aclPermissionUpdate;
    private BasicAclEntryCache basicAclEntryCache = new NullAclEntryCache();
    private MappingSqlQuery lookupPermissionIdMapping;
    private String aclObjectIdentityDeleteStatement = "DELETE FROM acl_object_identity WHERE id = ?";
    private String aclObjectIdentityInsertStatement = "INSERT INTO acl_object_identity (object_identity, parent_object, acl_class) VALUES (?, ?, ?)";
    private String aclPermissionDeleteStatement = "DELETE FROM acl_permission WHERE acl_object_identity = ? AND recipient = ?";
    private String aclPermissionInsertStatement = "INSERT INTO acl_permission (acl_object_identity, recipient, mask) VALUES (?, ?, ?)";
    private String aclPermissionUpdateStatement = "UPDATE acl_permission SET mask = ? WHERE id = ?";
    private String lookupPermissionIdQuery = "SELECT id FROM acl_permission WHERE acl_object_identity = ? AND recipient = ?";
    static /* synthetic */ Class class$org$acegisecurity$acl$basic$jdbc$JdbcExtendedDaoImpl;

    public void changeMask(AclObjectIdentity aclObjectIdentity, Object recipient, Integer newMask) throws DataAccessException {
        this.basicAclEntryCache.removeEntriesFromCache(aclObjectIdentity);
        JdbcDaoImpl.AclDetailsHolder aclDetailsHolder = this.lookupAclDetailsHolder(aclObjectIdentity);
        long permissionId = this.lookupPermissionId(aclDetailsHolder.getForeignKeyId(), recipient.toString());
        if (permissionId == -1L) {
            throw new DataRetrievalFailureException("Could not locate existing acl_permission for aclObjectIdentity: " + aclObjectIdentity + ", recipient: " + recipient.toString());
        }
        this.aclPermissionUpdate.update(new Long(permissionId), newMask);
    }

    public void create(BasicAclEntry basicAclEntry) throws DataAccessException {
        this.createAclObjectIdentityIfRequired(basicAclEntry);
        if (basicAclEntry.getRecipient() == null) {
            return;
        }
        JdbcDaoImpl.AclDetailsHolder aclDetailsHolder = this.lookupAclDetailsHolder(basicAclEntry.getAclObjectIdentity());
        long permissionId = this.lookupPermissionId(aclDetailsHolder.getForeignKeyId(), basicAclEntry.getRecipient());
        if (permissionId != -1L) {
            throw new DataIntegrityViolationException("Recipient '" + basicAclEntry.getRecipient() + "' already exists for aclObjectIdentity ID " + aclDetailsHolder.getForeignKeyId() + " (permission ID " + ")");
        }
        this.aclPermissionInsert.insert(new Long(aclDetailsHolder.getForeignKeyId()), basicAclEntry.getRecipient().toString(), new Integer(basicAclEntry.getMask()));
    }

    private void createAclObjectIdentityIfRequired(BasicAclEntry basicAclEntry) throws DataAccessException {
        this.basicAclEntryCache.removeEntriesFromCache(basicAclEntry.getAclObjectIdentity());
        String aclObjectIdentityString = this.convertAclObjectIdentityToString(basicAclEntry.getAclObjectIdentity());
        List objects = this.objectProperties.execute(aclObjectIdentityString);
        if (objects.size() == 0) {
            if (basicAclEntry.getAclObjectParentIdentity() != null) {
                JdbcDaoImpl.AclDetailsHolder parentDetails = this.lookupAclDetailsHolder(basicAclEntry.getAclObjectParentIdentity());
                this.aclObjectIdentityInsert.insert(aclObjectIdentityString, new Long(parentDetails.getForeignKeyId()), basicAclEntry.getClass().getName());
            } else {
                this.aclObjectIdentityInsert.insert(aclObjectIdentityString, null, basicAclEntry.getClass().getName());
            }
        }
    }

    public void delete(AclObjectIdentity aclObjectIdentity) throws DataAccessException {
        this.basicAclEntryCache.removeEntriesFromCache(aclObjectIdentity);
        JdbcDaoImpl.AclDetailsHolder aclDetailsHolder = this.lookupAclDetailsHolder(aclObjectIdentity);
        Iterator acls = this.aclsByObjectIdentity.execute(aclDetailsHolder.getForeignKeyId()).iterator();
        while (acls.hasNext()) {
            JdbcDaoImpl.AclDetailsHolder permission = (JdbcDaoImpl.AclDetailsHolder)acls.next();
            this.delete(aclObjectIdentity, permission.getRecipient());
        }
        this.aclObjectIdentityDelete.delete(new Long(aclDetailsHolder.getForeignKeyId()));
    }

    public void delete(AclObjectIdentity aclObjectIdentity, Object recipient) throws DataAccessException {
        this.basicAclEntryCache.removeEntriesFromCache(aclObjectIdentity);
        JdbcDaoImpl.AclDetailsHolder aclDetailsHolder = this.lookupAclDetailsHolder(aclObjectIdentity);
        this.aclPermissionDelete.delete(new Long(aclDetailsHolder.getForeignKeyId()), recipient.toString());
    }

    public AclObjectIdentityDelete getAclObjectIdentityDelete() {
        return this.aclObjectIdentityDelete;
    }

    public String getAclObjectIdentityDeleteStatement() {
        return this.aclObjectIdentityDeleteStatement;
    }

    public AclObjectIdentityInsert getAclObjectIdentityInsert() {
        return this.aclObjectIdentityInsert;
    }

    public String getAclObjectIdentityInsertStatement() {
        return this.aclObjectIdentityInsertStatement;
    }

    public AclPermissionDelete getAclPermissionDelete() {
        return this.aclPermissionDelete;
    }

    public String getAclPermissionDeleteStatement() {
        return this.aclPermissionDeleteStatement;
    }

    public AclPermissionInsert getAclPermissionInsert() {
        return this.aclPermissionInsert;
    }

    public String getAclPermissionInsertStatement() {
        return this.aclPermissionInsertStatement;
    }

    public AclPermissionUpdate getAclPermissionUpdate() {
        return this.aclPermissionUpdate;
    }

    public String getAclPermissionUpdateStatement() {
        return this.aclPermissionUpdateStatement;
    }

    public BasicAclEntryCache getBasicAclEntryCache() {
        return this.basicAclEntryCache;
    }

    public MappingSqlQuery getLookupPermissionIdMapping() {
        return this.lookupPermissionIdMapping;
    }

    public String getLookupPermissionIdQuery() {
        return this.lookupPermissionIdQuery;
    }

    protected void initDao() throws ApplicationContextException {
        super.initDao();
        this.lookupPermissionIdMapping = new LookupPermissionIdMapping(this.getDataSource());
        this.aclPermissionInsert = new AclPermissionInsert(this.getDataSource());
        this.aclObjectIdentityInsert = new AclObjectIdentityInsert(this.getDataSource());
        this.aclPermissionDelete = new AclPermissionDelete(this.getDataSource());
        this.aclObjectIdentityDelete = new AclObjectIdentityDelete(this.getDataSource());
        this.aclPermissionUpdate = new AclPermissionUpdate(this.getDataSource());
    }

    private JdbcDaoImpl.AclDetailsHolder lookupAclDetailsHolder(AclObjectIdentity aclObjectIdentity) throws DataRetrievalFailureException {
        String aclObjectIdentityString = this.convertAclObjectIdentityToString(aclObjectIdentity);
        List objects = this.objectProperties.execute(aclObjectIdentityString);
        if (objects.size() == 0) {
            throw new DataRetrievalFailureException("aclObjectIdentity not found: " + aclObjectIdentityString);
        }
        return (JdbcDaoImpl.AclDetailsHolder)objects.get(0);
    }

    private long lookupPermissionId(long aclObjectIdentityId, Object recipient) throws DataAccessException {
        List list = this.lookupPermissionIdMapping.execute(new Object[]{new Long(aclObjectIdentityId), recipient});
        if (list.size() == 0) {
            return -1L;
        }
        return (Long)list.get(0);
    }

    public void setAclObjectIdentityDelete(AclObjectIdentityDelete aclObjectIdentityDelete) {
        this.aclObjectIdentityDelete = aclObjectIdentityDelete;
    }

    public void setAclObjectIdentityDeleteStatement(String aclObjectIdentityDeleteStatement) {
        this.aclObjectIdentityDeleteStatement = aclObjectIdentityDeleteStatement;
    }

    public void setAclObjectIdentityInsert(AclObjectIdentityInsert aclObjectIdentityInsert) {
        this.aclObjectIdentityInsert = aclObjectIdentityInsert;
    }

    public void setAclObjectIdentityInsertStatement(String aclObjectIdentityInsertStatement) {
        this.aclObjectIdentityInsertStatement = aclObjectIdentityInsertStatement;
    }

    public void setAclPermissionDelete(AclPermissionDelete aclPermissionDelete) {
        this.aclPermissionDelete = aclPermissionDelete;
    }

    public void setAclPermissionDeleteStatement(String aclPermissionDeleteStatement) {
        this.aclPermissionDeleteStatement = aclPermissionDeleteStatement;
    }

    public void setAclPermissionInsert(AclPermissionInsert aclPermissionInsert) {
        this.aclPermissionInsert = aclPermissionInsert;
    }

    public void setAclPermissionInsertStatement(String aclPermissionInsertStatement) {
        this.aclPermissionInsertStatement = aclPermissionInsertStatement;
    }

    public void setAclPermissionUpdate(AclPermissionUpdate aclPermissionUpdate) {
        this.aclPermissionUpdate = aclPermissionUpdate;
    }

    public void setAclPermissionUpdateStatement(String aclPermissionUpdateStatement) {
        this.aclPermissionUpdateStatement = aclPermissionUpdateStatement;
    }

    public void setBasicAclEntryCache(BasicAclEntryCache basicAclEntryCache) {
        Assert.notNull((Object)basicAclEntryCache, (String)"Cache cannot be set to null");
        this.basicAclEntryCache = basicAclEntryCache;
    }

    public void setLookupPermissionIdMapping(MappingSqlQuery lookupPermissionIdMapping) {
        this.lookupPermissionIdMapping = lookupPermissionIdMapping;
    }

    public void setLookupPermissionIdQuery(String lookupPermissionIdQuery) {
        this.lookupPermissionIdQuery = lookupPermissionIdQuery;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class LookupPermissionIdMapping
    extends MappingSqlQuery {
        protected LookupPermissionIdMapping(DataSource ds) {
            super(ds, JdbcExtendedDaoImpl.this.lookupPermissionIdQuery);
            this.declareParameter(new SqlParameter(-5));
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }

        protected Object mapRow(ResultSet rs, int rownum) throws SQLException {
            return new Long(rs.getLong(1));
        }
    }

    protected class AclPermissionUpdate
    extends SqlUpdate {
        protected AclPermissionUpdate(DataSource ds) {
            super(ds, JdbcExtendedDaoImpl.this.aclPermissionUpdateStatement);
            this.declareParameter(new SqlParameter(-5));
            this.declareParameter(new SqlParameter(4));
            this.compile();
        }

        protected void update(Long aclPermissionId, Integer newMask) throws DataAccessException {
            super.update(newMask.intValue(), aclPermissionId.intValue());
        }
    }

    protected class AclPermissionInsert
    extends SqlUpdate {
        protected AclPermissionInsert(DataSource ds) {
            super(ds, JdbcExtendedDaoImpl.this.aclPermissionInsertStatement);
            this.declareParameter(new SqlParameter(-5));
            this.declareParameter(new SqlParameter(12));
            this.declareParameter(new SqlParameter(4));
            this.compile();
        }

        protected void insert(Long aclObjectIdentity, String recipient, Integer mask) throws DataAccessException {
            Object[] objs = new Object[]{aclObjectIdentity, recipient, mask};
            super.update(objs);
        }
    }

    protected class AclPermissionDelete
    extends SqlUpdate {
        protected AclPermissionDelete(DataSource ds) {
            super(ds, JdbcExtendedDaoImpl.this.aclPermissionDeleteStatement);
            this.declareParameter(new SqlParameter(-5));
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }

        protected void delete(Long aclObjectIdentity, String recipient) throws DataAccessException {
            super.update(new Object[]{aclObjectIdentity, recipient});
        }
    }

    protected class AclObjectIdentityInsert
    extends SqlUpdate {
        protected AclObjectIdentityInsert(DataSource ds) {
            super(ds, JdbcExtendedDaoImpl.this.aclObjectIdentityInsertStatement);
            this.declareParameter(new SqlParameter(12));
            this.declareParameter(new SqlParameter(-5));
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }

        protected void insert(String objectIdentity, Long parentAclObjectIdentity, String aclClass) throws DataAccessException {
            Object[] objs = new Object[]{objectIdentity, parentAclObjectIdentity, aclClass};
            super.update(objs);
        }
    }

    protected class AclObjectIdentityDelete
    extends SqlUpdate {
        protected AclObjectIdentityDelete(DataSource ds) {
            super(ds, JdbcExtendedDaoImpl.this.aclObjectIdentityDeleteStatement);
            this.declareParameter(new SqlParameter(-5));
            this.compile();
        }

        protected void delete(Long aclObjectIdentity) throws DataAccessException {
            super.update(aclObjectIdentity.intValue());
        }
    }
}

