/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2014 Christian Gärtner
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package org.achtern.AchternEngine.core.scenegraph.scanning;

import org.achtern.AchternEngine.core.scenegraph.Node;
import org.achtern.AchternEngine.core.scenegraph.entity.Entity;

/**
 * Wrapper of the EntityRetriever and can be used
 * if one only needs a single Entity from the scenegraph.
 * This can be useful, if you want to to retrieve a control
 * Entity from the Camera Node, which has only one control Entity
 */
public class SingleEntityRetriever extends EntityRetriever {

    /**
     * Default Constructor.
     * Does nothing...
     */
    public SingleEntityRetriever() {
    }

    /**
     * Calls #scan(Node) in order to allow easy
     * chaining:
     * <code>Entity e = new SingleEntityRetriever(someNode).get(Entity.class);</code>
     * @param toScan will get scanned
     */
    public SingleEntityRetriever(Node toScan) {
        scan(toScan);
    }

    /**
     * Call #scan(Node) first!
     * Returns the Entity of the given type or null
     * @param type Class of type of Entity
     * @param <T> type of Entity
     * @return Entity | null
     */
    public <T extends Entity> T get(Class<T > type) {
        if (getAll(type).size() > 0) {
            return getAll(type).get(0);
        } else {
            return null;
        }
    }

}
