/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core;

import java.util.ArrayList;
import java.util.List;
import org.achtern.AchternEngine.core.CoreEngine;
import org.achtern.AchternEngine.core.EngineHolder;
import org.achtern.AchternEngine.core.Game;
import org.achtern.AchternEngine.core.input.Key;
import org.achtern.AchternEngine.core.input.event.listener.KeyListener;
import org.achtern.AchternEngine.core.input.event.listener.trigger.KeyTrigger;
import org.achtern.AchternEngine.core.input.event.listener.trigger.util.KeyTriggerList;
import org.achtern.AchternEngine.core.input.event.payload.KeyEvent;
import org.achtern.AchternEngine.core.math.Vector3f;
import org.achtern.AchternEngine.core.rendering.Color;
import org.achtern.AchternEngine.core.rendering.drawing.DrawStrategy;
import org.achtern.AchternEngine.core.rendering.drawing.DrawStrategyFactory;
import org.achtern.AchternEngine.core.scenegraph.Node;
import org.achtern.AchternEngine.core.scenegraph.Updatable;
import org.achtern.AchternEngine.core.scenegraph.entity.Camera;
import org.achtern.AchternEngine.core.scenegraph.entity.renderpasses.WireframeDisplay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameDebugger
implements Updatable,
EngineHolder<CoreEngine>,
KeyListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(GameDebugger.class);
    protected CoreEngine engine;
    protected Game game;
    protected List<DebugStateListener> hooks;
    protected Color prevClearColor;
    protected DrawStrategy wD = DrawStrategyFactory.get(DrawStrategyFactory.Common.WIREFRAME);
    protected DrawStrategy sD = DrawStrategyFactory.get(DrawStrategyFactory.Common.SOLID);
    protected Node wireframe = new Node("Wireframe Display").add(new WireframeDisplay(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(0.0f, 0.0f, 0.0f)));

    public GameDebugger(Game game) {
        this.game = game;
        this.hooks = new ArrayList<DebugStateListener>();
        game.getInputManager().getKeyMap().register((List<KeyTrigger>)new KeyTriggerList(Key.Z, Key.X, Key.C), (KeyListener)this);
    }

    public void register(DebugStateListener l) {
        this.register(l, false);
    }

    public void register(DebugStateListener l, boolean pushState) {
        this.hooks.add(l);
        l.changed(true);
    }

    @Override
    public void onAction(KeyEvent event) {
        if (event.getKey().equals((Object)Key.Z)) {
            Class<?> wireframe;
            if (!this.getGame().isDebug()) {
                return;
            }
            Class<?> current = this.getEngine().getRenderEngine().getDrawStrategy().getClass();
            if (current.equals(wireframe = this.wD.getClass())) {
                this.getEngine().getRenderEngine().setDrawStrategy(this.sD);
            } else {
                this.getEngine().getRenderEngine().setDrawStrategy(this.wD);
            }
        } else if (event.getKey().equals((Object)Key.X)) {
            if (!this.getGame().isDebug()) {
                return;
            }
            if (this.getGame().has(this.wireframe)) {
                LOGGER.trace("Removing {}", (Object)this.wireframe.getName());
                this.getGame().remove(this.wireframe);
            } else {
                LOGGER.trace("Adding {}", (Object)this.wireframe.getName());
                this.getGame().add(this.wireframe);
            }
        } else if (event.getKey().equals((Object)Key.C)) {
            Camera c = this.getEngine().getRenderEngine().getCamera();
            LOGGER.info("\nCamera Dump:\npos={}\nrot={}\nscale={}\n", new Object[]{c.getTransform().getPosition(), c.getTransform().getRotation(), c.getTransform().getScale()});
        }
    }

    public void enable() {
        this.prevClearColor = this.getEngine().getRenderEngine().getState().getClearColor();
        this.getEngine().getRenderEngine().getState().setClearColor(new Color(0.0f, 0.3f, 0.0f, 1.0f));
        for (DebugStateListener l : this.hooks) {
            l.changed(true);
        }
    }

    public void disable() {
        this.getEngine().getRenderEngine().getState().setClearColor(this.prevClearColor);
        for (DebugStateListener l : this.hooks) {
            l.changed(false);
        }
    }

    @Override
    public CoreEngine getEngine() {
        return this.engine;
    }

    @Override
    public void setEngine(CoreEngine engine) {
        this.engine = engine;
    }

    public Game getGame() {
        return this.game;
    }

    @Override
    public void update(float delta) {
    }

    public static interface DebugStateListener {
        public void changed(boolean var1);
    }
}

