/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.input;

import org.achtern.AchternEngine.core.input.adapter.InputAdapter;
import org.achtern.AchternEngine.core.input.inputmap.KeyMap;
import org.achtern.AchternEngine.core.input.inputmap.MouseMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputManager.class);
    protected InputAdapter input;
    protected KeyMap keyMap;
    protected MouseMap mouseMap;

    public InputManager(InputAdapter input) {
        this.input = input;
        this.setMouseMap(new MouseMap());
        this.setKeyMap(new KeyMap());
    }

    public void trigger(float delta) {
        this.keyMap.trigger(delta);
        this.mouseMap.trigger(delta);
        this.input.update();
    }

    public void setKeyMap(KeyMap keyMap) {
        this.keyMap = keyMap;
        this.keyMap.setInput(this.input);
    }

    public void setMouseMap(MouseMap mouseMap) {
        this.mouseMap = mouseMap;
        this.mouseMap.setInput(this.input);
    }

    public KeyMap getKeyMap() {
        return this.keyMap;
    }

    public MouseMap getMouseMap() {
        return this.mouseMap;
    }
}

