/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.math;

import org.achtern.AchternEngine.core.math.Vector3f;

public class Matrix4f {
    private float[][] m = new float[4][4];

    public Matrix4f initIdentiy() {
        this.m[0][0] = 1.0f;
        this.m[0][1] = 0.0f;
        this.m[0][2] = 0.0f;
        this.m[0][3] = 0.0f;
        this.m[1][0] = 0.0f;
        this.m[1][1] = 1.0f;
        this.m[1][2] = 0.0f;
        this.m[1][3] = 0.0f;
        this.m[2][0] = 0.0f;
        this.m[2][1] = 0.0f;
        this.m[2][2] = 1.0f;
        this.m[2][3] = 0.0f;
        this.m[3][0] = 0.0f;
        this.m[3][1] = 0.0f;
        this.m[3][2] = 0.0f;
        this.m[3][3] = 1.0f;
        return this;
    }

    public Matrix4f initTranslation(float x, float y, float z) {
        this.m[0][0] = 1.0f;
        this.m[0][1] = 0.0f;
        this.m[0][2] = 0.0f;
        this.m[0][3] = x;
        this.m[1][0] = 0.0f;
        this.m[1][1] = 1.0f;
        this.m[1][2] = 0.0f;
        this.m[1][3] = y;
        this.m[2][0] = 0.0f;
        this.m[2][1] = 0.0f;
        this.m[2][2] = 1.0f;
        this.m[2][3] = z;
        this.m[3][0] = 0.0f;
        this.m[3][1] = 0.0f;
        this.m[3][2] = 0.0f;
        this.m[3][3] = 1.0f;
        return this;
    }

    public Matrix4f initRotation(float x, float y, float z) {
        Matrix4f mx = new Matrix4f();
        Matrix4f my = new Matrix4f();
        Matrix4f mz = new Matrix4f();
        x = (float)Math.toRadians(x);
        y = (float)Math.toRadians(y);
        z = (float)Math.toRadians(z);
        mz.m[0][0] = (float)Math.cos(z);
        mz.m[0][1] = (float)(-Math.sin(z));
        mz.m[0][2] = 0.0f;
        mz.m[0][3] = 0.0f;
        mz.m[1][0] = (float)Math.sin(z);
        mz.m[1][1] = (float)Math.cos(z);
        mz.m[1][2] = 0.0f;
        mz.m[1][3] = 0.0f;
        mz.m[2][0] = 0.0f;
        mz.m[2][1] = 0.0f;
        mz.m[2][2] = 1.0f;
        mz.m[2][3] = 0.0f;
        mz.m[3][0] = 0.0f;
        mz.m[3][1] = 0.0f;
        mz.m[3][2] = 0.0f;
        mz.m[3][3] = 1.0f;
        mx.m[0][0] = 1.0f;
        mx.m[0][1] = 0.0f;
        mx.m[0][2] = 0.0f;
        mx.m[0][3] = 0.0f;
        mx.m[1][0] = 0.0f;
        mx.m[1][1] = (float)Math.cos(x);
        mx.m[1][2] = (float)(-Math.sin(x));
        mx.m[1][3] = 0.0f;
        mx.m[2][0] = 0.0f;
        mx.m[2][1] = (float)Math.sin(x);
        mx.m[2][2] = (float)Math.cos(x);
        mx.m[2][3] = 0.0f;
        mx.m[3][0] = 0.0f;
        mx.m[3][1] = 0.0f;
        mx.m[3][2] = 0.0f;
        mx.m[3][3] = 1.0f;
        my.m[0][0] = (float)Math.cos(y);
        my.m[0][1] = 0.0f;
        my.m[0][2] = (float)(-Math.sin(y));
        my.m[0][3] = 0.0f;
        my.m[1][0] = 0.0f;
        my.m[1][1] = 1.0f;
        my.m[1][2] = 0.0f;
        my.m[1][3] = 0.0f;
        my.m[2][0] = (float)Math.sin(y);
        my.m[2][1] = 0.0f;
        my.m[2][2] = (float)Math.cos(y);
        my.m[2][3] = 0.0f;
        my.m[3][0] = 0.0f;
        my.m[3][1] = 0.0f;
        my.m[3][2] = 0.0f;
        my.m[3][3] = 1.0f;
        this.m = mz.mul(my.mul(mx)).getM();
        return this;
    }

    public Matrix4f initScale(float x, float y, float z) {
        this.m[0][0] = x;
        this.m[1][0] = 0.0f;
        this.m[2][0] = 0.0f;
        this.m[3][0] = 0.0f;
        this.m[0][1] = 0.0f;
        this.m[1][1] = y;
        this.m[2][1] = 0.0f;
        this.m[3][1] = 0.0f;
        this.m[0][2] = 0.0f;
        this.m[1][2] = 0.0f;
        this.m[2][2] = z;
        this.m[3][2] = 0.0f;
        this.m[0][3] = 0.0f;
        this.m[1][3] = 0.0f;
        this.m[2][3] = 0.0f;
        this.m[3][3] = 1.0f;
        return this;
    }

    public Matrix4f initPerspective(float fov, float aspect, float zNear, float zFar) {
        float fgv = (float)Math.tan(fov / 2.0f);
        float range = zNear - zFar;
        this.m[0][0] = 1.0f / (fgv * aspect);
        this.m[0][1] = 0.0f;
        this.m[0][2] = 0.0f;
        this.m[0][3] = 0.0f;
        this.m[1][0] = 0.0f;
        this.m[1][1] = 1.0f / fgv;
        this.m[1][2] = 0.0f;
        this.m[1][3] = 0.0f;
        this.m[2][0] = 0.0f;
        this.m[2][1] = 0.0f;
        this.m[2][2] = (-zNear - zFar) / range;
        this.m[2][3] = 2.0f * zFar * zNear / range;
        this.m[3][0] = 0.0f;
        this.m[3][1] = 0.0f;
        this.m[3][2] = 1.0f;
        this.m[3][3] = 0.0f;
        return this;
    }

    public Matrix4f initOrthographic(float left, float right, float bottom, float top, float near, float far) {
        float RmL = right - left;
        float TmB = top - bottom;
        float FmN = far - near;
        float RpL = right + left;
        float TpB = top + bottom;
        float FpN = far + near;
        this.m[0][0] = 2.0f / RmL;
        this.m[0][1] = 0.0f;
        this.m[0][2] = 0.0f;
        this.m[0][3] = -RpL / RmL;
        this.m[1][0] = 0.0f;
        this.m[1][1] = 2.0f / TmB;
        this.m[1][2] = 0.0f;
        this.m[1][3] = -TpB / TmB;
        this.m[2][0] = 0.0f;
        this.m[2][1] = 0.0f;
        this.m[2][2] = -1.0f / FmN;
        this.m[2][3] = -near / FmN;
        this.m[3][0] = 0.0f;
        this.m[3][1] = 0.0f;
        this.m[3][2] = 0.0f;
        this.m[3][3] = 1.0f;
        return this;
    }

    public Matrix4f initRotation(Vector3f forward, Vector3f up) {
        Vector3f f = forward.normalized();
        Vector3f r = up.normalized().cross(f);
        Vector3f u = f.cross(r);
        return this.initRotation(f, u, r);
    }

    public Matrix4f initRotation(Vector3f forward, Vector3f up, Vector3f right) {
        this.m[0][0] = right.getX();
        this.m[0][1] = right.getY();
        this.m[0][2] = right.getZ();
        this.m[0][3] = 0.0f;
        this.m[1][0] = up.getX();
        this.m[1][1] = up.getY();
        this.m[1][2] = up.getZ();
        this.m[1][3] = 0.0f;
        this.m[2][0] = forward.getX();
        this.m[2][1] = forward.getY();
        this.m[2][2] = forward.getZ();
        this.m[2][3] = 0.0f;
        this.m[3][0] = 0.0f;
        this.m[3][1] = 0.0f;
        this.m[3][2] = 0.0f;
        this.m[3][3] = 1.0f;
        return this;
    }

    public Vector3f transform(Vector3f v) {
        return new Vector3f(this.m[0][0] * v.getX() + this.m[0][1] * v.getY() + this.m[0][2] * v.getZ() + this.m[0][3], this.m[1][0] * v.getX() + this.m[1][1] * v.getY() + this.m[1][2] * v.getZ() + this.m[1][3], this.m[2][0] * v.getX() + this.m[2][1] * v.getY() + this.m[2][2] * v.getZ() + this.m[2][3]);
    }

    public Matrix4f mul(Matrix4f ma) {
        Matrix4f ret = new Matrix4f();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                ret.set(i, j, this.m[i][0] * ma.get(0, j) + this.m[i][1] * ma.get(1, j) + this.m[i][2] * ma.get(2, j) + this.m[i][3] * ma.get(3, j));
            }
        }
        return ret;
    }

    public float get(int x, int y) {
        return this.m[x][y];
    }

    public void set(int x, int y, float val) {
        this.m[x][y] = val;
    }

    public void set1Line(float x1, float x2, float x3, int x4) {
        this.m[0][0] = x1;
        this.m[0][1] = x2;
        this.m[0][2] = x3;
        this.m[0][3] = x4;
    }

    public void set2Line(float x1, float x2, float x3, float x4) {
        this.m[1][0] = x1;
        this.m[1][1] = x2;
        this.m[1][2] = x3;
        this.m[1][3] = x4;
    }

    public void set3Line(float x1, float x2, float x3, float x4) {
        this.m[2][0] = x1;
        this.m[2][1] = x2;
        this.m[2][2] = x3;
        this.m[2][3] = x4;
    }

    public void set4Line(float x1, float x2, float x3, float x4) {
        this.m[3][0] = x1;
        this.m[3][1] = x2;
        this.m[3][2] = x3;
        this.m[3][3] = x4;
    }

    public float[][] getM() {
        float[][] res = new float[4][4];
        System.arraycopy(this.m, 0, res, 0, this.m.length);
        return res;
    }

    public float[][] getMReference() {
        return this.m;
    }

    public void setM(float[][] m) {
        this.m = m;
    }

    public String toString() {
        return "((" + this.get(0, 0) + "/" + this.get(0, 1) + "/" + this.get(0, 2) + "/" + this.get(0, 3) + ")," + "(" + this.get(1, 0) + "/" + this.get(1, 1) + "/" + this.get(1, 2) + "/" + this.get(1, 3) + ")," + "(" + this.get(2, 0) + "/" + this.get(2, 1) + "/" + this.get(2, 2) + "/" + this.get(2, 3) + ")," + "(" + this.get(3, 0) + "/" + this.get(3, 1) + "/" + this.get(3, 2) + "/" + this.get(3, 3) + ")," + ")";
    }
}

