/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.math;

import org.achtern.AchternEngine.core.math.Matrix4f;
import org.achtern.AchternEngine.core.math.Vector3f;

public class Quaternion {
    private float x;
    private float y;
    private float z;
    private float w;

    public Quaternion(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Quaternion(Quaternion q) {
        this(q.getX(), q.getY(), q.getZ(), q.getW());
    }

    public Quaternion() {
        this(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Quaternion(Vector3f axis, float angle) {
        this();
        this.initRotation(axis, angle);
    }

    public Quaternion(Matrix4f rotationMatrix) {
        this.fromRotationMatrix(rotationMatrix);
    }

    public Quaternion fromRotationMatrix(Matrix4f rotationMatrix) {
        float s;
        float trace = rotationMatrix.get(0, 0) + rotationMatrix.get(1, 1) + rotationMatrix.get(2, 2);
        if (trace > 0.0f) {
            s = 0.5f / (float)Math.sqrt(trace + 1.0f);
            this.setX((rotationMatrix.get(1, 2) - rotationMatrix.get(2, 1)) * s);
            this.setY((rotationMatrix.get(2, 0) - rotationMatrix.get(0, 2)) * s);
            this.setZ((rotationMatrix.get(0, 1) - rotationMatrix.get(1, 0)) * s);
            this.setW(0.25f / s);
        } else if (rotationMatrix.get(0, 0) > rotationMatrix.get(1, 1) && rotationMatrix.get(0, 0) > rotationMatrix.get(2, 2)) {
            s = 2.0f * (float)Math.sqrt(1.0f + rotationMatrix.get(0, 0) - rotationMatrix.get(1, 1) - rotationMatrix.get(2, 2));
            this.setX(0.25f * s);
            this.setY((rotationMatrix.get(1, 0) + rotationMatrix.get(0, 1)) / s);
            this.setZ((rotationMatrix.get(2, 0) + rotationMatrix.get(0, 2)) / s);
            this.setW((rotationMatrix.get(1, 2) - rotationMatrix.get(2, 1)) / s);
        } else if (rotationMatrix.get(1, 1) > rotationMatrix.get(2, 2)) {
            s = 2.0f * (float)Math.sqrt(1.0f + rotationMatrix.get(1, 1) - rotationMatrix.get(0, 0) - rotationMatrix.get(2, 2));
            this.setX((rotationMatrix.get(1, 0) + rotationMatrix.get(0, 1)) / s);
            this.setY(0.25f * s);
            this.setZ((rotationMatrix.get(2, 1) + rotationMatrix.get(1, 2)) / s);
            this.setW((rotationMatrix.get(2, 0) - rotationMatrix.get(0, 2)) / s);
        } else {
            s = 2.0f * (float)Math.sqrt(rotationMatrix.get(2, 2) - rotationMatrix.get(0, 0) - rotationMatrix.get(1, 1));
            this.setX((rotationMatrix.get(2, 0) + rotationMatrix.get(0, 2)) / s);
            this.setY((rotationMatrix.get(1, 2) + rotationMatrix.get(2, 1)) / s);
            this.setZ(0.25f * s);
            this.setW((rotationMatrix.get(0, 1) - rotationMatrix.get(1, 0)) / s);
        }
        float length = (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
        this.x /= length;
        this.y /= length;
        this.z /= length;
        this.w /= length;
        return this;
    }

    public Quaternion initRotation(Vector3f axis, float angle) {
        float sAngle = (float)Math.sin(angle / 2.0f);
        float cAngle = (float)Math.cos(angle / 2.0f);
        this.setX(axis.getX() * sAngle);
        this.setY(axis.getY() * sAngle);
        this.setZ(axis.getZ() * sAngle);
        this.setW(cAngle);
        return this;
    }

    public Quaternion faceAt(Vector3f direction, Vector3f up) {
        return this.fromRotationMatrix(new Matrix4f().initRotation(direction.normalized(), up));
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
    }

    public void normalize() {
        float l = this.length();
        this.x /= l;
        this.y /= l;
        this.z /= l;
        this.w /= l;
    }

    public Quaternion normalized() {
        float l = this.length();
        return new Quaternion(this.x / l, this.y / l, this.z / l, this.w / l);
    }

    public Quaternion conjugate() {
        return new Quaternion(-this.x, -this.y, -this.z, this.w);
    }

    public Quaternion mul(Quaternion q) {
        float _x = this.x * q.getW() + this.w * q.getX() + this.y * q.getZ() - this.z * q.getY();
        float _y = this.y * q.getW() + this.w * q.getY() + this.z * q.getX() - this.x * q.getZ();
        float _z = this.z * q.getW() + this.w * q.getZ() + this.x * q.getY() - this.y * q.getX();
        float _w = this.w * q.getW() - this.x * q.getX() - this.y * q.getY() - this.z * q.getZ();
        return new Quaternion(_x, _y, _z, _w);
    }

    public Quaternion mul(Vector3f v) {
        float _x = this.w * v.getX() + this.y * v.getZ() - this.z * v.getY();
        float _y = this.w * v.getY() + this.z * v.getX() - this.x * v.getZ();
        float _z = this.w * v.getZ() + this.x * v.getY() - this.y * v.getX();
        float _w = -this.x * v.getX() - this.y * v.getY() - this.z * v.getZ();
        return new Quaternion(_x, _y, _z, _w);
    }

    public Quaternion mul(float q) {
        return new Quaternion(this.x * q, this.y * q, this.z * q, this.w * q);
    }

    public Vector3f mult(Vector3f v) {
        Vector3f r = new Vector3f(0.0f, 0.0f, 0.0f);
        if (v.isNullVector()) {
            return r;
        }
        float vx = v.getX();
        float vy = v.getY();
        float vz = v.getZ();
        r.setX(this.getW() * this.getW() * vx + 2.0f * this.getY() * this.getW() * vz - 2.0f * this.getZ() * this.getW() * vy + this.getX() * this.getX() * vx + 2.0f * this.getY() * this.getX() * vy + 2.0f * this.getZ() * this.getX() * vz - this.getZ() * this.getZ() * vx - this.getY() * this.getY() * vx);
        r.setY(2.0f * this.getX() * this.getY() * vx + this.getY() * this.getY() * vy + 2.0f * this.getZ() * this.getY() * vz + 2.0f * this.getW() * this.getZ() * vx - this.getZ() * this.getZ() * vy + this.getW() * this.getW() * vy - 2.0f * this.getX() * this.getW() * vz - this.getX() * this.getX() * vy);
        r.setX(2.0f * this.getX() * this.getZ() * vx + 2.0f * this.getY() * this.getZ() * vy + this.getZ() * this.getZ() * vz - 2.0f * this.getW() * this.getY() * vx - this.getY() * this.getY() * vz + 2.0f * this.getW() * this.getX() * vy - this.getX() * this.getX() * vz + this.getW() * this.getW() * vz);
        return r;
    }

    public Quaternion sub(Quaternion q) {
        return new Quaternion(this.getX() - q.getX(), this.getY() - q.getY(), this.getZ() - q.getZ(), this.getW() - q.getW());
    }

    public Quaternion add(Quaternion q) {
        return new Quaternion(this.getX() + q.getX(), this.getY() + q.getY(), this.getZ() + q.getZ(), this.getW() + q.getW());
    }

    public float dot(Quaternion q) {
        return this.getX() * q.getX() + this.getY() * q.getY() + this.getZ() * q.getZ() + this.getW() * q.getW();
    }

    public Matrix4f toRotationMatrix() {
        Vector3f f = new Vector3f(2.0f * (this.x * this.z - this.w * this.y), 2.0f * (this.y * this.z + this.w * this.x), 1.0f - 2.0f * (this.x * this.x + this.y * this.y));
        Vector3f u = new Vector3f(2.0f * (this.x * this.y + this.w * this.z), 1.0f - 2.0f * (this.x * this.x + this.z * this.z), 2.0f * (this.y * this.z - this.w * this.x));
        Vector3f r = new Vector3f(1.0f - 2.0f * (this.y * this.y + this.z * this.z), 2.0f * (this.x * this.y - this.w * this.z), 2.0f * (this.x * this.z + this.w * this.y));
        return new Matrix4f().initRotation(f, u, r);
    }

    public Quaternion nlerp(Quaternion dest, float factor, boolean shortest) {
        if (shortest && this.dot(dest) < 0.0f) {
            dest = new Quaternion(-dest.getX(), -dest.getY(), -dest.getZ(), -dest.getW());
        }
        return dest.sub(this).mul(factor).add(this).normalized();
    }

    public Vector3f getForward() {
        return new Vector3f(0.0f, 0.0f, 1.0f).rotate(this);
    }

    public Vector3f getBack() {
        return new Vector3f(0.0f, 0.0f, -1.0f).rotate(this);
    }

    public Vector3f getUp() {
        return new Vector3f(0.0f, 1.0f, 0.0f).rotate(this);
    }

    public Vector3f getDown() {
        return new Vector3f(0.0f, -1.0f, 0.0f).rotate(this);
    }

    public Vector3f getRight() {
        return new Vector3f(1.0f, 0.0f, 0.0f).rotate(this);
    }

    public Vector3f getLeft() {
        return new Vector3f(-1.0f, 0.0f, 0.0f).rotate(this);
    }

    public void set(Quaternion q) {
        this.setX(q.getX());
        this.setY(q.getY());
        this.setZ(q.getZ());
        this.setW(q.getW());
    }

    public float getW() {
        return this.w;
    }

    public void setW(float w) {
        this.w = w;
    }

    public float getZ() {
        return this.z;
    }

    public void setZ(float z) {
        this.z = z;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public boolean equals(Quaternion q) {
        return this.x == q.getX() && this.y == q.getY() && this.z == q.getZ() && this.w == q.getW();
    }

    public boolean equals(Object obj) {
        return obj instanceof Quaternion && this.equals((Quaternion)obj);
    }

    public String toString() {
        return "(" + this.getX() + "/" + this.getY() + "/" + this.getZ() + "/" + this.getW() + ")";
    }
}

