/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.math;

import java.beans.ConstructorProperties;
import org.achtern.AchternEngine.core.math.Vector3f;
import org.achtern.AchternEngine.core.rendering.Color;

public class Vector4f {
    public static final Vector4f ZERO = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
    public static final Vector4f UNIT_X = new Vector4f(1.0f, 0.0f, 0.0f, 0.0f);
    public static final Vector4f UNIT_Y = new Vector4f(0.0f, 1.0f, 0.0f, 0.0f);
    public static final Vector4f UNIT_Z = new Vector4f(0.0f, 0.0f, 1.0f, 0.0f);
    public static final Vector4f UNIT_W = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
    public static final Vector4f ONE = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    private float x;
    private float y;
    private float z;
    private float w;

    public Vector4f(Vector4f vec) {
        this(vec.getX(), vec.getY(), vec.getZ(), vec.getW());
    }

    public Vector4f(Vector3f vec, float w) {
        this(vec.getX(), vec.getY(), vec.getZ(), w);
    }

    public void set(float x, float y, float z, float w) {
        this.setX(x);
        this.setY(y);
        this.setZ(z);
        this.setW(w);
    }

    public Vector3f getXYZ() {
        return new Vector3f(this.getX(), this.getY(), this.getZ());
    }

    public boolean isNullVector() {
        return this.getXYZ().isNullVector() && this.getW() == 0.0f;
    }

    public String toString() {
        return "(" + this.getX() + "/" + this.getY() + "/" + this.getZ() + "/" + this.getW() + ")";
    }

    public Color toColor() {
        return new Color(this);
    }

    @ConstructorProperties(value={"x", "y", "z", "w"})
    public Vector4f(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public float getW() {
        return this.w;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setZ(float z) {
        this.z = z;
    }

    public void setW(float w) {
        this.w = w;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Vector4f)) {
            return false;
        }
        Vector4f other = (Vector4f)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Float.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Float.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        return Float.compare(this.getW(), other.getW()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Vector4f;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getX());
        result = result * 59 + Float.floatToIntBits(this.getY());
        result = result * 59 + Float.floatToIntBits(this.getZ());
        result = result * 59 + Float.floatToIntBits(this.getW());
        return result;
    }
}

