/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.rendering;

import org.achtern.AchternEngine.core.rendering.Color;
import org.achtern.AchternEngine.core.rendering.texture.Texture;
import org.achtern.AchternEngine.core.resource.ResourceLoader;
import org.achtern.AchternEngine.core.util.CommonDataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Material
extends CommonDataStore {
    public static final Logger LOGGER = LoggerFactory.getLogger(Material.class);
    protected boolean wireframe = false;

    public Texture getTexture(String name) {
        Texture r = super.getTexture(name);
        if (r != null) {
            return r;
        }
        try {
            return ResourceLoader.getTexture("missing.jpg");
        }
        catch (Exception e) {
            LOGGER.error("BREAK IN THE SPACETIME! MISSING BUNDLED TEXTURE!", (Throwable)e);
            return null;
        }
    }

    public void setColor(Color color) {
        this.addColor("color", color);
    }

    public Color getColor() {
        Color c = this.getColor("color");
        if (c == null) {
            return Color.WHITE;
        }
        return c;
    }

    public void asWireframe(boolean wireframe) {
        this.wireframe = wireframe;
    }

    public boolean isWireframe() {
        return this.wireframe;
    }
}

