/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.rendering;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import org.achtern.AchternEngine.core.math.Vector2f;
import org.achtern.AchternEngine.core.math.Vector3f;

public class Vertex {
    public static final int SIZE = 8;
    protected Vector3f pos;
    protected Vector2f texCor;
    protected Vector3f normal;

    public static Vertex[] toArray(float[] positions) {
        ArrayList<Vertex> r = new ArrayList<Vertex>(positions.length / 3);
        for (int i = 0; i < positions.length; i += 3) {
            r.add(new Vertex(new Vector3f(positions[i], positions[i + 1], positions[i + 2])));
        }
        return r.toArray(new Vertex[r.size()]);
    }

    public static Vertex[] toArray(float[] positions, float[] texCoords) {
        Vertex[] r = Vertex.toArray(positions);
        for (int i = 0; i < texCoords.length; i += 2) {
            r[i].setTexCor(new Vector2f(texCoords[i], texCoords[i + 1]));
        }
        return r;
    }

    public static Vertex[] toArray(float[] positions, float[] texCoords, float[] normals) {
        Vertex[] r = Vertex.toArray(positions, texCoords);
        for (int i = 0; i < normals.length; i += 3) {
            r[i].setNormal(new Vector3f(texCoords[i], texCoords[i + 1], texCoords[i + 2]));
        }
        return r;
    }

    public Vertex(Vector3f pos) {
        this(pos, new Vector2f(0.0f, 0.0f));
    }

    public Vertex(Vector3f pos, Vector2f texCor) {
        this(pos, texCor, new Vector3f(0.0f, 0.0f, 0.0f));
    }

    public Vertex(float x, float y, float z, float texX, float texY) {
        this(new Vector3f(x, y, z), new Vector2f(texX, texY));
    }

    @ConstructorProperties(value={"pos", "texCor", "normal"})
    public Vertex(Vector3f pos, Vector2f texCor, Vector3f normal) {
        this.pos = pos;
        this.texCor = texCor;
        this.normal = normal;
    }

    public Vector3f getPos() {
        return this.pos;
    }

    public Vector2f getTexCor() {
        return this.texCor;
    }

    public Vector3f getNormal() {
        return this.normal;
    }

    public void setPos(Vector3f pos) {
        this.pos = pos;
    }

    public void setTexCor(Vector2f texCor) {
        this.texCor = texCor;
    }

    public void setNormal(Vector3f normal) {
        this.normal = normal;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Vertex)) {
            return false;
        }
        Vertex other = (Vertex)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Vector3f this$pos = this.getPos();
        Vector3f other$pos = other.getPos();
        if (this$pos == null ? other$pos != null : !((Object)this$pos).equals(other$pos)) {
            return false;
        }
        Vector2f this$texCor = this.getTexCor();
        Vector2f other$texCor = other.getTexCor();
        if (this$texCor == null ? other$texCor != null : !((Object)this$texCor).equals(other$texCor)) {
            return false;
        }
        Vector3f this$normal = this.getNormal();
        Vector3f other$normal = other.getNormal();
        return !(this$normal == null ? other$normal != null : !((Object)this$normal).equals(other$normal));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Vertex;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Vector3f $pos = this.getPos();
        result = result * 59 + ($pos == null ? 0 : $pos.hashCode());
        Vector2f $texCor = this.getTexCor();
        result = result * 59 + ($texCor == null ? 0 : ((Object)$texCor).hashCode());
        Vector3f $normal = this.getNormal();
        result = result * 59 + ($normal == null ? 0 : $normal.hashCode());
        return result;
    }

    public String toString() {
        return "Vertex(pos=" + this.getPos() + ", texCor=" + this.getTexCor() + ", normal=" + this.getNormal() + ")";
    }
}

