/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.rendering.light;

import java.beans.ConstructorProperties;
import org.achtern.AchternEngine.core.math.Vector3f;

public class Attenuation {
    protected float constant;
    protected float linear;
    protected float exponent;

    public Attenuation(Vector3f attenuation) {
        this(attenuation.getX(), attenuation.getY(), attenuation.getZ());
    }

    @ConstructorProperties(value={"constant", "linear", "exponent"})
    public Attenuation(float constant, float linear, float exponent) {
        this.constant = constant;
        this.linear = linear;
        this.exponent = exponent;
    }

    public float getConstant() {
        return this.constant;
    }

    public float getLinear() {
        return this.linear;
    }

    public float getExponent() {
        return this.exponent;
    }

    public void setConstant(float constant) {
        this.constant = constant;
    }

    public void setLinear(float linear) {
        this.linear = linear;
    }

    public void setExponent(float exponent) {
        this.exponent = exponent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Attenuation)) {
            return false;
        }
        Attenuation other = (Attenuation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getConstant(), other.getConstant()) != 0) {
            return false;
        }
        if (Float.compare(this.getLinear(), other.getLinear()) != 0) {
            return false;
        }
        return Float.compare(this.getExponent(), other.getExponent()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Attenuation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getConstant());
        result = result * 59 + Float.floatToIntBits(this.getLinear());
        result = result * 59 + Float.floatToIntBits(this.getExponent());
        return result;
    }

    public String toString() {
        return "Attenuation(constant=" + this.getConstant() + ", linear=" + this.getLinear() + ", exponent=" + this.getExponent() + ")";
    }
}

