/*
 * Decompiled with CFR 0.152.
 */
package org.achtern.AchternEngine.core.rendering.mesh;

import java.util.Arrays;
import org.achtern.AchternEngine.core.bootstrap.NativeObject;
import org.achtern.AchternEngine.core.rendering.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeshData
extends NativeObject {
    public static final Logger LOGGER = LoggerFactory.getLogger(MeshData.class);
    protected int vbo;
    protected int ibo;
    protected int size;
    protected Vertex[] vertices;
    protected int[] indices;
    protected Mode mode = Mode.TRIANGLES;

    public void setBufferIDs(int vbo, int ibo) {
        this.vbo = vbo;
        this.ibo = ibo;
    }

    public void set(Vertex[] vertices, int[] indices) {
        this.set(vertices, indices, indices.length);
    }

    public void set(Vertex[] vertices, int[] indices, int size) {
        if (this.getID() != -1) {
            if (this.getVertices() == vertices && this.getIndices() == indices && this.getSize() == size) {
                return;
            }
            this.setID(-1);
        }
        this.setSize(size);
        this.setVertices(vertices);
        this.setIndices(indices);
    }

    public int getVertexCount() {
        return this.getVertices().length;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MeshData)) {
            return false;
        }
        MeshData other = (MeshData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getVbo() != other.getVbo()) {
            return false;
        }
        if (this.getIbo() != other.getIbo()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getVertices(), other.getVertices())) {
            return false;
        }
        if (!Arrays.equals(this.getIndices(), other.getIndices())) {
            return false;
        }
        Mode this$mode = this.getMode();
        Mode other$mode = other.getMode();
        return !(this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MeshData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getVbo();
        result = result * 59 + this.getIbo();
        result = result * 59 + this.getSize();
        result = result * 59 + Arrays.deepHashCode(this.getVertices());
        result = result * 59 + Arrays.hashCode(this.getIndices());
        Mode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 0 : ((Object)((Object)$mode)).hashCode());
        return result;
    }

    public int getVbo() {
        return this.vbo;
    }

    public int getIbo() {
        return this.ibo;
    }

    public int getSize() {
        return this.size;
    }

    public Vertex[] getVertices() {
        return this.vertices;
    }

    public int[] getIndices() {
        return this.indices;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setVbo(int vbo) {
        this.vbo = vbo;
    }

    public void setIbo(int ibo) {
        this.ibo = ibo;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setVertices(Vertex[] vertices) {
        this.vertices = vertices;
    }

    public void setIndices(int[] indices) {
        this.indices = indices;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public String toString() {
        return "MeshData(vbo=" + this.getVbo() + ", ibo=" + this.getIbo() + ", size=" + this.getSize() + ", vertices=" + Arrays.deepToString(this.getVertices()) + ", indices=" + Arrays.toString(this.getIndices()) + ", mode=" + (Object)((Object)this.getMode()) + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        TRIANGLES,
        LINES,
        LINE_LOOP;

    }
}

